/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.dom.client.CanvasGradient;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.racemap.MarkVectorGraphics;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;

public abstract class AbstractMarkVectorGraphics
implements MarkVectorGraphics {
    protected Distance markHeightInMeters;
    protected Distance markWidthInMeters;
    protected final String color;
    protected final String shape;
    protected final String pattern;
    protected final MarkType type;
    protected static final double doublePi = Math.PI * 2;
    protected double anchorPointX = 0.44;
    protected double anchorPointY = 1.67;
    protected static final String DEFAULT_MARK_COLOR = "#f9ac00";
    protected static final String DEFAULT_MARK_BG_COLOR = "#f0f0f0";

    public AbstractMarkVectorGraphics(MarkType type, Color color, String shape, String pattern) {
        this.type = type;
        this.color = color == null ? null : color.getAsHtml();
        this.shape = shape;
        this.pattern = pattern;
        this.markHeightInMeters = new MeterDistance(2.1);
        this.markWidthInMeters = new MeterDistance(1.5);
    }

    public void drawMarkToCanvas(Context2d ctx, boolean isSelected, double width, double height, double scaleFactor) {
        ctx.save();
        ctx.clearRect(0.0, 0.0, width, height);
        ctx.translate(width / 2.0, height / 2.0);
        ctx.scale(scaleFactor, scaleFactor);
        ctx.translate(-this.anchorPointX * 100.0, -this.anchorPointY * 100.0);
        String markColor = this.color != null ? this.color : DEFAULT_MARK_COLOR;
        this.drawMark(ctx, isSelected, markColor);
        ctx.restore();
    }

    public Distance getMarkHeight() {
        return this.markHeightInMeters;
    }

    public Distance getMarkWidth() {
        return this.markWidthInMeters;
    }

    protected void drawMark(Context2d ctx, boolean isSelected, String color) {
        if (isSelected) {
            this.drawMarkSelection(ctx);
        }
        this.drawMarkBody(ctx, isSelected, color);
    }

    protected void drawMarkSelection(Context2d ctx) {
        ctx.save();
        this.setUpScaleAndTranslateForMarkSelection(ctx);
        CanvasGradient g1 = ctx.createLinearGradient(77.8, 188.0, 165.0, 219.0);
        g1.addColorStop(0.0, "rgba(240, 240, 240, 1)");
        g1.addColorStop(1.0, "rgba(240, 240, 240, 0)");
        ctx.setFillStyle((FillStrokeStyle)g1);
        ctx.beginPath();
        ctx.moveTo(170.0, 181.0);
        ctx.translate(44.000168893718424, 180.79369636814624);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, 0.0016373311430805408, 0.5254904360229328, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-44.000168893718424, -180.79369636814624);
        ctx.lineTo(44.2, 181.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        CanvasGradient g2 = ctx.createLinearGradient(51.0, 203.0, 77.3, 302.0);
        g2.addColorStop(0.0, "rgba(255, 255, 255, 1)");
        g2.addColorStop(1.0, "rgba(255, 255, 255, 0)");
        ctx.setFillStyle((FillStrokeStyle)g2);
        ctx.beginPath();
        ctx.moveTo(107.0, 290.0);
        ctx.translate(43.79222318749837, 181.0010231680087);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, 1.0452923752792398, 1.5667663411841573, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-43.79222318749837, -181.0010231680087);
        ctx.lineTo(44.2, 181.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        CanvasGradient g3 = ctx.createLinearGradient(26.8, 197.0, -46.5, 269.0);
        g3.addColorStop(0.0, "rgba(255, 255, 255, 1)");
        g3.addColorStop(1.0, "rgba(255, 255, 255, 0)");
        ctx.setFillStyle((FillStrokeStyle)g3);
        ctx.beginPath();
        ctx.moveTo(-18.3, 290.0);
        ctx.translate(43.72636289026038, 180.32443158749652);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, 2.0854951576078884, 2.611791628699119, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-43.72636289026038, -180.32443158749652);
        ctx.lineTo(44.2, 181.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        CanvasGradient g4 = ctx.createLinearGradient(18.7, 172.0, -76.3, 140.0);
        g4.addColorStop(0.0, "rgba(255, 255, 255, 1)");
        g4.addColorStop(1.0, "rgba(255, 255, 255, 0)");
        ctx.setFillStyle((FillStrokeStyle)g4);
        ctx.beginPath();
        ctx.moveTo(-81.8, 179.0);
        ctx.translate(44.19920011832349, 178.55103503179944);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, 3.1380294320163484, 3.670248678643417, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-44.19920011832349, -178.55103503179944);
        ctx.lineTo(44.2, 179.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        CanvasGradient g5 = ctx.createLinearGradient(37.9, 147.0, 13.6, 58.6);
        g5.addColorStop(0.0, "rgba(255, 255, 255, 1)");
        g5.addColorStop(1.0, "rgba(255, 255, 255, 0)");
        ctx.setFillStyle((FillStrokeStyle)g5);
        ctx.beginPath();
        ctx.moveTo(-18.7, 71.8);
        ctx.translate(44.160311222571984, 180.99973110315514);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, -2.0931154263055687, -1.5728622903484606, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-44.160311222571984, -180.99973110315514);
        ctx.lineTo(44.199999999999996, 181.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        CanvasGradient g6 = ctx.createLinearGradient(80.8, 139.0, 134.0, 91.9);
        g6.addColorStop(0.0, "rgba(240, 240, 240, 1)");
        g6.addColorStop(1.0, "rgba(240, 240, 240, 0)");
        ctx.setFillStyle((FillStrokeStyle)g6);
        ctx.beginPath();
        ctx.moveTo(108.0, 72.1);
        ctx.translate(43.50304481630927, 180.3411325330301);
        ctx.rotate(0.0);
        ctx.scale(1.0, 1.0);
        ctx.arc(0.0, 0.0, 126.0, -1.0334238189446499, -0.5175711746742696, false);
        ctx.scale(1.0, 1.0);
        ctx.rotate(0.0);
        ctx.translate(-43.50304481630927, -180.3411325330301);
        ctx.lineTo(44.2, 181.0);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        ctx.translate(-49.5, 17.2);
        ctx.restore();
    }

    protected void setUpScaleAndTranslateForMarkSelection(Context2d ctx) {
        ctx.scale(1.2, 1.2);
        ctx.translate(-10.0, -30.0);
    }

    protected abstract void drawMarkBody(Context2d var1, boolean var2, String var3);

    public Bearing getRotationInDegrees(CoursePositionsDTO coursePositionsDTO) {
        return null;
    }
}

