/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.PlacemarkOrderDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupBaseDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class LeaderboardGroupDTO
extends LeaderboardGroupBaseDTO {
    private static final long serialVersionUID = -2923229069598593687L;
    public List<StrippedLeaderboardDTO> leaderboards;
    public boolean displayLeaderboardsInReverseOrder;
    private int[] overallLeaderboardDiscardThresholds;
    private ScoringSchemeType overallLeaderboardScoringSchemeType;
    private Date currentServerTime;

    @Deprecated
    LeaderboardGroupDTO() {
    }

    public LeaderboardGroupDTO(UUID id, String displayName) {
        this(id, "", displayName);
    }

    public LeaderboardGroupDTO(UUID id, String name, String displayName) {
        this(id, name, displayName, "");
    }

    public LeaderboardGroupDTO(UUID id, String name, String displayName, String description) {
        this(id, name, description, displayName, new ArrayList());
    }

    private LeaderboardGroupDTO(UUID id, String name, String description, String displayName, List<StrippedLeaderboardDTO> leaderboards) {
        super(id, name, description, displayName, false);
        this.currentServerTime = new Date();
        this.leaderboards = leaderboards;
    }

    public boolean hasOverallLeaderboard() {
        return this.getOverallLeaderboardScoringSchemeType() != null;
    }

    public int[] getOverallLeaderboardDiscardThresholds() {
        return this.overallLeaderboardDiscardThresholds;
    }

    public void setOverallLeaderboardDiscardThresholds(int[] overallLeaderboardDiscardThresholds) {
        this.overallLeaderboardDiscardThresholds = overallLeaderboardDiscardThresholds;
    }

    public ScoringSchemeType getOverallLeaderboardScoringSchemeType() {
        return this.overallLeaderboardScoringSchemeType;
    }

    public void setOverallLeaderboardScoringSchemeType(ScoringSchemeType overallLeaderboardScoringSchemeType) {
        this.overallLeaderboardScoringSchemeType = overallLeaderboardScoringSchemeType;
    }

    public List<StrippedLeaderboardDTO> getLeaderboardsInReverseOrder() {
        ArrayList leaderboardsInReverseOrder = new ArrayList(this.leaderboards);
        Collections.reverse(leaderboardsInReverseOrder);
        return Collections.unmodifiableList(leaderboardsInReverseOrder);
    }

    public boolean containsRegattaLeaderboard() {
        boolean result = false;
        for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            if (!leaderboard.type.isRegattaLeaderboard()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean containsRace(RaceIdentifier race) {
        boolean containsRace = false;
        block0: for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            for (RaceColumnDTO raceInLeaderboard : leaderboard.getRaceList()) {
                for (FleetDTO fleet : raceInLeaderboard.getFleets()) {
                    RegattaAndRaceIdentifier raceIdentifierForFleet = raceInLeaderboard.getRaceIdentifier(fleet);
                    if (raceIdentifierForFleet == null || !raceIdentifierForFleet.equals(race)) continue;
                    containsRace = true;
                    break block0;
                }
            }
        }
        return containsRace;
    }

    public Date getGroupStartDate() {
        Date groupStart = null;
        for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            Date leaderboardStart = leaderboard.getStartDate();
            if (leaderboardStart == null) continue;
            if (groupStart == null) {
                groupStart = new Date();
            }
            Date date = groupStart = groupStart.before(leaderboardStart) ? groupStart : leaderboardStart;
        }
        return groupStart;
    }

    public List<PlacemarkOrderDTO> getGroupPlaces() {
        ArrayList<PlacemarkOrderDTO> places = new ArrayList<PlacemarkOrderDTO>();
        for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            PlacemarkOrderDTO leaderboardPlaces = leaderboard.getPlaces();
            if (leaderboardPlaces == null) continue;
            places.add(leaderboardPlaces);
        }
        return places;
    }

    public boolean hasLiveRace(long serverTimePointAsMillis) {
        for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            if (!leaderboard.hasLiveRace(serverTimePointAsMillis)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 31 * result + (this.leaderboards == null ? 0 : this.leaderboards.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeaderboardGroupDTO other = (LeaderboardGroupDTO)obj;
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        return !(this.leaderboards == null ? other.leaderboards != null : !this.leaderboards.equals(other.leaderboards));
    }

    public List<StrippedLeaderboardDTO> getLeaderboards() {
        return this.leaderboards;
    }

    public Long getAverageDelayToLiveInMillis() {
        Long result = null;
        long delaySum = 0L;
        long count = 0L;
        for (StrippedLeaderboardDTO leaderboard : this.leaderboards) {
            if (leaderboard.getDelayToLiveInMillisForLatestRace() == null) continue;
            delaySum += leaderboard.getDelayToLiveInMillisForLatestRace().longValue();
            ++count;
        }
        if (count > 0L) {
            result = delaySum / count;
        }
        return result;
    }

    public Date getCurrentServerTime() {
        return this.currentServerTime;
    }
}

