/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.gwt.ui.client.shared.SailingVideoDTO;
import com.sap.sailing.gwt.ui.shared.EventLinkDTO;
import com.sap.sailing.gwt.ui.shared.EventReferenceDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupBaseDTO;
import com.sap.sailing.gwt.ui.shared.SailingImageDTO;
import com.sap.sailing.gwt.ui.shared.VenueDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.media.ImageSize;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.security.shared.dto.NamedDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EventBaseDTO
extends NamedDTO
implements WithID,
IsSerializable {
    private static final long serialVersionUID = 818666323178097939L;
    private VenueDTO venue;
    public Date startDate;
    public Date endDate;
    public boolean isPublic;
    public UUID id;
    private String description;
    private List<? extends LeaderboardGroupBaseDTO> leaderboardGroups;
    private String officialWebsiteURL;
    private Map<String, String> sailorsInfoWebsiteURLs;
    private List<SailingImageDTO> images = new ArrayList();
    private List<SailingVideoDTO> videos = new ArrayList();
    private Map<String, ImageSize> imageSizes;
    private String baseURL;
    private boolean isOnRemoteServer;

    @Deprecated
    EventBaseDTO() {
    }

    public EventBaseDTO(String name, List<? extends LeaderboardGroupBaseDTO> leaderboardGroups) {
        super(name);
        this.leaderboardGroups = leaderboardGroups;
        this.imageSizes = new HashMap();
        this.sailorsInfoWebsiteURLs = new HashMap();
    }

    public boolean equals(Object o) {
        return Util.equalsWithNull((Object)this.getId(), (Object)((EventBaseDTO)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public UUID getId() {
        return this.id;
    }

    public ImageDTO getLogoImage() {
        ImageDTO result = null;
        for (ImageDTO image : this.images) {
            if (!image.hasTag(MediaTagConstants.LOGO.getName())) continue;
            result = image;
            break;
        }
        return result;
    }

    public boolean isRunning() {
        Date now = new Date();
        return this.startDate != null && this.endDate != null && now.after(this.startDate) && now.before(this.endDate);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOfficialWebsiteURL() {
        return this.officialWebsiteURL;
    }

    private String getUrlWithHttpsAsDefaultProtocolIfMissing(String url) {
        String result = url != null && !url.contains("://") ? "https://" + url : url;
        return result;
    }

    public void setOfficialWebsiteURL(String officialWebsiteURL) {
        this.officialWebsiteURL = this.getUrlWithHttpsAsDefaultProtocolIfMissing(officialWebsiteURL);
    }

    public Map<String, String> getSailorsInfoWebsiteURLs() {
        return this.sailorsInfoWebsiteURLs;
    }

    public String getSailorsInfoWebsiteURL(String locale) {
        return (String)this.sailorsInfoWebsiteURLs.get(locale);
    }

    public void setSailorsInfoWebsiteURL(String locale, String url) {
        if (url == null || url.isEmpty()) {
            this.sailorsInfoWebsiteURLs.remove(locale);
        } else {
            this.sailorsInfoWebsiteURLs.put(locale, this.getUrlWithHttpsAsDefaultProtocolIfMissing(url));
        }
    }

    public void setSailorsInfoWebsiteURLs(Map<String, String> sailorsInfoWebsiteURLs) {
        this.sailorsInfoWebsiteURLs.clear();
        for (Map.Entry<String, String> e : sailorsInfoWebsiteURLs.entrySet()) {
            this.sailorsInfoWebsiteURLs.put(e.getKey(), this.getUrlWithHttpsAsDefaultProtocolIfMissing(e.getValue()));
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = this.getUrlWithHttpsAsDefaultProtocolIfMissing(baseURL);
    }

    public Iterable<? extends LeaderboardGroupBaseDTO> getLeaderboardGroups() {
        return this.leaderboardGroups;
    }

    public boolean isOnRemoteServer() {
        return this.isOnRemoteServer;
    }

    public void setIsOnRemoteServer(boolean isOnRemoteServer) {
        this.isOnRemoteServer = isOnRemoteServer;
    }

    public SailingImageDTO addImage(ImageDTO image) {
        SailingImageDTO result = new SailingImageDTO(this.getEventLink(), image);
        this.images.add(result);
        return result;
    }

    public boolean removeImage(SailingImageDTO image) {
        return this.images.remove(image);
    }

    public List<SailingImageDTO> getImages() {
        return this.images;
    }

    private EventLinkDTO getEventLink() {
        EventLinkDTO eventLink = new EventLinkDTO();
        eventLink.setBaseURL(this.getBaseURL());
        eventLink.setDisplayName(this.getName());
        eventLink.setId(this.getId());
        eventLink.setOnRemoteServer(this.isOnRemoteServer());
        return eventLink;
    }

    public SailingVideoDTO addVideo(VideoDTO video) {
        SailingVideoDTO result = new SailingVideoDTO((EventReferenceDTO)this.getEventLink(), video);
        this.videos.add(result);
        return result;
    }

    public boolean removeVideo(SailingVideoDTO video) {
        return this.videos.remove(video);
    }

    public List<SailingVideoDTO> getVideos() {
        return this.videos;
    }

    public void setImageSize(String imageURL, ImageSize imageSize) {
        if (imageSize == null) {
            this.imageSizes.remove(imageURL);
        } else {
            this.imageSizes.put(imageURL, imageSize);
        }
    }

    public ImageSize getImageSize(String imageURL) {
        return (ImageSize)this.imageSizes.get(imageURL);
    }

    public VenueDTO getVenue() {
        return this.venue;
    }

    public void setVenue(VenueDTO venue) {
        this.venue = venue;
    }
}

