/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.domain.common.PathType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.client.SimulatorService;
import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.gwt.ui.server.SimulatorServiceImpl;
import com.sap.sailing.gwt.ui.server.SimulatorServiceUtils;
import com.sap.sailing.gwt.ui.shared.BoatClassDTOsAndNotificationMessage;
import com.sap.sailing.gwt.ui.shared.ConfigurationException;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.PathDTO;
import com.sap.sailing.gwt.ui.shared.PolarDiagramDTO;
import com.sap.sailing.gwt.ui.shared.PolarDiagramDTOAndNotificationMessage;
import com.sap.sailing.gwt.ui.shared.RaceMapDataDTO;
import com.sap.sailing.gwt.ui.shared.Request1TurnerDTO;
import com.sap.sailing.gwt.ui.shared.RequestTotalTimeDTO;
import com.sap.sailing.gwt.ui.shared.Response1TurnerDTO;
import com.sap.sailing.gwt.ui.shared.ResponseTotalTimeDTO;
import com.sap.sailing.gwt.ui.shared.SimulatedPathsEvenTimedResultDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorResultsDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorUISelectionDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.shared.WindLatticeDTO;
import com.sap.sailing.gwt.ui.shared.WindLatticeGenParamsDTO;
import com.sap.sailing.gwt.ui.shared.WindLinesDTO;
import com.sap.sailing.gwt.ui.shared.WindPatternDTO;
import com.sap.sailing.gwt.ui.simulator.windpattern.WindPattern;
import com.sap.sailing.gwt.ui.simulator.windpattern.WindPatternDisplay;
import com.sap.sailing.gwt.ui.simulator.windpattern.WindPatternDisplayManager;
import com.sap.sailing.gwt.ui.simulator.windpattern.WindPatternNotFoundException;
import com.sap.sailing.gwt.ui.simulator.windpattern.WindPatternSetting;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.SimulationService;
import com.sap.sailing.server.simulation.SimulationServiceFactory;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.CurvedGrid;
import com.sap.sailing.simulator.impl.PathGenerator1Turner;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.SimulationParametersImpl;
import com.sap.sailing.simulator.impl.SimulatorImpl;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.WindFieldGeneratorFactory;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorMeasured;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.server.DelegatingProxiedRemoteServiceServlet;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SimulatorServiceImpl
extends DelegatingProxiedRemoteServiceServlet
implements SimulatorService {
    private static final long serialVersionUID = 4445427185387524086L;
    private static final Logger logger = Logger.getLogger(SimulatorServiceImpl.class.getName());
    private static final Logger LOGGER = Logger.getLogger("com.sap.sailing");
    private static final WindFieldGeneratorFactory wfGenFactory = WindFieldGeneratorFactory.INSTANCE;
    private static final WindPatternDisplayManager wpDisplayManager = WindPatternDisplayManager.INSTANCE;
    private static final String POLYLINE_PATH_NAME = "Polyline";
    private static final int DEFAULT_STEP_MAX = 800;
    private static final long DEFAULT_TIMESTEP = 6666L;
    private final SimulationService simulationService;
    private double stepSizeMeters = 0.0;
    private WindControlParameters controlParameters = new WindControlParameters(0.0, 0.0);
    private SpeedWithBearing averageWind = null;
    private final PolarDiagramCache polarDiagramCache;
    private final ServiceTracker<RacingEventService, RacingEventService> racingEventServiceTracker;

    public SimulatorServiceImpl() throws InterruptedException {
        ScheduledExecutorService simulatorExecutor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
        this.racingEventServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)Activator.getDefault(), RacingEventService.class);
        this.simulationService = SimulationServiceFactory.INSTANCE.getService(simulatorExecutor, (RacingEventService)this.racingEventServiceTracker.waitForService(0L));
        this.polarDiagramCache = new PolarDiagramCache(this.simulationService);
    }

    public Position[] getRaceLocations() {
        this.checkSimulatorReadPermissionOnCurrentServer();
        DegreePosition lakeGarda = new DegreePosition(45.57055337226086, 10.693345069885254);
        DegreePosition lakeGeneva = new DegreePosition(46.23376539670794, 6.168651580810547);
        DegreePosition kiel = new DegreePosition(54.3232927, 10.122765200000003);
        DegreePosition travemuende = new DegreePosition(53.978276, 10.880156);
        return new Position[]{kiel, lakeGeneva, lakeGarda, travemuende};
    }

    private void checkSimulatorReadPermissionOnCurrentServer() {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.SIMULATOR.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
    }

    public WindLatticeDTO getWindLatice(WindLatticeGenParamsDTO params) {
        this.checkSimulatorReadPermissionOnCurrentServer();
        DegreeBearingImpl north = new DegreeBearingImpl(0.0);
        DegreeBearingImpl east = new DegreeBearingImpl(90.0);
        DegreeBearingImpl south = new DegreeBearingImpl(180.0);
        DegreeBearingImpl west = new DegreeBearingImpl(270.0);
        double xSize = params.getxSize();
        double ySize = params.getySize();
        int gridsizeX = params.getGridsizeX();
        int gridsizeY = params.getGridsizeY();
        Position center = params.getCenter();
        WindLatticeDTO wl = new WindLatticeDTO();
        Position[][] matrix = new Position[gridsizeY][gridsizeX];
        NauticalMileDistance deastwest = new NauticalMileDistance(((double)gridsizeX - 1.0) / (double)(2 * gridsizeX) * xSize);
        NauticalMileDistance dnorthsouth = new NauticalMileDistance(((double)gridsizeY - 1.0) / (double)(2 * gridsizeY) * ySize);
        Position start = center.translateGreatCircle((Bearing)south, (Distance)dnorthsouth).translateGreatCircle((Bearing)west, (Distance)deastwest);
        deastwest = new NauticalMileDistance(xSize / (double)gridsizeX);
        dnorthsouth = new NauticalMileDistance(ySize / (double)gridsizeY);
        Position rowStart = null;
        Position crt = null;
        int i = 0;
        while (i < gridsizeY) {
            rowStart = i == 0 ? start : rowStart.translateGreatCircle((Bearing)north, (Distance)dnorthsouth);
            int j = 0;
            while (j < gridsizeX) {
                if (j == 0) {
                    crt = rowStart;
                } else {
                    crt = crt.translateGreatCircle((Bearing)east, (Distance)deastwest);
                    if (i == 3 && j == 5) {
                        crt = crt.translateGreatCircle((Bearing)north, (Distance)new NauticalMileDistance(ySize / (double)gridsizeY * Math.random()));
                        crt = crt.translateGreatCircle((Bearing)east, (Distance)new NauticalMileDistance(xSize / (double)gridsizeX * Math.random()));
                        crt = crt.translateGreatCircle((Bearing)south, (Distance)new NauticalMileDistance(ySize / (double)gridsizeY * Math.random()));
                        crt = crt.translateGreatCircle((Bearing)west, (Distance)new NauticalMileDistance(xSize / (double)gridsizeX * Math.random()));
                    }
                }
                DegreePosition pdto = new DegreePosition(crt.getLatDeg(), crt.getLngDeg());
                matrix[i][j] = pdto;
                ++j;
            }
            ++i;
        }
        wl.setMatrix(matrix);
        return wl;
    }

    public WindFieldDTO getWindField(WindFieldGenParamsDTO params, WindPatternDisplay pattern) throws WindPatternNotFoundException {
        this.checkSimulatorReadPermissionOnCurrentServer();
        LOGGER.info("Entering getWindField");
        Position start = params.getRaceCourseStart();
        Position end = params.getRaceCourseEnd();
        ArrayList<Position> course = new ArrayList<Position>();
        course.add(start);
        course.add(end);
        CurvedGrid bd = new CurvedGrid(start, end);
        this.controlParameters.resetBlastRandomStream = params.isKeepState();
        this.retrieveWindControlParameters(pattern);
        LOGGER.info("Boundary south direction " + bd.getSouth());
        this.controlParameters.baseWindBearing = this.controlParameters.baseWindBearing + bd.getSouth().getDegrees();
        WindFieldGenerator wf = wfGenFactory.createWindFieldGenerator(pattern.getWindPatternName(), (Grid)bd, this.controlParameters);
        if (wf == null) {
            throw new WindPatternNotFoundException("Please select a valid wind pattern.");
        }
        Position[][] grid = bd.generatePositions(params.getxRes(), params.getyRes(), params.getBorderY(), params.getBorderX());
        wf.setPositionGrid(grid);
        MillisecondsTimePoint startTime = new MillisecondsTimePoint(params.getStartTime().getTime());
        Duration timeStep = params.getTimeStep();
        MillisecondsTimePoint endTime = new MillisecondsTimePoint(params.getEndTime().getTime());
        wf.generate((TimePoint)startTime, null, timeStep);
        if (params.getMode() != 'm') {
            Position[] gridAreaGps = new Position[2];
            gridAreaGps = course.toArray(gridAreaGps);
            wf.setGridAreaGps(gridAreaGps);
        }
        WindFieldDTO wfDTO = this.createWindFieldDTO(wf, (TimePoint)startTime, (TimePoint)endTime, timeStep, params);
        LOGGER.info("Exiting getWindField");
        return wfDTO;
    }

    public List<WindPatternDTO> getWindPatterns(char mode) {
        this.checkSimulatorReadPermissionOnCurrentServer();
        return wpDisplayManager.getWindPatterns(mode);
    }

    public WindPatternDisplay getWindPatternDisplay(WindPatternDTO pattern) {
        this.checkSimulatorReadPermissionOnCurrentServer();
        WindPatternDisplay display = wpDisplayManager.getDisplay(WindPattern.valueOf((String)pattern.getName()));
        try {
            return display;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem getting wind pattern display", e);
            return null;
        }
    }

    public SimulatorResultsDTO getSimulatorResults(char mode, char rcDirection, WindFieldGenParamsDTO params, WindPatternDisplay pattern, boolean withWindField, SimulatorUISelectionDTO selection) throws WindPatternNotFoundException, ConfigurationException {
        this.checkSimulatorReadPermissionOnCurrentServer();
        WindFieldGenerator wf = null;
        ArrayList<Position> course = null;
        MillisecondsTimePoint startTime = new MillisecondsTimePoint(params.getStartTime().getTime());
        Duration timeStep = params.getTimeStep();
        this.controlParameters.resetBlastRandomStream = params.isKeepState();
        this.retrieveWindControlParameters(pattern);
        if (rcDirection == 'd') {
            this.controlParameters.baseWindBearing = this.controlParameters.baseWindBearing + 180.0;
        }
        if ((wf = wfGenFactory.createWindFieldGenerator(pattern.getWindPatternName(), null, this.controlParameters)) == null) {
            throw new WindPatternNotFoundException("Please select a valid wind pattern.");
        }
        if (mode != 'm') {
            Position start = params.getRaceCourseStart();
            Position end = params.getRaceCourseEnd();
            course = new ArrayList<Position>();
            course.add(start);
            course.add(end);
            Position[] gridAreaGps = new Position[2];
            gridAreaGps = course.toArray(gridAreaGps);
            wf.setGridAreaGps(gridAreaGps);
        }
        int[] gridRes = new int[]{params.getxRes(), params.getyRes(), params.getBorderY(), params.getBorderX()};
        wf.setGridResolution(gridRes);
        wf.generate((TimePoint)startTime, null, timeStep);
        Duration longestPathTime = Duration.NULL;
        SimulatedPathsEvenTimedResultDTO simulatedPaths = this.getSimulatedPathsEvenTimed(course, wf, mode, selection, params.showOmniscient, params.showOpportunist);
        PathDTO[] pathDTOs = simulatedPaths.pathDTOs;
        RaceMapDataDTO rcDTO = simulatedPaths.raceMapDataDTO;
        PathDTO[] pathDTOArray = pathDTOs;
        int n = pathDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            PathDTO path = pathDTOArray[n2];
            if (!path.getName().equals(POLYLINE_PATH_NAME)) {
                List points = path.getPoints();
                Duration pathTime = ((SimulatorWindDTO)points.get((int)0)).timepoint.until(((SimulatorWindDTO)points.get((int)(points.size() - 1))).timepoint);
                if (pathTime.compareTo((Object)longestPathTime) > 0) {
                    longestPathTime = pathTime;
                }
            }
            ++n2;
        }
        TimePoint endTime = startTime.plus(longestPathTime);
        WindFieldDTO windFieldDTO = null;
        if (pattern != null) {
            windFieldDTO = this.createWindFieldDTO(wf, (TimePoint)startTime, endTime, timeStep, params);
        }
        return new SimulatorResultsDTO(0L, 0, null, timeStep, Duration.NULL, rcDTO, pathDTOs, windFieldDTO, simulatedPaths.notificationMessage);
    }

    public BoatClassDTOsAndNotificationMessage getBoatClasses() throws ConfigurationException {
        this.checkSimulatorReadPermissionOnCurrentServer();
        BoatClassDTOsAndNotificationMessage result = new BoatClassDTOsAndNotificationMessage();
        result.setBoatClassDTOs(this.polarDiagramCache.getBoatClasses());
        result.setNotificationMessage(this.polarDiagramCache.getNotificationMessage());
        return result;
    }

    public PolarDiagramDTOAndNotificationMessage getPolarDiagram(Double bearingStep, int boatClassIndex) throws ConfigurationException {
        PolarDiagramDTOAndNotificationMessage result;
        this.checkSimulatorReadPermissionOnCurrentServer();
        Util.Pair polarDiagramAndNotificationMessage = this.getPolarDiagram(boatClassIndex);
        if (polarDiagramAndNotificationMessage != null && polarDiagramAndNotificationMessage.getA() != null) {
            NavigableMap navMap = ((PolarDiagram)polarDiagramAndNotificationMessage.getA()).polarDiagramPlot(bearingStep);
            Set validSpeeds = navMap.keySet();
            validSpeeds.remove(Speed.NULL);
            Number[][] series = new Number[validSpeeds.size()][];
            int i = 0;
            for (Speed s : validSpeeds) {
                Collection boatSpeeds = ((NavigableMap)navMap.get(s)).values();
                series[i] = new Number[boatSpeeds.size()];
                int j = 0;
                for (Speed boatSpeed : boatSpeeds) {
                    series[i][j++] = boatSpeed.getKnots();
                }
                ++i;
            }
            PolarDiagramDTO dto = new PolarDiagramDTO();
            dto.setNumberSeries(series);
            result = new PolarDiagramDTOAndNotificationMessage();
            result.setPolarDiagramDTO(dto);
            result.setNotificationMessage((String)polarDiagramAndNotificationMessage.getB());
        } else {
            result = null;
        }
        return result;
    }

    public ResponseTotalTimeDTO getTotalTime(RequestTotalTimeDTO requestData) throws ConfigurationException {
        this.checkSimulatorReadPermissionOnCurrentServer();
        this.averageWind = requestData.useRealAverageWindSpeed ? SimulatorServiceUtils.getAverage((List)requestData.allPoints) : SimulatorServiceUtils.DEFAULT_AVERAGE_WIND;
        this.stepSizeMeters = SimulatorServiceUtils.knotsToMetersPerSecond((double)this.averageWind.getKnots()) * ((double)requestData.stepDurationMilliseconds / 1000.0);
        Util.Pair polarDiagramAndNotificationMessage = this.getPolarDiagram(requestData.selection.boatClassIndex.intValue());
        PolarDiagram polarDiagram = (PolarDiagram)polarDiagramAndNotificationMessage.getA();
        String notificationMessage = (String)polarDiagramAndNotificationMessage.getB();
        SimulatorImpl simulator = new SimulatorImpl((SimulationParameters)new SimulationParametersImpl(null, polarDiagram, null, null, 'm', true, true));
        Path gpsTrack = simulator.getLegGPSTrack(SimulatorServiceUtils.toSimulatorUISelection((SimulatorUISelectionDTO)requestData.selection));
        double totalTimeGPSTrackSeconds = (((TimedPositionWithSpeed)gpsTrack.getPathPoints().get(gpsTrack.getPathPoints().size() - 1)).getTimePoint().asMillis() - ((TimedPositionWithSpeed)gpsTrack.getPathPoints().get(0)).getTimePoint().asMillis()) / 1000L;
        TimePoint startTimePoint = ((SimulatorWindDTO)requestData.allPoints.get((int)0)).timepoint;
        long segmentDurationMillis = 0L;
        int segmentIndex = 0;
        long totalDurationMillis = 0L;
        int index = 0;
        while (index < requestData.turnPoints.size() - 1) {
            segmentDurationMillis = this.getTimeMillisecondsBetween((Position)requestData.turnPoints.get(index), (Position)requestData.turnPoints.get(index + 1), this.stepSizeMeters, requestData.useRealAverageWindSpeed, gpsTrack, polarDiagram, startTimePoint.plus(totalDurationMillis += segmentDurationMillis).asMillis());
            logger.fine("Total time of segment " + ++segmentIndex + " = " + segmentDurationMillis + " milliseconds");
            ++index;
        }
        long totalTimeSeconds = (totalDurationMillis += segmentDurationMillis) / 1000L;
        logger.fine("TotalTimeGPS: " + totalTimeGPSTrackSeconds + "  TotalTimePoly: " + totalTimeSeconds);
        return new ResponseTotalTimeDTO(Long.valueOf(totalTimeSeconds), Double.valueOf((double)totalTimeSeconds / totalTimeGPSTrackSeconds), notificationMessage);
    }

    public Response1TurnerDTO get1Turner(Request1TurnerDTO requestData) throws ConfigurationException {
        this.checkSimulatorReadPermissionOnCurrentServer();
        Util.Pair polarDiagramAndNotificationMessage = this.getPolarDiagram(requestData.selection.boatClassIndex.intValue());
        PolarDiagram polarDiagram = (PolarDiagram)polarDiagramAndNotificationMessage.getA();
        String notificationMessage = (String)polarDiagramAndNotificationMessage.getB();
        Position edgeStart = requestData.edgeStart;
        Position edgeEnd = requestData.edgeEnd;
        Position oldMovedPosition = requestData.oldMovedPoint;
        Position newMovedPosition = requestData.newMovedPoint;
        Bearing oldMovedToNewMovedBearing = oldMovedPosition.getBearingGreatCircle(newMovedPosition);
        boolean areTowardsSameDirection = SimulatorServiceUtils.areTowardsSameDirection((Bearing)oldMovedToNewMovedBearing, (Bearing)new DegreeBearingImpl(requestData.startToEndBearingDegrees.doubleValue()));
        logger.info("oldMovedToNewMovedBearing = " + oldMovedToNewMovedBearing.getDegrees() + " degrees");
        logger.info("requestData.startToEndBearingDegrees = " + requestData.startToEndBearingDegrees + " degrees");
        logger.info("areTowardsSameDirection = " + areTowardsSameDirection);
        SimulationParametersImpl simulationParameters = new SimulationParametersImpl(null, polarDiagram, null, null, 'm', true, true);
        SimulatorImpl sailingSimulator = new SimulatorImpl((SimulationParameters)simulationParameters);
        Path gpsWind = sailingSimulator.getLegGPSTrack(SimulatorServiceUtils.toSimulatorUISelection((SimulatorUISelectionDTO)requestData.selection));
        CurvedGrid grid = new CurvedGrid(oldMovedPosition, newMovedPosition);
        this.controlParameters.baseWindBearing = this.controlParameters.baseWindBearing + grid.getSouth().getDegrees();
        WindFieldGeneratorMeasured windFieldGenerator = new WindFieldGeneratorMeasured((Grid)grid, this.controlParameters);
        windFieldGenerator.setGPSWind(gpsWind);
        MillisecondsTimePoint startTime = new MillisecondsTimePoint(requestData.oldMovedPointTimePoint.longValue());
        PathGenerator1Turner pathGenerator = new PathGenerator1Turner(null);
        TimedPositionWithSpeed leftSide1Turner = null;
        TimedPositionWithSpeed rightSide1Turner = null;
        Position realStart = areTowardsSameDirection ? oldMovedPosition : newMovedPosition;
        Position realEnd = areTowardsSameDirection ? newMovedPosition : oldMovedPosition;
        leftSide1Turner = pathGenerator.get1Turner((WindFieldGenerator)windFieldGenerator, polarDiagram, realStart, realEnd, (TimePoint)startTime, true, 800, 6666L);
        rightSide1Turner = pathGenerator.get1Turner((WindFieldGenerator)windFieldGenerator, polarDiagram, realStart, realEnd, (TimePoint)startTime, false, 800, 6666L);
        boolean isLeftSide1TurnerOnTheInside = SimulatorServiceUtils.isPointInsideTriangle((Position)leftSide1Turner.getPosition(), (Position)requestData.beforeMovedPoint, (Position)requestData.newMovedPoint, (Position)requestData.edgeStart);
        logger.info("isLeftSide1TurnerOnTheInside = " + isLeftSide1TurnerOnTheInside);
        boolean isRightSide1TurnerOnTheInside = SimulatorServiceUtils.isPointInsideTriangle((Position)rightSide1Turner.getPosition(), (Position)requestData.beforeMovedPoint, (Position)requestData.newMovedPoint, (Position)requestData.edgeStart);
        logger.info("isRightSide1TurnerOnTheInside = " + isRightSide1TurnerOnTheInside);
        TimedPositionWithSpeed correct1Turner = null;
        if (isLeftSide1TurnerOnTheInside && !isRightSide1TurnerOnTheInside) {
            correct1Turner = rightSide1Turner;
            System.out.println("voi folosi right side 1 turner");
        } else if (isRightSide1TurnerOnTheInside && !isLeftSide1TurnerOnTheInside) {
            correct1Turner = leftSide1Turner;
            logger.info("voi folosi left side 1 turner");
        } else {
            logger.info("voi folosi endPosition");
            if (SimulatorServiceUtils.equals((Position)leftSide1Turner.getPosition(), (Position)newMovedPosition, (double)1.0E-4)) {
                logger.info("voi folosi endPosition = leftSide1Turner!");
                correct1Turner = leftSide1Turner;
            } else if (SimulatorServiceUtils.equals((Position)rightSide1Turner.getPosition(), (Position)newMovedPosition, (double)1.0E-4)) {
                logger.info("voi folosi endPosition = rightSide1Turner!");
                correct1Turner = rightSide1Turner;
            } else {
                logger.info("nu ar trebui sa ajunga aici NICIODATA!");
            }
        }
        long timeStepMilliseconds = 2000L;
        double minimumDistanceMeters = 4.0;
        List path = pathGenerator.getIntersectionOptimalTowardWind((WindFieldGenerator)windFieldGenerator, polarDiagram, edgeStart, edgeEnd, correct1Turner, true, timeStepMilliseconds, minimumDistanceMeters);
        return new Response1TurnerDTO(SimulatorServiceUtils.toSimulatorWindDTOList((List)path), SimulatorServiceUtils.toSimulatorWindDTO((TimedPositionWithSpeed)leftSide1Turner), SimulatorServiceUtils.toSimulatorWindDTO((TimedPositionWithSpeed)rightSide1Turner), oldMovedPosition, newMovedPosition, notificationMessage);
    }

    public List<String> getLegsNames(int selectedRaceIndex) {
        this.checkSimulatorReadPermissionOnCurrentServer();
        if (selectedRaceIndex < 0) {
            selectedRaceIndex = 0;
        }
        SimulatorImpl simulator = new SimulatorImpl((SimulationParameters)new SimulationParametersImpl(null, null, null, null, 'm', true, true));
        return simulator.getLegsNames(selectedRaceIndex);
    }

    public List<String> getRacesNames() {
        this.checkSimulatorReadPermissionOnCurrentServer();
        SimulatorImpl simulator = new SimulatorImpl((SimulationParameters)new SimulationParametersImpl(null, null, null, null, 'm', true, true));
        return simulator.getRacesNames();
    }

    public List<String> getCompetitorsNames(int selectedRaceIndex) {
        this.checkSimulatorReadPermissionOnCurrentServer();
        if (selectedRaceIndex < 0) {
            selectedRaceIndex = 0;
        }
        SimulatorImpl simulator = new SimulatorImpl((SimulationParameters)new SimulationParametersImpl(null, null, null, null, 'm', true, true));
        return simulator.getCompetitorsNames(selectedRaceIndex);
    }

    private void retrieveWindControlParameters(WindPatternDisplay pattern) {
        this.controlParameters.setDefaults();
        for (WindPatternSetting s : pattern.getSettings()) {
            try {
                Field f = this.controlParameters.getClass().getField(s.getName());
                try {
                    LOGGER.fine("Setting " + f.getName() + " to " + s.getName() + " value : " + s.getValue());
                    f.set(this.controlParameters, s.getValue());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("SimulatorServiceImpl => IllegalArgumentException with message " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    LOGGER.warning("SimulatorServiceImpl => IllegalAccessException with message " + e.getMessage());
                }
            }
            catch (SecurityException e) {
                LOGGER.warning("SimulatorServiceImpl => SecurityException with message " + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                LOGGER.warning("SimulatorServiceImpl => NoSuchFieldException with message " + e.getMessage());
            }
        }
    }

    private SimulatorWindDTO createSimulatorWindDTO(Wind wind) {
        Position position = wind.getPosition();
        TimePoint timePoint = wind.getTimePoint();
        SimulatorWindDTO result = new SimulatorWindDTO();
        result.trueWindBearingDeg = wind.getBearing().getDegrees();
        result.trueWindSpeedInKnots = wind.getKnots();
        if (position != null) {
            result.position = position;
        }
        if (timePoint != null) {
            result.timepoint = timePoint;
        }
        return result;
    }

    private SimulatorWindDTO createSimulatorWindDTO(TimedPositionWithSpeed timedPositionWithSpeed) {
        Position position = timedPositionWithSpeed.getPosition();
        SpeedWithBearing speedWithBearing = timedPositionWithSpeed.getSpeed();
        TimePoint timePoint = timedPositionWithSpeed.getTimePoint();
        SimulatorWindDTO result = new SimulatorWindDTO();
        if (speedWithBearing == null) {
            result.trueWindBearingDeg = 0.0;
            result.trueWindSpeedInKnots = 0.0;
        } else {
            result.trueWindBearingDeg = speedWithBearing.getBearing().getDegrees();
            result.trueWindSpeedInKnots = speedWithBearing.getKnots();
        }
        if (position != null) {
            result.position = position;
        }
        if (timePoint != null) {
            result.timepoint = timePoint;
        }
        return result;
    }

    private WindFieldDTO createWindFieldDTO(WindFieldGenerator wf, TimePoint startTime, TimePoint endTime, Duration timeStep, WindFieldGenParamsDTO params) {
        WindFieldDTO windFieldDTO = new WindFieldDTO();
        Position[][] positionGrid = wf.getPositionGrid();
        ArrayList<SimulatorWindDTO> wList = new ArrayList<SimulatorWindDTO>();
        if (positionGrid != null && positionGrid.length > 0) {
            TimePoint t = startTime;
            while (t.compareTo((Object)endTime) <= 0) {
                int i = 0;
                while (i < positionGrid.length) {
                    int j = 0;
                    while (j < positionGrid[i].length) {
                        Wind localWind = wf.getWind((TimedPosition)new TimedPositionWithSpeedImpl(t, positionGrid[i][j], null));
                        LOGGER.finer(localWind.toString());
                        wList.add(this.createSimulatorWindDTO(localWind));
                        ++j;
                    }
                    ++i;
                }
                t = new MillisecondsTimePoint(t.asMillis() + timeStep.asMillis());
            }
        }
        windFieldDTO.setMatrix(wList);
        if (params.isShowLines() && params.getSeedLines() == 'f') {
            this.getWindLinesFromStartLine(wf, windFieldDTO, startTime, endTime, timeStep);
        }
        if (params.isShowLines() && params.getSeedLines() == 'b') {
            this.getWindLinesFromEndLine(wf, windFieldDTO, startTime, endTime, timeStep);
        }
        windFieldDTO.curBearing = wf.getWindParameters().curBearing;
        windFieldDTO.curSpeed = wf.getWindParameters().curSpeed;
        if (params.isShowStreamlets()) {
            WindFieldDTO.WindData windData = new WindFieldDTO.WindData();
            windData.rcStart = params.getRaceCourseStart();
            windData.rcEnd = params.getRaceCourseEnd();
            windData.resX = params.getxRes();
            windData.resY = params.getyRes();
            windData.borderX = params.getBorderX();
            windData.borderY = params.getBorderY();
            windData.xScale = 1.5;
            windFieldDTO.windData = windData;
        }
        return windFieldDTO;
    }

    private void getWindLinesFromStartLine(WindFieldGenerator wf, WindFieldDTO windFieldDTO, TimePoint startTime, TimePoint endTime, Duration timeStep) {
        Position[][] positionGrid = wf.getPositionGrid();
        WindLinesDTO windLinesDTO = windFieldDTO.getWindLinesDTO();
        if (windLinesDTO == null) {
            windLinesDTO = new WindLinesDTO();
            windFieldDTO.setWindLinesDTO(windLinesDTO);
        }
        if (positionGrid != null && positionGrid.length > 0 && positionGrid[0].length > 2) {
            int j = 1;
            while (j < positionGrid[0].length - 1) {
                TimePoint t = startTime;
                Position p0 = positionGrid[0][j];
                Position p1 = positionGrid[1][j];
                DegreePosition seed = new DegreePosition(p0.getLatDeg() + 0.5 * (p0.getLatDeg() - p1.getLatDeg()), p0.getLngDeg() + 0.5 * (p0.getLngDeg() - p1.getLngDeg()));
                DegreePosition startPosition = new DegreePosition(seed.getLatDeg(), seed.getLngDeg());
                while (t.compareTo((Object)endTime) <= 0) {
                    TimedPositionImpl tp = new TimedPositionImpl(t, (Position)seed);
                    Path p = wf.getLine((TimedPosition)tp, false);
                    if (p != null) {
                        ArrayList<DegreePosition> positions = new ArrayList<DegreePosition>();
                        for (TimedPositionWithSpeed pathPoint : p.getPathPoints()) {
                            Position position = pathPoint.getPosition();
                            DegreePosition positionDTO = new DegreePosition(position.getLatDeg(), position.getLngDeg());
                            positions.add(positionDTO);
                        }
                        windLinesDTO.addWindLine((Position)startPosition, Long.valueOf(tp.getTimePoint().asMillis()), positions);
                    }
                    t = new MillisecondsTimePoint(t.asMillis() + timeStep.asMillis());
                }
                ++j;
            }
        }
    }

    private void getWindLinesFromEndLine(WindFieldGenerator wf, WindFieldDTO windFieldDTO, TimePoint startTime, TimePoint endTime, Duration timeStep) {
        Position[][] positionGrid = wf.getPositionGrid();
        WindLinesDTO windLinesDTO = windFieldDTO.getWindLinesDTO();
        if (windLinesDTO == null) {
            windLinesDTO = new WindLinesDTO();
            windFieldDTO.setWindLinesDTO(windLinesDTO);
        }
        if (positionGrid != null && positionGrid.length > 1 && positionGrid[0].length > 2) {
            int lastRowIndex = positionGrid.length - 1;
            int j = 1;
            while (j < positionGrid[lastRowIndex].length - 1) {
                TimePoint t = startTime;
                Position p0 = positionGrid[lastRowIndex][j];
                Position p1 = positionGrid[lastRowIndex - 1][j];
                DegreePosition seed = new DegreePosition(p0.getLatDeg() + 0.5 * (p0.getLatDeg() - p1.getLatDeg()), p0.getLngDeg() + 0.5 * (p0.getLngDeg() - p1.getLngDeg()));
                DegreePosition startPosition = new DegreePosition(seed.getLatDeg(), seed.getLngDeg());
                while (t.compareTo((Object)endTime) <= 0) {
                    TimedPositionImpl tp = new TimedPositionImpl(t, (Position)seed);
                    Path p = wf.getLine((TimedPosition)tp, true);
                    if (p != null) {
                        ArrayList<DegreePosition> positions = new ArrayList<DegreePosition>();
                        for (TimedPositionWithSpeed pathPoint : p.getPathPoints()) {
                            Position position = pathPoint.getPosition();
                            DegreePosition positionDTO = new DegreePosition(position.getLatDeg(), position.getLngDeg());
                            positions.add(positionDTO);
                        }
                        windLinesDTO.addWindLine((Position)startPosition, Long.valueOf(tp.getTimePoint().asMillis()), positions);
                    }
                    t = new MillisecondsTimePoint(t.asMillis() + timeStep.asMillis());
                }
                ++j;
            }
        }
    }

    private SimulatedPathsEvenTimedResultDTO getSimulatedPathsEvenTimed(List<Position> course, WindFieldGenerator wf, char mode, SimulatorUISelectionDTO selection, boolean showOmniscient, boolean showOpportunist) throws ConfigurationException {
        RaceMapDataDTO rcDTO;
        LOGGER.fine("Retrieving simulated paths");
        Util.Pair polarDiagramAndNotificationMessage = this.getPolarDiagram(selection.boatClassIndex.intValue());
        PolarDiagram pd = (PolarDiagram)polarDiagramAndNotificationMessage.getA();
        int[] gridRes = wf.getGridResolution();
        Position[] gridArea = wf.getGridAreaGps();
        LOGGER.fine("showOmniscient : " + showOmniscient);
        LOGGER.fine("showOpportunist: " + showOpportunist);
        if (gridArea != null) {
            CurvedGrid bd = new CurvedGrid(gridArea[0], gridArea[1]);
            wf.getWindParameters().baseWindBearing = wf.getWindParameters().baseWindBearing + bd.getSouth().getDegrees();
            LOGGER.fine("base wind: " + (pd == null ? "null" : String.valueOf(pd.getWind().getKnots()) + " kn, ") + wf.getWindParameters().baseWindBearing % 360.0 + "\u00b0");
            KnotSpeedWithBearingImpl current = new KnotSpeedWithBearingImpl(wf.getWindParameters().curSpeed.doubleValue(), (Bearing)new DegreeBearingImpl(wf.getWindParameters().curBearing.doubleValue()));
            if (pd != null) {
                if (wf.getWindParameters().curSpeed > 0.0) {
                    pd.initializeSOGwithCurrent();
                }
                pd.setCurrent((SpeedWithBearing)current);
                if (pd.getCurrent() != null) {
                    LOGGER.fine("water current: " + pd.getCurrent().getKnots() + " kn, " + pd.getCurrent().getBearing().getDegrees() + "\u00b0");
                }
            }
            wf.setBoundary((Grid)bd);
            Position[][] positionGrid = bd.generatePositions(gridRes[0], gridRes[1], gridRes[2], gridRes[3]);
            wf.setPositionGrid(positionGrid);
            wf.generate(wf.getStartTime(), wf.getEndTime(), wf.getTimeStep());
        }
        SimulationParametersImpl sp = new SimulationParametersImpl(course, pd, wf, null, mode, showOmniscient, showOpportunist);
        Map pathsAndNames = null;
        try {
            pathsAndNames = this.simulationService.getAllPathsEvenTimed((SimulationParameters)sp, wf.getTimeStep().asMillis());
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted while calculating paths", e);
        }
        catch (ExecutionException e) {
            logger.log(Level.SEVERE, "Problem while calculating paths", e);
        }
        int noOfPaths = pathsAndNames.size();
        if (mode == 'm') {
            ++noOfPaths;
        }
        PathDTO[] pathDTOs = new PathDTO[noOfPaths];
        int index = noOfPaths - 1;
        if (mode == 'm') {
            pathDTOs[0] = this.getPolylinePathDTO((Path)pathsAndNames.get(null), (Path)pathsAndNames.get(null));
        }
        for (Map.Entry entry : pathsAndNames.entrySet()) {
            LOGGER.fine("Path " + ((PathType)entry.getKey()).getTxtId());
            pathDTOs[index] = new PathDTO((PathType)entry.getKey());
            ArrayList<SimulatorWindDTO> wList = new ArrayList<SimulatorWindDTO>();
            for (TimedPositionWithSpeed p : ((Path)entry.getValue()).getPathPoints()) {
                wList.add(this.createSimulatorWindDTO(p));
            }
            pathDTOs[index].setPoints(wList);
            pathDTOs[index].setAlgorithmTimedOut(((Path)entry.getValue()).getAlgorithmTimedOut());
            pathDTOs[index].setMixedLeg(((Path)entry.getValue()).getMixedLeg());
            --index;
        }
        if (mode == 'm') {
            rcDTO = new RaceMapDataDTO();
            rcDTO.coursePositions = new CoursePositionsDTO();
            rcDTO.coursePositions.waypointPositions = new ArrayList();
            rcDTO.coursePositions.waypointPositions.add(course.get(0));
            rcDTO.coursePositions.waypointPositions.add(course.get(1));
        } else {
            rcDTO = null;
        }
        return new SimulatedPathsEvenTimedResultDTO(pathDTOs, rcDTO, null, (String)polarDiagramAndNotificationMessage.getB());
    }

    private Util.Pair<PolarDiagram, String> getPolarDiagram(int boatClassIndex) throws ConfigurationException {
        PolarDiagram polarDiagram;
        String notificationMessage;
        BoatClassDTO boatClass = this.polarDiagramCache.getBoatClass(boatClassIndex);
        if (boatClass == null) {
            notificationMessage = Util.hasLength((String)this.polarDiagramCache.getNotificationMessage()) ? this.polarDiagramCache.getNotificationMessage() : "Boat class with index " + boatClassIndex + " not found";
            polarDiagram = null;
        } else {
            polarDiagram = this.polarDiagramCache.getPolarDiagram(boatClass);
            notificationMessage = polarDiagram == null ? (Util.hasLength((String)this.polarDiagramCache.getNotificationMessage()) ? this.polarDiagramCache.getNotificationMessage() : "Couldn't find polar diagram for boat class " + boatClass.getName()) : null;
        }
        return new Util.Pair((Object)polarDiagram, (Object)notificationMessage);
    }

    private PathDTO getPolylinePathDTO(Path gpsPoly, Path gpsTrack) {
        List gpsTrackPoints = gpsTrack.getPathPoints();
        List gpsPolyPoints = gpsPoly.getPathPoints();
        int noOfGpsTrackPoints = gpsTrackPoints.size();
        int noOfGpsPolyPoints = gpsPolyPoints.size();
        if (noOfGpsTrackPoints == 0 || noOfGpsTrackPoints == 1 || noOfGpsPolyPoints == 0 || noOfGpsPolyPoints == 1) {
            return null;
        }
        TimedPositionWithSpeed startPoint = (TimedPositionWithSpeed)gpsPolyPoints.get(0);
        TimedPositionWithSpeed endPoint = (TimedPositionWithSpeed)gpsPolyPoints.get(noOfGpsPolyPoints - 1);
        int startPointIndex = SimulatorServiceUtils.getIndexOfClosest((List)gpsTrackPoints, (TimedPositionWithSpeed)startPoint);
        int endPointIndex = SimulatorServiceUtils.getIndexOfClosest((List)gpsTrackPoints, (TimedPositionWithSpeed)endPoint);
        List polylinePoints = gpsTrackPoints.subList(startPointIndex, endPointIndex + 1);
        List turns = new PathImpl(polylinePoints, null, false, false).getTurns();
        ArrayList<SimulatorWindDTO> points = new ArrayList<SimulatorWindDTO>();
        boolean isTurn = false;
        SpeedWithBearing speedWithBearing = null;
        Position position = null;
        for (TimedPositionWithSpeed point : polylinePoints) {
            isTurn = false;
            for (TimedPositionWithSpeed turn : turns) {
                if (turn.getPosition().getLatDeg() != point.getPosition().getLatDeg() || turn.getPosition().getLngDeg() != point.getPosition().getLngDeg() || turn.getTimePoint().asMillis() != point.getTimePoint().asMillis() || turn.getSpeed().getKnots() != point.getSpeed().getKnots() || turn.getSpeed().getBearing().getDegrees() != point.getSpeed().getBearing().getDegrees()) continue;
                isTurn = true;
                break;
            }
            speedWithBearing = point.getSpeed();
            position = point.getPosition();
            points.add(new SimulatorWindDTO(position.getLatDeg(), position.getLngDeg(), speedWithBearing.getKnots(), speedWithBearing.getBearing().getDegrees(), point.getTimePoint(), isTurn));
        }
        PathDTO result = new PathDTO(POLYLINE_PATH_NAME);
        result.setPoints(points);
        result.setAlgorithmTimedOut(false);
        return result;
    }

    private List<Position> getIntermediatePoints(Position startPoint, Position endPoint, double stepSizeMeters) {
        ArrayList<Position> result = new ArrayList<Position>();
        double distance = startPoint.getDistance(endPoint).getMeters();
        int noOfSteps = (int)(distance / stepSizeMeters) + 1;
        double bearing = startPoint.getBearingGreatCircle(endPoint).getDegrees();
        Position temp = null;
        result.add(startPoint);
        int stepIndex = 1;
        while (stepIndex < noOfSteps) {
            temp = SimulatorServiceUtils.getDestinationPoint((Position)startPoint, (double)bearing, (double)(stepSizeMeters * (double)stepIndex));
            result.add(temp);
            bearing = startPoint.getBearingGreatCircle(temp).getDegrees();
            ++stepIndex;
        }
        return result;
    }

    private long getTimeMillisecondsBetween(Position turn1, Position turn2, double stepSizeMeters, boolean useRealAverageWindSpeed, Path gpsTrack, PolarDiagram polarDiagram, long startTimePoint2asMillis) {
        Position p1 = turn1;
        Position p2 = turn2;
        List points = this.getIntermediatePoints(p1, p2, stepSizeMeters);
        int noOfPointsMinus1 = points.size() - 1;
        Position startPoint = null;
        Position endPoint = null;
        double boatBearingDeg = 0.0;
        double boatSpeedMetersPerSecond = 0.0;
        double distanceMeters = 0.0;
        long timepointAsMillis = startTimePoint2asMillis;
        SpeedWithBearing windAtTimePoint = null;
        long stepTimeMilliseconds = 0L;
        int index = 0;
        while (index < noOfPointsMinus1) {
            startPoint = (Position)points.get(index);
            endPoint = (Position)points.get(index + 1);
            distanceMeters = startPoint.getDistance(endPoint).getMeters();
            windAtTimePoint = useRealAverageWindSpeed ? SimulatorServiceUtils.getWindAtTimepoint((long)timepointAsMillis, (Path)gpsTrack) : SimulatorServiceUtils.DEFAULT_AVERAGE_WIND;
            boatBearingDeg = SimulatorServiceUtils.getInitialBearing((Position)startPoint, (Position)endPoint);
            polarDiagram.setWind(windAtTimePoint);
            boatSpeedMetersPerSecond = polarDiagram.getSpeedAtBearing((Bearing)new DegreeBearingImpl(boatBearingDeg)).getMetersPerSecond();
            stepTimeMilliseconds = (long)(distanceMeters / boatSpeedMetersPerSecond * 1000.0);
            if (boatSpeedMetersPerSecond == 0.0) {
                stepTimeMilliseconds = 1000L;
            }
            timepointAsMillis += stepTimeMilliseconds;
            ++index;
        }
        return timepointAsMillis - startTimePoint2asMillis;
    }

    public String getGoogleMapsLoaderAuthenticationParams() {
        return Activator.getInstance().getGoogleMapsLoaderAuthenticationParams();
    }
}

