/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.view.client.ListDataProvider;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFilterLabel;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TagListProvider
extends ListDataProvider<TagDTO> {
    private FilterSet<TagDTO, Filter<TagDTO>> currentFilterSet;
    private final List<TagDTO> allTags = new ArrayList();
    private final List<TagFilterLabel> observingLabels = new ArrayList();

    protected TagListProvider() {
    }

    protected void add(TagDTO tag) {
        int i = 0;
        while (i < this.allTags.size()) {
            if (((TagDTO)this.allTags.get(i)).getRaceTimepoint().after(tag.getRaceTimepoint())) {
                this.allTags.add(i, tag);
                return;
            }
            ++i;
        }
        this.allTags.add(tag);
    }

    protected void addAll(List<TagDTO> tags) {
        for (TagDTO tag : tags) {
            this.add(tag);
        }
    }

    protected void remove(TagDTO tag) {
        this.allTags.remove(tag);
    }

    protected void removePrivateTags() {
        this.allTags.removeIf(tag -> !tag.isVisibleForPublic());
    }

    protected void clear() {
        this.allTags.clear();
    }

    protected List<TagDTO> getAllTags() {
        return Collections.unmodifiableList(this.allTags);
    }

    protected void addObserveringLabel(TagFilterLabel tagFilterLabel) {
        this.observingLabels.add(tagFilterLabel);
    }

    private void updateOberservingLabels() {
        for (TagFilterLabel label : this.observingLabels) {
            label.update(this.currentFilterSet);
        }
    }

    protected List<TagDTO> getFilteredTags() {
        return this.getList();
    }

    protected void updateFilteredTags() {
        ArrayList currentFilteredList = new ArrayList(this.getAllTags());
        if (this.currentFilterSet != null) {
            for (Filter filter : this.currentFilterSet.getFilters()) {
                Iterator i = currentFilteredList.iterator();
                while (i.hasNext()) {
                    TagDTO tag = (TagDTO)i.next();
                    if (filter.matches((Object)tag)) continue;
                    i.remove();
                }
            }
        }
        currentFilteredList.sort((tag1, tag2) -> {
            TimePoint tag2Time;
            TimePoint tag1Time = tag1.getRaceTimepoint();
            if (tag1Time.before(tag2Time = tag2.getRaceTimepoint())) {
                return -1;
            }
            if (tag1Time.after(tag2Time)) {
                return 1;
            }
            return 0;
        });
        this.setList(currentFilteredList);
    }

    protected FilterSet<TagDTO, Filter<TagDTO>> getTagFilterSet() {
        return this.currentFilterSet;
    }

    protected void setCurrentFilterSet(FilterSet<TagDTO, Filter<TagDTO>> tagFilterSet) {
        this.currentFilterSet = tagFilterSet;
        this.updateFilteredTags();
        this.updateOberservingLabels();
        this.refresh();
    }
}

