/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Window;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.GwtUrlHelper;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagCell;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagSharedURLDialog;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.gwt.client.media.TakedownNoticeRequestDialog;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.common.CommonSharedResources;
import com.sap.sse.security.ui.client.UserService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TagCell
extends AbstractCell<TagDTO> {
    private final TagCellTemplate tagCellTemplate = (TagCellTemplate)GWT.create(TagCellTemplate.class);
    private final TaggingPanelResources resources = TaggingPanelResources.INSTANCE;
    private final TaggingPanelResources.TagPanelStyle style = this.resources.style();
    private final CommonSharedResources.CommonMainCss sharedResources = CommonSharedResources.INSTANCE.mainCss();
    private final TaggingComponent taggingComponent;
    private final StringMessages stringMessages;
    private final UserService userService;
    private final boolean isPreviewCell;
    private final RaceIdentifier raceIdentifier;

    TagCell(TaggingComponent taggingComponent, StringMessages stringMessages, UserService userService, boolean isPreviewCell, RaceIdentifier raceIdentifier) {
        super(new String[]{"click"});
        this.taggingComponent = taggingComponent;
        this.stringMessages = stringMessages;
        this.userService = userService;
        this.isPreviewCell = isPreviewCell;
        this.raceIdentifier = raceIdentifier;
        this.sharedResources.ensureInjected();
    }

    public void render(Cell.Context context, TagDTO tag, SafeHtmlBuilder htmlBuilder) {
        if (tag == null) {
            return;
        }
        SafeHtml safeTag = SafeHtmlUtils.fromString((String)tag.getTag());
        SafeHtml safeCreated = SafeHtmlUtils.fromString((String)this.stringMessages.tagCreated(tag.getUsername(), DateTimeFormat.getFormat((String)"E d/M/y, HH:mm").format(tag.getRaceTimepoint().asDate())));
        SafeHtml safeComment = SafeHtmlUtils.fromString((String)tag.getComment());
        SafeUri trustedImageURL = null;
        if (tag.getImageURL() != null && !tag.getImageURL().isEmpty()) {
            trustedImageURL = UriUtils.fromTrustedString((String)tag.getImageURL());
        }
        SafeUri safeIsPrivateImageUri = this.resources.privateIcon().getSafeUri();
        SafeHtml content = SafeHtmlUtils.EMPTY_SAFE_HTML;
        if (!tag.getComment().isEmpty() && trustedImageURL == null) {
            content = this.tagCellTemplate.contentWithCommentWithoutImage(this.style.tagCellComment(), safeComment);
        } else if (tag.getComment().isEmpty() && trustedImageURL != null) {
            TakedownNoticeRequestDialog.ensureJSFunctionInstalled((TakedownNoticeService)this.userService);
            content = this.tagCellTemplate.contentWithoutCommentWithImage(this.style.tagCellImage(), trustedImageURL, this.sharedResources.media_menu_icon(), this.sharedResources.media_wrapper(), new SafeHtmlBuilder().appendEscaped(trustedImageURL.asString()).toSafeHtml().asString(), String.valueOf(tag.getTag()) + ", " + tag.getRaceTimepoint() + ", " + this.raceIdentifier, this.userService.getCurrentUser() == null ? "" : this.userService.getCurrentUser().getName());
        } else if (!tag.getComment().isEmpty() && trustedImageURL != null) {
            TakedownNoticeRequestDialog.ensureJSFunctionInstalled((TakedownNoticeService)this.userService);
            content = this.tagCellTemplate.contentWithCommentWithImage(this.style.tagCellImage(), this.style.tagCellComment(), trustedImageURL, safeComment, this.sharedResources.media_menu_icon(), this.sharedResources.media_wrapper(), new SafeHtmlBuilder().appendEscaped(trustedImageURL.asString()).toSafeHtml().asString(), String.valueOf(tag.getTag()) + ", " + tag.getRaceTimepoint() + ", " + this.raceIdentifier + ", " + Window.Location.createUrlBuilder().buildString(), this.userService.getCurrentUser() == null ? "" : this.userService.getCurrentUser().getName());
        }
        SafeHtml icon = SafeHtmlUtils.EMPTY_SAFE_HTML;
        if (!tag.isVisibleForPublic()) {
            icon = this.tagCellTemplate.icon(safeIsPrivateImageUri);
        }
        SafeHtml shareButton = SafeHtmlUtils.EMPTY_SAFE_HTML;
        SafeHtml editButton = SafeHtmlUtils.EMPTY_SAFE_HTML;
        SafeHtml deleteButton = SafeHtmlUtils.EMPTY_SAFE_HTML;
        if (!this.isPreviewCell) {
            if (tag.isVisibleForPublic()) {
                shareButton = this.tagCellTemplate.button(String.valueOf(this.style.tagActionButton()) + " " + this.style.tagShareButton(), this.stringMessages.tagShareTag(), this.tagCellTemplate.icon(this.resources.shareIcon().getSafeUri()));
            }
            if (this.userService.getCurrentUser() != null) {
                if (tag.getUsername().equals(this.userService.getCurrentUser().getName())) {
                    editButton = this.tagCellTemplate.button(String.valueOf(this.style.tagActionButton()) + " " + this.style.tagEditButton(), this.stringMessages.tagEditTag(), this.tagCellTemplate.icon(this.resources.editIcon().getSafeUri()));
                }
                if (tag.getUsername().equals(this.userService.getCurrentUser().getName())) {
                    deleteButton = this.tagCellTemplate.button(String.valueOf(this.style.tagActionButton()) + " " + this.style.tagDeleteButton(), this.stringMessages.tagDeleteTag(), this.tagCellTemplate.icon(this.resources.deleteIcon().getSafeUri()));
                }
            }
        }
        SafeHtml headingButtons = this.tagCellTemplate.headerButtons(this.style.tagCellHeadingButtons(), shareButton, editButton, deleteButton);
        String cellStyle = this.style.tagCell();
        if (tag.equals((Object)this.taggingComponent.getSelectedTag())) {
            cellStyle = String.valueOf(this.style.tagCell()) + " " + this.style.tagCellActive();
        }
        SafeHtml cell = this.tagCellTemplate.cell(cellStyle, this.style.tagCellHeading(), this.style.tagCellCreated(), icon, headingButtons, safeTag, safeCreated, content);
        htmlBuilder.append(cell);
    }

    public void onBrowserEvent(Cell.Context context, Element parent, TagDTO tag, NativeEvent event, ValueUpdater<TagDTO> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)tag, event, valueUpdater);
        if (!this.taggingComponent.getCurrentState().equals((Object)TaggingComponent.State.EDIT_TAG) && "click".equals(event.getType())) {
            EventTarget eventTarget = event.getEventTarget();
            if (!Element.is((JavaScriptObject)eventTarget)) {
                return;
            }
            NodeList elements = parent.getElementsByTagName("button");
            int i = 0;
            while (i < elements.getLength()) {
                Element button = (Element)elements.getItem(i);
                if (button != null && button.isOrHasChild((Node)Element.as((JavaScriptObject)eventTarget))) {
                    if (button.hasClassName(this.style.tagDeleteButton())) {
                        ConfirmationDialog.create((String)this.stringMessages.tagConfirmDeletionHeading(), (String)this.stringMessages.tagConfirmDeletion(tag.getTag()), (String)this.stringMessages.confirm(), (String)this.stringMessages.cancel(), () -> this.taggingComponent.removeTag(tag)).center();
                    } else if (button.hasClassName(this.style.tagEditButton())) {
                        this.taggingComponent.setCurrentState(TaggingComponent.State.EDIT_TAG);
                    } else if (button.hasClassName(this.style.tagShareButton())) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(Window.Location.getHref().split("\\?")[0]);
                        this.appendURLParams(builder, Window.Location.getParameterMap(), new HashSet<String>(Arrays.asList("tag", "mode")));
                        this.appendTagParam(builder, tag);
                        new TagSharedURLDialog(this.stringMessages, builder.toString()).show();
                    }
                }
                ++i;
            }
        }
    }

    private void appendURLParams(StringBuilder urlBuilder, Map<String, List<String>> urlParamsMap, Set<String> ignoreParams) {
        Set<Map.Entry<String, List<String>>> params = urlParamsMap.entrySet();
        urlBuilder.append('?');
        boolean addedParam = false;
        for (Map.Entry<String, List<String>> entry : params) {
            String param = entry.getKey();
            List<String> values = entry.getValue();
            if (ignoreParams.contains(param)) continue;
            if (values.size() > 0) {
                int j = 0;
                while (j < values.size()) {
                    if (addedParam) {
                        urlBuilder.append('&');
                    } else {
                        addedParam = true;
                    }
                    urlBuilder.append(param);
                    urlBuilder.append('=');
                    urlBuilder.append(values.get(j));
                    ++j;
                }
                continue;
            }
            if (addedParam) {
                urlBuilder.append('&');
            } else {
                addedParam = true;
            }
            urlBuilder.append(param);
        }
    }

    private void appendTagParam(StringBuilder urlBuilder, TagDTO tag) {
        urlBuilder.append('&');
        urlBuilder.append("viewShowTags");
        urlBuilder.append("=true&");
        urlBuilder.append("tag");
        urlBuilder.append('=');
        urlBuilder.append(tag.getRaceTimepoint().asMillis());
        urlBuilder.append(',');
        urlBuilder.append(GwtUrlHelper.INSTANCE.encodeQueryString(tag.getTag()));
    }
}

