/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartZoomChangedEvent;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChart;
import com.sap.sailing.gwt.ui.raceboard.SliceRaceHandler;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import java.util.UUID;

public class SliceRaceHandler {
    private final Styles styles = ((Resources)GWT.create(Resources.class)).style();
    private final Button sliceButtonUi;
    private TimeRange visibleRange;
    private final String leaderboardGroupName;
    private final UUID leaderboardGroupId;
    private final String leaderboardName;
    private final UUID eventId;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final SailingServiceAsync sailingService;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final RegattaAndRaceIdentifier selectedRaceIdentifier;
    private boolean canSlice = false;
    private final StrippedLeaderboardDTO leaderboardDTO;
    private RaceWithCompetitorsAndBoatsDTO raceDTO;

    public SliceRaceHandler(SailingServiceWriteAsync sailingServiceWrite, SailingServiceAsync sailingService, UserService userService, ErrorReporter errorReporter, MultiCompetitorRaceChart competitorRaceChart, RegattaAndRaceIdentifier selectedRaceIdentifier, String leaderboardGroupName, UUID leaderboardGroupId, String leaderboardName, UUID eventId, StrippedLeaderboardDTO leaderboardDTO, RaceWithCompetitorsAndBoatsDTO raceDTO, StringMessages stringMessages) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.sailingService = sailingService;
        this.userService = userService;
        this.errorReporter = errorReporter;
        this.selectedRaceIdentifier = selectedRaceIdentifier;
        this.leaderboardGroupName = leaderboardGroupName;
        this.leaderboardGroupId = leaderboardGroupId;
        this.leaderboardName = leaderboardName;
        this.eventId = eventId;
        this.leaderboardDTO = leaderboardDTO;
        this.raceDTO = raceDTO;
        this.styles.ensureInjected();
        this.sliceButtonUi = new Button();
        this.sliceButtonUi.setStyleName(this.styles.sliceButtonBackgroundImage());
        this.sliceButtonUi.setTitle(stringMessages.sliceRace());
        competitorRaceChart.addToolbarButton(this.sliceButtonUi);
        this.sliceButtonUi.setVisible(false);
        competitorRaceChart.addChartZoomChangedHandler(arg_0 -> this.checkIfMaySliceSelectedRegattaAndRace(arg_0));
        competitorRaceChart.addChartZoomResetHandler(e -> {
            this.visibleRange = null;
            this.updateVisibility();
        });
        this.sliceButtonUi.addClickHandler(e -> {
            if (this.allowsEditing()) {
                this.doSlice();
            } else {
                Notification.notify((String)stringMessages.insufficientPermissions(), (Notification.NotificationType)Notification.NotificationType.ERROR);
            }
        });
        this.updateCanSliceIfAuthorized();
        UserStatusEventHandler userStatusEventHandler = (user, preAuthenticated) -> {
            this.updateCanSliceIfAuthorized();
            this.updateVisibility();
        };
        this.sliceButtonUi.addAttachHandler(e -> {
            if (e.isAttached()) {
                userService.addUserStatusEventHandler(userStatusEventHandler);
            } else {
                userService.removeUserStatusEventHandler(userStatusEventHandler);
            }
        });
    }

    private void updateCanSliceIfAuthorized() {
        if (this.allowsEditing()) {
            this.sailingService.canSliceRace(this.selectedRaceIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateVisibility() {
        this.sliceButtonUi.setVisible(this.canSlice && this.visibleRange != null && this.allowsEditing());
    }

    private boolean allowsEditing() {
        return this.userService.hasPermission((SecuredDTO)this.raceDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE) && this.userService.hasPermission((SecuredDTO)this.leaderboardDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
    }

    private void doSlice() {
        if (this.visibleRange != null) {
            this.sailingService.prepareForSlicingOfRace(this.selectedRaceIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void checkIfMaySliceSelectedRegattaAndRace(ChartZoomChangedEvent e) {
        this.visibleRange = new TimeRangeImpl((TimePoint)new MillisecondsTimePoint(e.getRangeStart()), (TimePoint)new MillisecondsTimePoint(e.getRangeEnd()));
        this.updateVisibility();
    }

    static /* synthetic */ void access$0(SliceRaceHandler sliceRaceHandler, boolean bl) {
        sliceRaceHandler.canSlice = bl;
    }

    static /* synthetic */ void access$1(SliceRaceHandler sliceRaceHandler) {
        sliceRaceHandler.updateVisibility();
    }

    static /* synthetic */ ErrorReporter access$2(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.errorReporter;
    }

    static /* synthetic */ SailingServiceWriteAsync access$3(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.sailingServiceWrite;
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$4(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.selectedRaceIdentifier;
    }

    static /* synthetic */ TimeRange access$5(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.visibleRange;
    }

    static /* synthetic */ UUID access$6(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.eventId;
    }

    static /* synthetic */ String access$7(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.leaderboardName;
    }

    static /* synthetic */ String access$8(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.leaderboardGroupName;
    }

    static /* synthetic */ UUID access$9(SliceRaceHandler sliceRaceHandler) {
        return sliceRaceHandler.leaderboardGroupId;
    }
}

