/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.dom.client.Document;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardPanelLifecycle;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettingsDialogComponent;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.support.SettingsUtil;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.ArrayList;

public class SingleRaceLeaderboardPanelLifecycle
extends LeaderboardPanelLifecycle<SingleRaceLeaderboardSettings> {
    private static final long DEFAULT_REFRESH_INTERVAL = 1000L;
    private final boolean isScreenLargeEnoughToInitiallyDisplayLeaderboard = Document.get().getClientWidth() >= 1024;
    private final boolean canBoatsOfCompetitorsChangePerRace;
    private final PaywallResolver paywallResolver;
    private final AbstractLeaderboardDTO leaderboardDTO;

    public SingleRaceLeaderboardPanelLifecycle(StringMessages stringMessages, Iterable<DetailType> availableDetailTypes, boolean canBoatsOfCompetitorsChangePerRace, PaywallResolver paywallResolver, AbstractLeaderboardDTO leaderboardDTO) {
        super(stringMessages, availableDetailTypes);
        this.canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRace;
        this.paywallResolver = paywallResolver;
        this.leaderboardDTO = leaderboardDTO;
    }

    public SingleRaceLeaderboardSettings createDefaultSettings() {
        ArrayList<DetailType> raceDetails = new ArrayList<DetailType>();
        raceDetails.add(DetailType.RACE_DISTANCE_TRAVELED);
        raceDetails.add(DetailType.RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS);
        raceDetails.add(DetailType.RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS);
        raceDetails.add(DetailType.NUMBER_OF_MANEUVERS);
        raceDetails.add(DetailType.RACE_DISPLAY_LEGS);
        ArrayList overallDetails = new ArrayList();
        SecurityChildSettingsContext context = new SecurityChildSettingsContext((SecuredDTO)this.leaderboardDTO, this.paywallResolver);
        SingleRaceLeaderboardSettings defaultSettings = new SingleRaceLeaderboardSettings(this.canBoatsOfCompetitorsChangePerRace, context);
        boolean showCompetitorFullNameColumn = this.isScreenLargeEnoughToInitiallyDisplayLeaderboard;
        SingleRaceLeaderboardSettings settings = new SingleRaceLeaderboardSettings(defaultSettings.getManeuverDetailsToShow(), defaultSettings.getLegDetailsToShow(), defaultSettings.getRaceDetailsToShow(), overallDetails, Long.valueOf(1000L), defaultSettings.isShowAddedScores(), true, showCompetitorFullNameColumn, this.canBoatsOfCompetitorsChangePerRace, false, false, context);
        SettingsUtil.copyDefaultsFromValues((Settings)settings, (Settings)settings);
        return settings;
    }

    public SingleRaceLeaderboardSettingsDialogComponent getSettingsDialogComponent(SingleRaceLeaderboardSettings settings) {
        return new SingleRaceLeaderboardSettingsDialogComponent(settings, this.stringMessages, this.availableDetailTypes, this.paywallResolver, this.leaderboardDTO);
    }
}

