/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.MediaManagementControl;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManager;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManagerComponent;
import com.sap.sailing.gwt.ui.client.media.MediaSingleSelectionControl;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPassingsPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPositionPanel;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardWithSecurityFetcher;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTablePanel;
import com.sap.sailing.gwt.ui.raceboard.SideBySideComponentViewer;
import com.sap.sailing.gwt.ui.raceboard.TouchSplitLayoutPanel;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.ArrayList;
import java.util.List;

public class SideBySideComponentViewer
implements UserStatusEventHandler {
    private static final int DEFAULT_SOUTH_SPLIT_PANEL_HEIGHT = 200;
    private final int MIN_LEADERBOARD_WIDTH = Math.min(432, Window.getClientWidth() - 40);
    private final int MIN_TAGGING_WIDTH = Math.min(440, Window.getClientWidth() - 80);
    private Component<?> leftComponent;
    private final RaceMap centerComponent;
    private final Component<?> rightComponent;
    private final List<Util.Pair<Component<?>, HasPermissions.Action>> components;
    private final ScrollPanel leftScrollPanel;
    private final Panel rightPanel;
    private final StringMessages stringMessages;
    private final Button mediaSelectionButton;
    private final Button mediaManagementButton;
    private final EditMarkPassingsPanel markPassingsPanel;
    private final EditMarkPositionPanel markPositionPanel;
    private final MediaPlayerManagerComponent mediaPlayerManagerComponent;
    private LayoutPanel mainPanel;
    private TouchSplitLayoutPanel splitLayoutPanel;
    private final UserService userService;
    private final LeaderboardWithSecurityFetcher asyncLeaderboardFetcher;

    public SideBySideComponentViewer(Component<?> leftComponentP, RaceMap centerComponentP, Component<?> rightComponentP, MediaPlayerManagerComponent mediaPlayerManagerComponent, List<Util.Pair<Component<?>, HasPermissions.Action>> components, StringMessages stringMessages, UserService userService, EditMarkPassingsPanel markPassingsPanel, EditMarkPositionPanel markPositionPanel, ManeuverTablePanel maneuverTablePanel, LeaderboardWithSecurityFetcher asyncLeaderboardFetcher, PaywallResolver paywallResolver, SecuredDTO dtoContext) {
        this.mediaPlayerManagerComponent = mediaPlayerManagerComponent;
        this.stringMessages = stringMessages;
        this.leftComponent = leftComponentP;
        this.centerComponent = centerComponentP;
        this.rightComponent = rightComponentP;
        this.components = components;
        this.userService = userService;
        this.asyncLeaderboardFetcher = asyncLeaderboardFetcher;
        this.mediaSelectionButton = this.createMediaSelectionButton((MediaPlayerManager)mediaPlayerManagerComponent);
        this.mediaManagementButton = this.createMediaManagementButton((MediaPlayerManager)mediaPlayerManagerComponent);
        this.markPassingsPanel = markPassingsPanel;
        this.markPositionPanel = markPositionPanel;
        markPositionPanel.setComponentViewer(this);
        mediaPlayerManagerComponent.addPlayerChangeListener((MediaPlayerManager.PlayerChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.leftScrollPanel = new ScrollPanel();
        this.leftScrollPanel.add(leftComponentP.getEntryWidget());
        this.leftScrollPanel.setTitle(leftComponentP.getEntryWidget().getTitle());
        this.rightPanel = new SimpleLayoutPanel();
        this.rightPanel.add(rightComponentP.getEntryWidget());
        this.rightPanel.setTitle(rightComponentP.getEntryWidget().getTitle());
        this.mainPanel = new LayoutPanel();
        this.mainPanel.setSize("100%", "100%");
        this.mainPanel.getElement().getStyle().setMarginTop(-12.0, Style.Unit.PX);
        this.mainPanel.setStyleName("SideBySideComponentViewer-MainPanel");
        this.splitLayoutPanel = new TouchSplitLayoutPanel(3, 25, paywallResolver, dtoContext);
        this.mainPanel.add((Widget)this.splitLayoutPanel);
        this.initializeComponents();
        this.splitLayoutPanel.insert((Widget)this.leftScrollPanel, this.leftComponent, DockLayoutPanel.Direction.WEST, (double)this.MIN_LEADERBOARD_WIDTH);
        this.rightPanel.getElement().setId("rightPanel-TAGS");
        this.rightComponent.getEntryWidget().getElement().setId("rightComponent-TAGS");
        this.splitLayoutPanel.insert((Widget)this.rightPanel, this.rightComponent, DockLayoutPanel.Direction.EAST, (double)this.MIN_TAGGING_WIDTH);
        ResizableAbsolutePanel panelForMapAndHorizontalToggleButtons = new ResizableAbsolutePanel(this);
        panelForMapAndHorizontalToggleButtons.add(this.centerComponent.getEntryWidget());
        this.splitLayoutPanel.insert((Widget)panelForMapAndHorizontalToggleButtons, (Component)this.centerComponent, DockLayoutPanel.Direction.CENTER, 0.0);
        ArrayList<Util.Pair> additionalVerticalButtons = new ArrayList<Util.Pair>();
        additionalVerticalButtons.add(new Util.Pair((Object)this.mediaSelectionButton, (Object)mediaPlayerManagerComponent.getDependentCssClassName()));
        additionalVerticalButtons.add(new Util.Pair((Object)this.mediaManagementButton, (Object)"managemedia"));
        userService.addUserStatusEventHandler((UserStatusEventHandler)this, true);
        this.splitLayoutPanel.lastComponentHasBeenAdded(hidden -> this.forceLayout(), (AbsolutePanel)panelForMapAndHorizontalToggleButtons, additionalVerticalButtons);
        this.refreshMarkUi();
    }

    public void setLeftComponent(Component<?> component) {
        this.leftComponent = component;
        this.leftScrollPanel.setWidget(this.leftComponent.getEntryWidget());
        this.leftScrollPanel.setTitle(this.leftComponent.getEntryWidget().getTitle());
    }

    private Button createMediaSelectionButton(MediaPlayerManager mediaPlayerManager) {
        Button result = new Button();
        MediaSingleSelectionControl multiSelectionControl = new MediaSingleSelectionControl(mediaPlayerManager, (UIObject)result, this.stringMessages);
        result.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        result.setVisible(false);
        return result;
    }

    private Button createMediaManagementButton(MediaPlayerManager mediaPlayerManager) {
        Button result = new Button(this.stringMessages.mediaManageMediaCaption());
        result.setTitle(this.stringMessages.mediaManageMediaTooltip());
        MediaManagementControl multiSelectionControl = new MediaManagementControl(mediaPlayerManager, (UIObject)result, this.stringMessages);
        result.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        result.setVisible(false);
        return result;
    }

    private void initializeComponents() {
        for (Util.Pair componentActionPair : this.components) {
            this.splitLayoutPanel.insert(((Component)componentActionPair.getA()).getEntryWidget(), (Component)componentActionPair.getA(), DockLayoutPanel.Direction.SOUTH, 200.0, (HasPermissions.Action)componentActionPair.getB());
        }
    }

    public <SettingsType extends AbstractSettings> void showSettingsDialog(Component<SettingsType> component) {
        if (component.hasSettings()) {
            new SettingsDialog(component, (com.sap.sse.gwt.client.StringMessages)this.stringMessages).show();
        }
    }

    public void forceLayout() {
        if (!this.leftComponent.isVisible() && this.centerComponent.isVisible()) {
            if (this.isWidgetInSplitPanel((Widget)this.leftScrollPanel)) {
                this.splitLayoutPanel.setWidgetVisibility((Widget)this.leftScrollPanel, this.leftComponent, true, this.MIN_LEADERBOARD_WIDTH);
            }
        } else if (this.leftComponent.isVisible() && this.centerComponent.isVisible()) {
            this.splitLayoutPanel.setWidgetVisibility((Widget)this.leftScrollPanel, this.leftComponent, false, this.MIN_LEADERBOARD_WIDTH);
        } else if (!this.leftComponent.isVisible()) {
            this.centerComponent.isVisible();
        }
        if (!this.rightComponent.isVisible() && this.centerComponent.isVisible()) {
            if (this.isWidgetInSplitPanel((Widget)this.rightPanel)) {
                this.splitLayoutPanel.setWidgetVisibility((Widget)this.rightPanel, this.rightComponent, true, this.MIN_TAGGING_WIDTH);
            }
        } else if (this.rightComponent.isVisible() && this.centerComponent.isVisible()) {
            this.splitLayoutPanel.setWidgetVisibility((Widget)this.rightPanel, this.rightComponent, false, this.MIN_TAGGING_WIDTH);
        } else if (!this.rightComponent.isVisible()) {
            this.centerComponent.isVisible();
        }
        for (Util.Pair component : this.components) {
            boolean isComponentVisible = ((Component)component.getA()).isVisible();
            this.splitLayoutPanel.setWidgetVisibility(((Component)component.getA()).getEntryWidget(), (Component)component.getA(), !isComponentVisible, 200);
        }
        this.splitLayoutPanel.forceLayout();
    }

    private boolean isWidgetInSplitPanel(Widget widget) {
        int widgetIndex = this.splitLayoutPanel.getWidgetIndex(widget);
        return widgetIndex >= 0;
    }

    public Panel getViewerWidget() {
        return this.mainPanel;
    }

    public Component<?> getRootComponent() {
        return null;
    }

    public String getViewerName() {
        return "";
    }

    public void onUserStatusChange(UserDTO user, boolean preAuthenticated) {
        this.refreshMarkUi();
    }

    private void refreshMarkUi() {
        this.asyncLeaderboardFetcher.getLeaderboardWithSecurity(leaderboard -> {
            TouchSplitLayoutPanel.Splitter markPassingsSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.markPassingsPanel);
            TouchSplitLayoutPanel.Splitter markPositionSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.markPositionPanel);
            boolean forceLayout = false;
            if (this.userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
                if (markPassingsSplitter != null) {
                    markPassingsSplitter.getToggleButton().setVisible(true);
                }
                forceLayout = true;
            } else if (markPassingsSplitter != null) {
                this.markPassingsPanel.setVisible(false);
                markPassingsSplitter.getToggleButton().setVisible(false);
            }
            if (this.userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
                if (markPositionSplitter != null) {
                    markPositionSplitter.getToggleButton().setVisible(true);
                }
                forceLayout = true;
            } else {
                if (markPositionSplitter != null) {
                    this.markPositionPanel.setVisible(false);
                    markPositionSplitter.getToggleButton().setVisible(false);
                }
                this.forceLayout();
            }
            if (forceLayout) {
                this.forceLayout();
            }
            this.mediaManagementButton.setVisible(this.isMediaManagementVisible(this.mediaPlayerManagerComponent));
            this.centerComponent.setAddVideoToRaceButtonVisible(this.isMediaManagementVisible(this.mediaPlayerManagerComponent));
        });
    }

    void setLeftComponentToggleButtonTextVisibilityAndDraggerPosition(boolean visible) {
        TouchSplitLayoutPanel.Splitter leftScrollPanelSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.leftScrollPanel);
        if (leftScrollPanelSplitter != null) {
            Style toggleButtonStyle = leftScrollPanelSplitter.getToggleButton().getElement().getStyle();
            if (visible) {
                toggleButtonStyle.clearFontSize();
            } else {
                toggleButtonStyle.setFontSize(0.0, Style.Unit.PX);
            }
            Style drapperStyle = leftScrollPanelSplitter.getDragger().getElement().getStyle();
            if (visible) {
                drapperStyle.clearMarginTop();
            } else {
                drapperStyle.setMarginTop(-25.0, Style.Unit.PX);
            }
        }
    }

    void setRightComponentToggleButtonTextVisibilityAndDraggerPosition(boolean visible) {
        TouchSplitLayoutPanel.Splitter rightFlowPanelSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.rightPanel);
        if (rightFlowPanelSplitter != null) {
            Style toggleButtonStyle = rightFlowPanelSplitter.getToggleButton().getElement().getStyle();
            if (visible) {
                toggleButtonStyle.clearFontSize();
            } else {
                toggleButtonStyle.setFontSize(0.0, Style.Unit.PX);
            }
            Style drapperStyle = rightFlowPanelSplitter.getDragger().getElement().getStyle();
            if (visible) {
                drapperStyle.clearMarginTop();
            } else {
                drapperStyle.setMarginTop(-25.0, Style.Unit.PX);
            }
        }
    }

    public void setLeftComponentToggleButtonVisible(boolean visible) {
        TouchSplitLayoutPanel.Splitter leftScrollPanelSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.leftScrollPanel);
        if (leftScrollPanelSplitter != null) {
            leftScrollPanelSplitter.getToggleButton().setVisible(visible);
        }
    }

    public void setRightComponentToggleButtonVisible(boolean visible) {
        TouchSplitLayoutPanel.Splitter rightPanelSplitter = this.splitLayoutPanel.getAssociatedSplitter((Widget)this.rightPanel);
        if (rightPanelSplitter != null) {
            rightPanelSplitter.getToggleButton().setVisible(visible);
        }
    }

    public ScrollPanel getLeftScrollPanel() {
        return this.leftScrollPanel;
    }

    public Panel getRightPanel() {
        return this.rightPanel;
    }

    private boolean isMediaManagementVisible(MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        boolean canCreateNew = this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.MEDIA_TRACK);
        boolean canUpdateRace = this.userService.hasPermission(mediaPlayerManagerComponent.getCurrentRaceDTO(), (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
        boolean canDirectlyUpdateAnyExistingTrack = mediaPlayerManagerComponent.getAssignedMediaTracks().stream().anyMatch(track -> mediaPlayerManagerComponent.allowsEditing(track));
        return canCreateNew && canUpdateRace || canDirectlyUpdateAnyExistingTrack;
    }

    static /* synthetic */ Button access$0(SideBySideComponentViewer sideBySideComponentViewer) {
        return sideBySideComponentViewer.mediaSelectionButton;
    }

    static /* synthetic */ Button access$1(SideBySideComponentViewer sideBySideComponentViewer) {
        return sideBySideComponentViewer.mediaManagementButton;
    }

    static /* synthetic */ boolean access$2(SideBySideComponentViewer sideBySideComponentViewer, MediaPlayerManagerComponent mediaPlayerManagerComponent) {
        return sideBySideComponentViewer.isMediaManagementVisible(mediaPlayerManagerComponent);
    }

    static /* synthetic */ RaceMap access$3(SideBySideComponentViewer sideBySideComponentViewer) {
        return sideBySideComponentViewer.centerComponent;
    }
}

