/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.NavigatorUtil;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.support.SettingsUtil;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.LinkWithSettingsGenerator;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;

public class ShareLinkDialog
extends DataEntryDialog<String> {
    private final PerspectiveLifecycle<RaceBoardPerspectiveOwnSettings> lifecycle;
    private final PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> perspectiveCompositeSettings;
    private final LinkWithSettingsGenerator<Settings> linkWithSettingsGenerator;
    private final SailingServiceAsync sailingService;
    private CheckBox timeStampCheckbox;
    private CheckBox windChartCheckBox;
    private CheckBox leaderBoardPanelCheckBox;
    private CheckBox competitorChartCheckBox;
    private CheckBox filterSetNameCheckBox;
    private CheckBox competitorSelectionCheckBox;
    private CheckBox tagsCheckBox;
    private CheckBox maneuverCheckBox;
    private CheckBox zoomCheckBox;
    private TextBox linkField;
    private Image qrCodeImage;
    private VerticalPanel mainPanel;

    public ShareLinkDialog(String path, PerspectiveLifecycle<RaceBoardPerspectiveOwnSettings> lifecycle, PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> perspectiveCompositeSettings, SailingServiceAsync sailingService, StringMessages stringMessages, LinkWithSettingsGenerator<Settings> linkWithSettingsGenerator) {
        super(stringMessages.shareTheLink(), "", stringMessages.ok(), stringMessages.cancel(), null, null);
        this.lifecycle = lifecycle;
        this.perspectiveCompositeSettings = perspectiveCompositeSettings;
        this.sailingService = sailingService;
        this.linkWithSettingsGenerator = linkWithSettingsGenerator;
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setSpacing(30);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        VerticalPanel settingsPanel = new VerticalPanel();
        settingsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.add((Widget)settingsPanel);
        this.initializeCheckboxes(stringMessages, settingsPanel);
        VerticalPanel linkContentPanel = new VerticalPanel();
        linkContentPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.linkField = this.createTextBox(this.assembleLink());
        linkContentPanel.add((Widget)this.linkField);
        this.qrCodeImage = new Image();
        this.qrCodeImage.ensureDebugId("regattaSharingQrCode");
        this.qrCodeImage.setPixelSize(400, 400);
        this.qrCodeImage.setAltText(stringMessages.alternateTextIfQRCodeTooBig());
        if (NavigatorUtil.clientHasNavigatorCopyToClipboardSupport()) {
            Anchor copyToClipBoardAnchor = new Anchor(stringMessages.copyToClipboard());
            copyToClipBoardAnchor.addClickHandler(event -> NavigatorUtil.copyToClipboard((String)this.linkField.getText()));
            linkContentPanel.add((Widget)copyToClipBoardAnchor);
        }
        linkContentPanel.add((Widget)this.qrCodeImage);
        this.mainPanel.add((Widget)linkContentPanel);
    }

    private void initializeCheckboxes(StringMessages stringMessages, VerticalPanel settingsPanel) {
        this.timeStampCheckbox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.timeStampCheckBoxLabel());
        this.leaderBoardPanelCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.leaderboardCheckBoxLabel());
        this.tagsCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.tagsCheckBoxLabel());
        this.filterSetNameCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.filterSetNameCheckBoxLabel());
        this.competitorSelectionCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.competitorSelectionCheckBoxLabel());
        this.windChartCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.windChartCheckBoxLabel());
        this.competitorChartCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.competitorChartCheckBoxLabel());
        this.maneuverCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.maneuverCheckBoxLabel());
        this.zoomCheckBox = this.createCheckBoxAndAddToPanel(settingsPanel, stringMessages.zoomCheckBoxLabel());
    }

    public void initLinkAndShow() {
        String url = this.linkWithSettingsGenerator.createUrl((Settings)this.perspectiveCompositeSettings);
        this.createQrCode(url, () -> ((ShareLinkDialog)this).show());
    }

    void updateLink() {
        String url = this.assembleLink();
        this.linkField.setText(url);
        this.createQrCode(url, () -> {});
    }

    private void createQrCode(String url, Runnable callback) {
        this.sailingService.createRaceBoardLinkQrCode(url, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String assembleLink() {
        PerspectiveCompositeSettings patchedSettings = this.patchSettings();
        String url = this.linkWithSettingsGenerator.createUrl((Settings)patchedSettings);
        return url;
    }

    private PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> patchSettings() {
        PerspectiveCompositeSettings patchedSettings = (PerspectiveCompositeSettings)this.lifecycle.createDefaultSettings();
        SettingsUtil.copyValues((Settings)this.perspectiveCompositeSettings, (Settings)patchedSettings);
        RaceBoardPerspectiveOwnSettings patchedPerspectiveOwnSettings = (RaceBoardPerspectiveOwnSettings)patchedSettings.getPerspectiveOwnSettings();
        if (!this.competitorChartCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetShowCompetitorsChart();
        }
        if (!this.leaderBoardPanelCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetShowLeaderBoard();
        }
        if (!this.windChartCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetShowWindChart();
        }
        if (!this.tagsCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetShowTags();
        }
        if (!this.maneuverCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetShowManeuver();
        }
        if (!this.zoomCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetZoomStart();
            patchedPerspectiveOwnSettings.resetZoomEnd();
        }
        if (!this.timeStampCheckbox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetInitialDurationAfterRaceStartInReplay();
        }
        if (!this.filterSetNameCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetActiveCompetitorsFilterSetName();
        }
        if (!this.competitorSelectionCheckBox.getValue().booleanValue()) {
            patchedPerspectiveOwnSettings.resetSelectedCompetitor();
            patchedPerspectiveOwnSettings.resetSelectedCompetitors();
        }
        return patchedSettings;
    }

    protected String getResult() {
        return this.assembleLink();
    }

    protected Widget getAdditionalWidget() {
        return this.mainPanel;
    }

    private CheckBox createCheckBoxAndAddToPanel(VerticalPanel settingsPanel, String label) {
        CheckBox checkBox = this.createCheckbox(label);
        checkBox.setValue(Boolean.valueOf(true));
        checkBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        settingsPanel.add((Widget)checkBox);
        return checkBox;
    }

    static /* synthetic */ Image access$1(ShareLinkDialog shareLinkDialog) {
        return shareLinkDialog.qrCodeImage;
    }
}

