/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.AbstractRaceBoardMode;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardComponentContext;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorageAndAdditionalSettingsLayers;
import java.util.ArrayList;

public class FullAnalysisMode
extends AbstractRaceBoardMode {
    private boolean leaderboardSettingsAdjusted;
    private boolean timerAdjusted;

    protected void trigger() {
        if (!this.timerAdjusted && this.getRaceTimesInfoForRace() != null && this.getRaceTimesInfoForRace().endOfRace != null) {
            this.timerAdjusted = true;
            this.stopReceivingRaceTimesInfos();
            if (this.getTimer().getPlayMode() == Timer.PlayModes.Live) {
                this.getTimer().setPlayMode(Timer.PlayModes.Replay);
            }
            this.setTimerOrUseCustomStart((TimePoint)new MillisecondsTimePoint(this.getRaceTimesInfoForRace().endOfRace));
        }
        if (!this.leaderboardSettingsAdjusted && this.getLeaderboard() != null) {
            this.leaderboardSettingsAdjusted = true;
            this.stopReceivingLeaderboard();
            this.adjustLeaderboardSettings();
        }
    }

    private void adjustLeaderboardSettings() {
        SingleRaceLeaderboardPanel leaderboardPanel = this.getLeaderboardPanel();
        ArrayList<DetailType> raceDetailsToShow = new ArrayList<DetailType>();
        raceDetailsToShow.add(DetailType.RACE_DISPLAY_LEGS);
        raceDetailsToShow.add(DetailType.RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS);
        raceDetailsToShow.add(DetailType.RACE_DISTANCE_TRAVELED);
        raceDetailsToShow.add(DetailType.RACE_GAP_TO_LEADER_IN_SECONDS);
        SecurityChildSettingsContext context = new SecurityChildSettingsContext((SecuredDTO)this.getLeaderboard(), leaderboardPanel.getPaywallResolver());
        SingleRaceLeaderboardSettings additiveSettings = SingleRaceLeaderboardSettings.createDefaultSettingsWithRaceDetailValues(raceDetailsToShow, (SecurityChildSettingsContext)context);
        ((RaceBoardComponentContext)leaderboardPanel.getComponentContext()).addModesPatching((Component)leaderboardPanel, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$0(FullAnalysisMode fullAnalysisMode) {
        super.onInitializationFinished();
    }
}

