/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.FlowPanel;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.ui.client.FlagImageRenderer;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardResources;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardTableResources;
import com.sap.sse.common.CountryCode;
import com.sap.sse.gwt.client.celltable.FlushableSortedCellTableWithStylableHeaders;
import com.sap.sse.gwt.client.shared.components.ComponentResources;

public class ClassicLeaderboardStyle
implements LeaderboardPanel.LeaderBoardStyle {
    private static final LeaderboardResources resources = (LeaderboardResources)GWT.create(LeaderboardResources.class);
    private static final ComponentResources componentResources = (ComponentResources)GWT.create(ComponentResources.class);
    private static final LeaderboardTableResources tableResources = (LeaderboardTableResources)GWT.create(LeaderboardTableResources.class);

    public LeaderboardResources getResources() {
        return resources;
    }

    public ComponentResources getComponentresources() {
        return componentResources;
    }

    public LeaderboardTableResources getTableresources() {
        return tableResources;
    }

    public void renderNationalityFlag(ImageResource nationalityFlagImageResource, CountryCode countryCode, SafeHtmlBuilder sb) {
        if (countryCode == null) {
            sb.append(FlagImageRenderer.image((String)nationalityFlagImageResource.getSafeUri().asString()));
        } else {
            sb.append(FlagImageRenderer.imageWithTitle((String)nationalityFlagImageResource.getSafeUri().asString(), (String)countryCode.getName()));
        }
    }

    public void renderFlagImage(String flagImageURL, SafeHtmlBuilder sb, CompetitorDTO competitor) {
        sb.append(FlagImageRenderer.imageWithTitle((String)flagImageURL, (String)competitor.getName()));
    }

    public void processStyleForTotalNetPointsColumn(String textColor, SafeStylesBuilder ssb) {
        ssb.fontWeight(Style.FontWeight.BOLD);
        ssb.trustedColor(textColor);
    }

    public String determineBoatColorDivStyle(String competitorColor) {
        return "border-bottom: 2px solid " + competitorColor + ";";
    }

    public void processStyleForRaceColumnWithoutReasonForMaxPoints(boolean isDiscarded, SafeStylesBuilder ssb) {
        if (isDiscarded) {
            ssb.opacity(0.5);
        } else {
            ssb.fontWeight(Style.FontWeight.BOLD);
        }
    }

    public void afterConstructorHook(LeaderboardPanel<?> leaderboardPanel) {
    }

    public boolean hasRaceColumns() {
        return true;
    }

    public void hookLeaderBoardAttachment(FlowPanel contentPanel, FlushableSortedCellTableWithStylableHeaders<LeaderboardRowDTO> leaderboardTable) {
        contentPanel.add(leaderboardTable);
    }
}

