/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining.presentation;

import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class TackTypeSegmentsDataMiningSettingsDialogComponent
implements SettingsDialogComponent<TackTypeSegmentsDataMiningSettings> {
    private TackTypeSegmentsDataMiningSettings settings;
    private StringMessages stringMessages;
    private DoubleBox minimumDurationBetweenAdjacentTackTypeSegmentsInSecondsBox;
    private DoubleBox minimumTackTypeSegmentDurationInSecondsBox;

    public TackTypeSegmentsDataMiningSettingsDialogComponent(TackTypeSegmentsDataMiningSettings settings) {
        this.settings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Grid grid = new Grid(2, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        this.setupGrid(grid, dialog);
        return vp;
    }

    private void setupGrid(Grid grid, DataEntryDialog<?> dialog) {
        Label minDurationBetweenTackTypeSegmentsLabel = dialog.createLabel(this.stringMessages.minimumDurationBetweenAdjacentTackTypeSegmentsInSeconds());
        grid.setWidget(0, 0, (Widget)minDurationBetweenTackTypeSegmentsLabel);
        this.minimumDurationBetweenAdjacentTackTypeSegmentsInSecondsBox = dialog.createDoubleBox(this.settings.getMinimumTackTypeSegmentDuration() == null ? null : Double.valueOf(this.settings.getMinimumDurationBetweenAdjacentTackTypeSegments().asSeconds()), 10);
        grid.setWidget(0, 1, (Widget)this.minimumDurationBetweenAdjacentTackTypeSegmentsInSecondsBox);
        Label minTackTypeSegmentsDurationLabel = dialog.createLabel(this.stringMessages.minimumTackTypeSegmentsDurationInSeconds());
        grid.setWidget(1, 0, (Widget)minTackTypeSegmentsDurationLabel);
        this.minimumTackTypeSegmentDurationInSecondsBox = dialog.createDoubleBox(this.settings.getMinimumTackTypeSegmentDuration() == null ? null : Double.valueOf(this.settings.getMinimumTackTypeSegmentDuration().asSeconds()), 10);
        grid.setWidget(1, 1, (Widget)this.minimumTackTypeSegmentDurationInSecondsBox);
    }

    public TackTypeSegmentsDataMiningSettings getResult() {
        return new TackTypeSegmentsDataMiningSettings(this.getDurationFromSeconds((Double)this.minimumDurationBetweenAdjacentTackTypeSegmentsInSecondsBox.getValue()), this.getDurationFromSeconds((Double)this.minimumTackTypeSegmentDurationInSecondsBox.getValue()));
    }

    private Duration getDurationFromSeconds(Double seconds) {
        return seconds == null ? null : new MillisecondsDurationImpl((long)(seconds * 1000.0));
    }

    public FocusWidget getFocusWidget() {
        return this.minimumDurationBetweenAdjacentTackTypeSegmentsInSecondsBox;
    }

    public DataEntryDialog.Validator<TackTypeSegmentsDataMiningSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ StringMessages access$1(TackTypeSegmentsDataMiningSettingsDialogComponent tackTypeSegmentsDataMiningSettingsDialogComponent) {
        return tackTypeSegmentsDataMiningSettingsDialogComponent.stringMessages;
    }
}

