/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining.presentation;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsSettings;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsSettingsImpl;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class ManeuverSpeedDetailsSettingsDialogComponent
implements SettingsDialogComponent<ManeuverSpeedDetailsSettings> {
    private ManeuverSpeedDetailsSettings settings;
    private StringMessages stringMessages;
    private RadioButton maneuverDirectionNoNormalizationRadioButton;
    private RadioButton maneuverDirectionStarboardNormalizationRadioButton;
    private RadioButton maneuverDirectionPortNormalizationRadioButton;
    private CheckBox maneuverDirectionEqualWeightingEnabledCheckBox;

    public ManeuverSpeedDetailsSettingsDialogComponent(ManeuverSpeedDetailsSettings settings) {
        this.settings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Grid grid = new Grid(2, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        this.setupGrid(grid, dialog);
        return vp;
    }

    private void setupGrid(Grid grid, DataEntryDialog<?> dialog) {
        Label directionNormalizationLabel = dialog.createLabel(this.stringMessages.maneuverDirectionNormalization());
        grid.setWidget(0, 0, (Widget)directionNormalizationLabel);
        this.maneuverDirectionNoNormalizationRadioButton = dialog.createRadioButton("maneuverDirectionNormalization", this.stringMessages.disabled());
        this.maneuverDirectionStarboardNormalizationRadioButton = dialog.createRadioButton("maneuverDirectionNormalization", this.stringMessages.starboardSide());
        this.maneuverDirectionPortNormalizationRadioButton = dialog.createRadioButton("maneuverDirectionNormalization", this.stringMessages.portSide());
        if (this.settings.getNormalizedManeuverDirection() == NauticalSide.STARBOARD) {
            this.maneuverDirectionStarboardNormalizationRadioButton.setValue(Boolean.valueOf(true));
        } else if (this.settings.getNormalizedManeuverDirection() == NauticalSide.PORT) {
            this.maneuverDirectionPortNormalizationRadioButton.setValue(Boolean.valueOf(true));
        } else {
            this.maneuverDirectionNoNormalizationRadioButton.setValue(Boolean.valueOf(true));
        }
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)this.maneuverDirectionNoNormalizationRadioButton);
        vp.add((Widget)this.maneuverDirectionStarboardNormalizationRadioButton);
        vp.add((Widget)this.maneuverDirectionPortNormalizationRadioButton);
        grid.setWidget(0, 1, (Widget)vp);
        Label maneuverDirectionEqualWeightingEnabledLabel = dialog.createLabel(this.stringMessages.maneuverDirectionEqualWeightingEnabled());
        grid.setWidget(1, 0, (Widget)maneuverDirectionEqualWeightingEnabledLabel);
        this.maneuverDirectionEqualWeightingEnabledCheckBox = dialog.createCheckbox("");
        this.maneuverDirectionEqualWeightingEnabledCheckBox.setValue(Boolean.valueOf(this.settings.isManeuverDirectionEqualWeightingEnabled()));
        grid.setWidget(1, 1, (Widget)this.maneuverDirectionEqualWeightingEnabledCheckBox);
    }

    public ManeuverSpeedDetailsSettings getResult() {
        Object nauticalSide = this.maneuverDirectionPortNormalizationRadioButton.getValue() != false ? NauticalSide.PORT : (this.maneuverDirectionStarboardNormalizationRadioButton.getValue() != false ? NauticalSide.STARBOARD : null);
        return new ManeuverSpeedDetailsSettingsImpl(nauticalSide, this.maneuverDirectionEqualWeightingEnabledCheckBox.getValue().booleanValue());
    }

    public FocusWidget getFocusWidget() {
        return this.maneuverDirectionNoNormalizationRadioButton;
    }

    public DataEntryDialog.Validator<ManeuverSpeedDetailsSettings> getValidator() {
        return null;
    }
}

