/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.dto.StoredDataMiningReportDTO;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningReportDTOImpl;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningWriteServiceAsync;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;

public class StoredDataMiningReportsProvider {
    private final Set<StoredDataMiningReportDTO> storedReports = new HashSet();
    private final Set<Consumer<Collection<StoredDataMiningReportDTO>>> listeners = new HashSet();
    private final DataMiningServiceAsync dataMiningService;
    private final DataMiningWriteServiceAsync dataMiningWriteService;

    public StoredDataMiningReportsProvider(DataMiningServiceAsync dataMiningService, DataMiningWriteServiceAsync dataMiningWriteService) {
        this.dataMiningService = dataMiningService;
        this.dataMiningWriteService = dataMiningWriteService;
        this.reloadReports();
    }

    public void addReportsChangedListener(Consumer<Collection<StoredDataMiningReportDTO>> listener) {
        this.listeners.add(listener);
    }

    public StoredDataMiningReportDTO addOrUpdateReport(String name, DataMiningReportDTO report) {
        Optional existingStoredReport = this.findReportByName(name);
        boolean wasUpdate = existingStoredReport.isPresent();
        StoredDataMiningReportDTOImpl storedReport = new StoredDataMiningReportDTOImpl(existingStoredReport.map(esr -> esr.getId()).orElse(UUID.randomUUID()), name, report);
        this.dataMiningWriteService.updateOrCreateStoredReport(storedReport, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        return wasUpdate ? null : storedReport;
    }

    public boolean removeReport(String name) {
        Optional existingStoredReport = this.findReportByName(name);
        if (!existingStoredReport.isPresent()) {
            return false;
        }
        this.dataMiningWriteService.removeStoredReport((StoredDataMiningReportDTOImpl)existingStoredReport.get(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void reloadReports() {
        this.dataMiningService.retrieveStoredReports((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Optional<StoredDataMiningReportDTO> findReportByName(String name) {
        return this.storedReports.stream().filter(s -> s.getName().equals(name)).findAny();
    }

    public boolean hasReportWithName(String text) {
        return this.findReportByName(text).isPresent();
    }

    static /* synthetic */ Set access$0(StoredDataMiningReportsProvider storedDataMiningReportsProvider) {
        return storedDataMiningReportsProvider.storedReports;
    }

    static /* synthetic */ Set access$1(StoredDataMiningReportsProvider storedDataMiningReportsProvider) {
        return storedDataMiningReportsProvider.listeners;
    }
}

