/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.StoredDataMiningQueryPanel;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.dto.StoredDataMiningQueryDTO;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningQueryDTOImpl;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningWriteServiceAsync;
import com.sap.sse.datamining.ui.client.selection.QueryDefinitionProviderWithControls;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class StoredDataMiningQueryDataProvider {
    private final Set<StoredDataMiningQueryDTO> queryDefinitions = new HashSet();
    private final QueryDefinitionProviderWithControls queryDefinitionProvider;
    private final DataMiningServiceAsync dataMiningService;
    private final DataMiningWriteServiceAsync dataMiningWriteService;
    private final StringMessages stringMessages;
    private StoredDataMiningQueryPanel uiPanel;

    public StoredDataMiningQueryDataProvider(QueryDefinitionProviderWithControls queryDefinitionProvider, DataMiningServiceAsync dataMiningService, DataMiningWriteServiceAsync dataMiningWriteService, StringMessages stringMessages) {
        this.queryDefinitionProvider = queryDefinitionProvider;
        this.dataMiningService = dataMiningService;
        this.dataMiningWriteService = dataMiningWriteService;
        this.stringMessages = stringMessages;
    }

    public StatisticQueryDefinitionDTO getCurrentQuery() {
        return this.queryDefinitionProvider.getQueryDefinition();
    }

    public void addOrUpdateQuery(String name, StatisticQueryDefinitionDTO query, Consumer<Boolean> callback) {
        boolean update;
        StoredDataMiningQueryDTOImpl storedQuery;
        Optional findByName = this.findByName(name);
        if (findByName.isPresent()) {
            StoredDataMiningQueryDTO existingQuery = (StoredDataMiningQueryDTO)findByName.get();
            storedQuery = new StoredDataMiningQueryDTOImpl(name, existingQuery.getId(), query);
            update = true;
        } else {
            storedQuery = new StoredDataMiningQueryDTOImpl(name, UUID.randomUUID(), query);
            update = false;
        }
        this.dataMiningWriteService.updateOrCreateStoredQuery(storedQuery, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removeQuery(String name, Consumer<Boolean> callback) {
        Optional query = this.findByName(name);
        if (query.isPresent()) {
            this.dataMiningWriteService.removeStoredQuery((StoredDataMiningQueryDTOImpl)query.get(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            callback.accept(false);
        }
    }

    public boolean applyQuery(String name) {
        Optional query = this.findByName(name);
        if (query.isPresent()) {
            this.queryDefinitionProvider.applyQueryDefinition(((StoredDataMiningQueryDTO)query.get()).getQuery());
            return true;
        }
        return false;
    }

    public void setUiPanel(StoredDataMiningQueryPanel uiPanel) {
        this.uiPanel = uiPanel;
        this.refreshQueries();
    }

    private void updateUi() {
        if (this.uiPanel != null) {
            this.uiPanel.updateOracle((Collection)this.queryDefinitions.stream().map(StoredDataMiningQueryDTO::getName).collect(Collectors.toList()));
        }
    }

    private void refreshQueries() {
        this.dataMiningService.retrieveStoredQueries((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Optional<StoredDataMiningQueryDTO> findByName(String name) {
        return this.queryDefinitions.stream().filter(s -> s.getName().equals(name)).findAny();
    }

    public boolean containsQueryName(String text) {
        return this.findByName(text).isPresent();
    }

    static /* synthetic */ StringMessages access$0(StoredDataMiningQueryDataProvider storedDataMiningQueryDataProvider) {
        return storedDataMiningQueryDataProvider.stringMessages;
    }

    static /* synthetic */ Set access$1(StoredDataMiningQueryDataProvider storedDataMiningQueryDataProvider) {
        return storedDataMiningQueryDataProvider.queryDefinitions;
    }

    static /* synthetic */ void access$2(StoredDataMiningQueryDataProvider storedDataMiningQueryDataProvider) {
        storedDataMiningQueryDataProvider.updateUi();
    }
}

