/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.datamining.DataMiningReportStoreControls;
import com.sap.sailing.gwt.ui.datamining.StoredDataMiningReportsProvider;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.dto.StoredDataMiningReportDTO;
import com.sap.sse.datamining.ui.client.CompositeResultsPresenter;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import java.util.Collection;
import java.util.stream.Collectors;

public class DataMiningReportStoreControls
extends Composite {
    private static PersistDataMiningReportStoreControlsUiBinder uiBinder = (PersistDataMiningReportStoreControlsUiBinder)GWT.create(PersistDataMiningReportStoreControlsUiBinder.class);
    private final StringMessages stringMessages = StringMessages.INSTANCE;
    @UiField
    Button saveReportButtonUi;
    @UiField
    Button loadReportButtonUi;
    @UiField
    Button removeReportButtonUi;
    @UiField(provided=true)
    SuggestBox suggestBoxUi;
    private final ErrorReporter errorReporter;
    private final DataMiningSession session;
    private final DataMiningServiceAsync dataMiningService;
    private final Panel dataminingContentPanel;
    private final StoredDataMiningReportsProvider reportsProvider;
    private final CompositeResultsPresenter<?> resultsPresenter;
    private final MultiWordSuggestOracle oracle;
    private final Panel applyReportBusyIndicator;
    private final ReportProvider reportProvider;

    public DataMiningReportStoreControls(ErrorReporter errorReporter, DataMiningSession session, DataMiningServiceAsync dataMiningService, StoredDataMiningReportsProvider reportsProvider, Panel dataminingContentPanel, DataRetrieverChainDefinitionProvider retrieverChainProvider, CompositeResultsPresenter<?> resultsPresenter, ReportProvider reportProvider) {
        this.reportProvider = reportProvider;
        this.errorReporter = errorReporter;
        this.session = session;
        this.dataMiningService = dataMiningService;
        this.reportsProvider = reportsProvider;
        this.reportsProvider.addReportsChangedListener(reports -> this.updateOracle((Collection)reports.stream().map(r -> r.getName()).collect(Collectors.toList())));
        this.reportsProvider.reloadReports();
        this.dataminingContentPanel = dataminingContentPanel;
        this.resultsPresenter = resultsPresenter;
        this.oracle = new MultiWordSuggestOracle();
        this.suggestBoxUi = new SuggestBox((SuggestOracle)this.oracle, (ValueBoxBase)new TextBox(), (SuggestBox.SuggestionDisplay)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.saveReportButtonUi.setText(StringMessages.INSTANCE.save());
        this.loadReportButtonUi.setText(StringMessages.INSTANCE.load());
        this.removeReportButtonUi.setText(StringMessages.INSTANCE.remove());
        this.suggestBoxUi.getValueBox().getElement().setPropertyString("placeholder", StringMessages.INSTANCE.dataMiningStoredReportPlaceholder());
        this.suggestBoxUi.getValueBox().addClickHandler(e -> this.suggestBoxUi.showSuggestionList());
        this.suggestBoxUi.getValueBox().addKeyUpHandler(e -> this.updateSaveLoadButtons());
        this.suggestBoxUi.getValueBox().addBlurHandler(e -> this.updateSaveLoadButtons());
        SimplePanel glass = new SimplePanel();
        glass.addStyleName("whiteGlass");
        HTML labeledBusyIndicator = new HTML(SafeHtmlUtils.fromString((String)this.stringMessages.applyingReport()));
        labeledBusyIndicator.setStyleName("applyQueryBusyMessage");
        this.applyReportBusyIndicator = new LayoutPanel();
        this.applyReportBusyIndicator.add((Widget)glass);
        this.applyReportBusyIndicator.add((Widget)labeledBusyIndicator);
    }

    private void updateSaveLoadButtons() {
        String name = this.suggestBoxUi.getValueBox().getText();
        this.saveReportButtonUi.setEnabled(name != null && !"".equals(name.trim()));
        this.loadReportButtonUi.setEnabled(this.reportsProvider.hasReportWithName(name));
        this.removeReportButtonUi.setEnabled(this.reportsProvider.hasReportWithName(name));
    }

    @UiHandler(value={"saveReportButtonUi"})
    void onSaveClick(ClickEvent e) {
        String name = this.suggestBoxUi.getValue().trim();
        StoredDataMiningReportDTO report = this.buildReport();
        if (report == null) {
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportNoQueriesWereFound(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        } else {
            boolean wouldOverwriteDifferentReport = this.reportsProvider.findReportByName(name).map(existingEqualNamedReport -> !existingEqualNamedReport.getId().equals(report.getId())).orElse(false);
            if (!wouldOverwriteDifferentReport || Window.confirm((String)StringMessages.INSTANCE.overwriteExistingReportBySameName(name))) {
                StoredDataMiningReportDTO newStoredReportCreatedOrNullIfUpdate = this.reportsProvider.addOrUpdateReport(name, report.getReport());
                if (newStoredReportCreatedOrNullIfUpdate == null) {
                    Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportUpdateSuccessful(name), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                } else {
                    this.reportProvider.setCurrentReport(newStoredReportCreatedOrNullIfUpdate);
                    Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportCreationSuccessful(name), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }
            }
        }
    }

    @UiHandler(value={"loadReportButtonUi"})
    void onLoadClick(ClickEvent e) {
        String name = this.suggestBoxUi.getValue().trim();
        this.reportsProvider.findReportByName(name).map(arg_0 -> this.applyReport(arg_0)).orElseGet(() -> {
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportLoadedFailed(name), (Notification.NotificationType)Notification.NotificationType.ERROR);
            return null;
        });
    }

    @UiHandler(value={"removeReportButtonUi"})
    void onRemoveClick(ClickEvent e) {
        if (this.reportsProvider.removeReport(this.suggestBoxUi.getValue())) {
            this.suggestBoxUi.setValue("");
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportRemovedSuccessful(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
        } else {
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportRemovedFailed(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.ERROR);
        }
    }

    private StoredDataMiningReportDTO buildReport() {
        return this.reportProvider.getCurrentReport();
    }

    private StoredDataMiningReportDTO applyReport(StoredDataMiningReportDTO storedReport) {
        if (!Util.stream((Iterable)this.resultsPresenter.getPresenterIds()).map(presenterId -> this.resultsPresenter.getQueryDefinition(presenterId)).anyMatch(queryDefinition -> queryDefinition != null) || Window.confirm((String)StringMessages.INSTANCE.isItOkToReplaceAllTabsWithQueriesByReport())) {
            this.showBusyIndicator(true);
            DataMiningReportDTO report = storedReport.getReport();
            this.reportProvider.setCurrentReport(storedReport);
            Iterable reportQueries = report.getQueryDefinitions();
            if (!Util.isEmpty((Iterable)reportQueries)) {
                SequentialQueryExecutor executor = new SequentialQueryExecutor(this, reportQueries);
                executor.run(results -> {
                    this.resultsPresenter.showResults((Iterable)results);
                    this.showBusyIndicator(false);
                    if (!executor.hasErrorOccurred()) {
                        Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportLoadedSuccessful(storedReport.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    } else {
                        Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredReportLoadedWithErrors(storedReport.getName()), (Notification.NotificationType)Notification.NotificationType.WARNING);
                    }
                });
            }
        }
        return storedReport;
    }

    private void showBusyIndicator(boolean show) {
        if (show) {
            this.dataminingContentPanel.add((Widget)this.applyReportBusyIndicator);
        } else {
            this.dataminingContentPanel.remove((Widget)this.applyReportBusyIndicator);
        }
    }

    private void updateOracle(Collection<String> collection) {
        this.oracle.clear();
        this.oracle.addAll(collection);
        this.oracle.setDefaultSuggestionsFromText(collection);
        this.loadReportButtonUi.setEnabled(!collection.isEmpty());
        this.removeReportButtonUi.setEnabled(!collection.isEmpty());
        this.updateSaveLoadButtons();
    }

    static /* synthetic */ DataMiningServiceAsync access$0(DataMiningReportStoreControls dataMiningReportStoreControls) {
        return dataMiningReportStoreControls.dataMiningService;
    }

    static /* synthetic */ DataMiningSession access$1(DataMiningReportStoreControls dataMiningReportStoreControls) {
        return dataMiningReportStoreControls.session;
    }

    static /* synthetic */ ErrorReporter access$2(DataMiningReportStoreControls dataMiningReportStoreControls) {
        return dataMiningReportStoreControls.errorReporter;
    }

    static /* synthetic */ void access$3(DataMiningReportStoreControls dataMiningReportStoreControls) {
        dataMiningReportStoreControls.updateSaveLoadButtons();
    }
}

