/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.windladder;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.overlays.MapCanvasProjection;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import java.util.ArrayList;
import java.util.List;

public class LaylineClipper {
    protected final List<Position> markPositions = new ArrayList(1);
    protected PassingInstruction passingInstruction;
    protected LegType legType;
    protected Double maneuverAngleRadians;

    public void update(WaypointDTO waypointDto, LegType legType, double maneuverAngleRadians) {
        this.markPositions.clear();
        if (waypointDto != null) {
            for (MarkDTO mark : waypointDto.controlPoint.getMarks()) {
                this.markPositions.add(mark.position);
            }
            this.passingInstruction = waypointDto.passingInstructions;
        }
        this.legType = legType;
        this.maneuverAngleRadians = maneuverAngleRadians / 2.0;
    }

    public void clippingPath(double windRotation, int width, int height, Context2d ctx, MapCanvasProjection projection) {
        if (!(this.markPositions.isEmpty() || this.legType != LegType.UPWIND && this.legType != LegType.DOWNWIND)) {
            int rightMarkIndex;
            int leftMarkIndex;
            int size = this.markPositions.size();
            Point[] points = new Point[size];
            int i = 0;
            while (i < size) {
                Position pos = (Position)this.markPositions.get(i);
                points[i] = projection.fromLatLngToDivPixel(LatLng.newInstance((double)pos.getLatDeg(), (double)pos.getLngDeg()));
                ++i;
            }
            if (points.length == 1) {
                leftMarkIndex = 0;
                rightMarkIndex = 0;
            } else if (points[0].getX() < points[1].getX()) {
                leftMarkIndex = 0;
                rightMarkIndex = 1;
            } else {
                leftMarkIndex = 1;
                rightMarkIndex = 0;
            }
            ctx.translate((double)(width / 2), (double)(height / 2));
            ctx.beginPath();
            double length = 10000.0;
            Point start = this.legType == LegType.UPWIND ? this.laylineEndPoint(points[leftMarkIndex], 10000.0, -this.maneuverAngleRadians.doubleValue() - windRotation) : this.laylineEndPoint(points[leftMarkIndex], 10000.0, -this.maneuverAngleRadians.doubleValue() - windRotation + Math.PI);
            ctx.moveTo(start.getX(), start.getY());
            ctx.lineTo(points[leftMarkIndex].getX(), points[leftMarkIndex].getY());
            if (leftMarkIndex != rightMarkIndex) {
                ctx.lineTo(points[rightMarkIndex].getX(), points[rightMarkIndex].getY());
            }
            Point end = this.legType == LegType.UPWIND ? this.laylineEndPoint(points[rightMarkIndex], 10000.0, this.maneuverAngleRadians - windRotation) : this.laylineEndPoint(points[rightMarkIndex], 10000.0, this.maneuverAngleRadians - windRotation + Math.PI);
            ctx.lineTo(end.getX(), end.getY());
            ctx.closePath();
        }
    }

    protected Point laylineEndPoint(Point refPoint, double length, double radians) {
        double x = length * Math.sin(radians);
        double y = length * Math.cos(radians);
        return Point.newInstance((double)(refPoint.getX() + x), (double)(refPoint.getY() + y));
    }
}

