/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.windladder;

import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import java.util.function.Consumer;

public abstract class DoubleCanvasBuffer<T extends FullCanvasOverlay> {
    protected static final int BUFFER_SIZE = 2;
    protected T[] buffer;
    protected int activeBuffer = 0;

    protected void apply(Consumer<T> function) {
        FullCanvasOverlay[] fullCanvasOverlayArray = this.buffer;
        int n = this.buffer.length;
        int n2 = 0;
        while (n2 < n) {
            FullCanvasOverlay canvas = fullCanvasOverlayArray[n2];
            function.accept(canvas);
            ++n2;
        }
    }

    public void swap() {
        this.setVisible(false);
        this.activeBuffer = this.nextCanvasIndex();
        this.setVisible(true);
    }

    public T getActiveCanvas() {
        return (T)this.buffer[this.activeBuffer];
    }

    public boolean isVisible() {
        return this.getActiveCanvas().isVisible();
    }

    public void setVisible(boolean visible) {
        this.getActiveCanvas().setVisible(visible);
    }

    public void addToMap() {
        this.apply(overlay -> overlay.addToMap());
    }

    protected int nextCanvasIndex() {
        return (this.activeBuffer + 1) % 2;
    }
}

