/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.maneuver;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.CachedRaceDataProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableData;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTablePanel;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTablePanelResources;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableSettingsDialogComponent;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.SortableMinMaxColumn;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.shared.ManeuverDTO;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import com.sap.sse.gwt.client.celltable.SortableColumn;
import com.sap.sse.gwt.client.celltable.SortedCellTableWithStylableHeaders;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.TimeRangeProvider;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomModel;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ManeuverTablePanel
extends AbstractCompositeComponent<ManeuverTableSettings>
implements CompetitorSelectionChangeListener,
TimeListener {
    private static final Supplier<Long> LOADING_OFFSET_TO_NEXT_MANEUVER_PROVIDER = () -> 2500L;
    private final ManeuverTablePanelResources resources = (ManeuverTablePanelResources)GWT.create(ManeuverTablePanelResources.class);
    private final StringMessages stringMessages;
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final RaceCompetitorSelectionProvider competitorSelectionModel;
    private final SimplePanel contentPanel = new SimplePanel();
    private final Label importantMessageLabel = new Label();
    private final SortedCellTableWithStylableHeaders<ManeuverTableData> maneuverCellTable;
    private final SortableColumn<ManeuverTableData, ?> competitorColumn;
    private final SortableColumn<ManeuverTableData, ?> timeColumn;
    private final CachedRaceDataProvider<CompetitorDTO, ManeuverDTO> competitorDataProvider;
    private ManeuverTableSettings settings;
    private boolean hasCanReplayDuringLiveRacesPermission;

    public ManeuverTablePanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, RegattaAndRaceIdentifier raceIdentifier, StringMessages stringMessages, RaceCompetitorSelectionProvider competitorSelectionModel, ErrorReporter errorReporter, Timer timer, ManeuverTableSettings initialSettings, TimeRangeWithZoomModel timeRangeWithZoomProvider, LeaderboardPanel.LeaderBoardStyle style, UserService userService, RaceWithCompetitorsAndBoatsDTO raceDTO) {
        super(parent, context);
        1 userStatusChangeHandler = new /* Unavailable Anonymous Inner Class!! */;
        userService.addUserStatusEventHandler((UserStatusEventHandler)userStatusChangeHandler);
        userStatusChangeHandler.onUserStatusChange(userService.getCurrentUser(), true);
        this.resources.css().ensureInjected();
        this.settings = initialSettings;
        this.raceIdentifier = raceIdentifier;
        this.competitorSelectionModel = competitorSelectionModel;
        this.stringMessages = stringMessages;
        this.competitorDataProvider = new CachedManeuverTableDataProvider(this, (TimeRangeProvider)timeRangeWithZoomProvider, timer, sailingService, asyncActionsExecutor, null);
        this.competitorSelectionModel.addCompetitorSelectionChangeListener((CompetitorSelectionChangeListener)this);
        timer.addTimeListener((TimeListener)this);
        FlowPanel rootPanel = new FlowPanel();
        rootPanel.addStyleName(this.resources.css().maneuverPanel());
        this.contentPanel.addStyleName(this.resources.css().contentContainer());
        rootPanel.add((Widget)this.contentPanel);
        Button settingsButton = SettingsDialog.createSettingsButton((Component)this, (com.sap.sse.gwt.client.StringMessages)stringMessages);
        settingsButton.setStyleName(this.resources.css().settingsButton());
        rootPanel.add((Widget)settingsButton);
        this.importantMessageLabel.addStyleName(this.resources.css().importantMessage());
        this.maneuverCellTable = new SortedCellTableWithStylableHeaders(Integer.MAX_VALUE, (CellTable.Resources)style.getTableresources());
        this.maneuverCellTable.addStyleName(this.resources.css().maneuverTable());
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.maneuverCellTable.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.competitorColumn = this.createCompetitorColumn();
        this.maneuverCellTable.addColumn(this.competitorColumn);
        this.maneuverCellTable.addColumn(this.createManeuverTypeColumn());
        this.maneuverCellTable.addColumn(this.createMarkPassingColumn());
        this.timeColumn = this.createTimeColumn();
        this.maneuverCellTable.addColumn(this.timeColumn);
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getSpeedBeforeInKnots, this.stringMessages.speedIn(), this.stringMessages.knotsUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getSpeedAfterInKnots, this.stringMessages.speedOut(), this.stringMessages.knotsUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getSpeedChangeInKnots, this.stringMessages.speedChange(), this.stringMessages.knotsUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getLowestSpeedInKnots, this.stringMessages.lowestSpeed(), this.stringMessages.knotsUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getMaximumTurningRate, this.stringMessages.maxTurningRate(), this.stringMessages.degreesPerSecondUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getAverageTurningRate, this.stringMessages.avgTurningRate(), this.stringMessages.degreesPerSecondUnit()));
        this.maneuverCellTable.addColumn(this.createSortableMinMaxColumn(ManeuverTableData::getManeuverLossInMeters, this.stringMessages.maneuverLoss(), stringMessages.metersUnit()));
        this.maneuverCellTable.addColumn(this.createSortableAbsMinMaxColumn(ManeuverTableData::getDirectionChange, stringMessages.directionChange(), this.stringMessages.degreesShort()));
        this.initWidget((Widget)rootPanel);
        this.setVisible(false);
    }

    private SortableColumn<ManeuverTableData, String> createSortableAbsMinMaxColumn(Function<ManeuverTableData, Double> extractor, String title, String unit) {
        return new SortableMinMaxColumn(extractor, title, unit, this.maneuverCellTable.getDataProvider(), true);
    }

    private SortableColumn<ManeuverTableData, String> createSortableMinMaxColumn(Function<ManeuverTableData, Double> extractor, String title, String unit) {
        return new SortableMinMaxColumn(extractor, title, unit, this.maneuverCellTable.getDataProvider(), false);
    }

    private SortableColumn<ManeuverTableData, String> createManeuverTypeColumn() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SortableColumn<ManeuverTableData, Date> createTimeColumn() {
        4 comparator = new /* Unavailable Anonymous Inner Class!! */;
        5 col = new /* Unavailable Anonymous Inner Class!! */;
        col.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        return col;
    }

    private SortableColumn<ManeuverTableData, Boolean> createMarkPassingColumn() {
        6 comparator = new /* Unavailable Anonymous Inner Class!! */;
        8 column = new /* Unavailable Anonymous Inner Class!! */;
        column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        return column;
    }

    private SortableColumn<ManeuverTableData, ManeuverTableData> createCompetitorColumn() {
        9 comparator = new /* Unavailable Anonymous Inner Class!! */;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void rerender() {
        if (this.isVisible()) {
            if (Util.isEmpty((Iterable)this.competitorSelectionModel.getSelectedCompetitors())) {
                this.importantMessageLabel.setText(this.stringMessages.selectAtLeastOneCompetitorManeuver());
                this.contentPanel.setWidget((Widget)this.importantMessageLabel);
            } else if (!this.competitorDataProvider.hasCachedData()) {
                this.importantMessageLabel.setText(this.stringMessages.noDataFound());
                this.contentPanel.setWidget((Widget)this.importantMessageLabel);
            } else {
                this.contentPanel.setWidget((Widget)this.maneuverCellTable);
                this.showCompetitorColumn(Util.size((Iterable)this.competitorSelectionModel.getSelectedCompetitors()) != 1);
                this.updateManeuverTableData();
                this.updateManeuverTableColumnsWithMinMax();
                this.maneuverCellTable.restoreColumnSortInfos((Column)this.timeColumn);
                this.maneuverCellTable.redraw();
            }
        }
    }

    private void showCompetitorColumn(boolean show) {
        if (show && this.maneuverCellTable.getColumnIndex((Column)this.competitorColumn) == -1) {
            this.maneuverCellTable.insertColumn(0, this.competitorColumn);
        } else if (!show && this.maneuverCellTable.getColumnIndex((Column)this.competitorColumn) > -1) {
            this.maneuverCellTable.removeColumn((Column)this.competitorColumn);
        }
    }

    private void updateManeuverTableData() {
        ArrayList<ManeuverTableData> data = new ArrayList<ManeuverTableData>();
        Map cachedData = this.competitorDataProvider.getCachedData();
        for (Map.Entry entry : cachedData.entrySet()) {
            for (ManeuverDTO maneuver : (Iterable)entry.getValue()) {
                if (!this.settings.getSelectedManeuverTypes().contains(maneuver.getType())) continue;
                Color competitorColor = this.competitorSelectionModel.getColor((CompetitorDTO)entry.getKey(), this.raceIdentifier);
                data.add(new ManeuverTableData((CompetitorDTO)entry.getKey(), competitorColor.getAsHtml(), maneuver));
            }
        }
        this.maneuverCellTable.setList(data);
    }

    private void updateManeuverTableColumnsWithMinMax() {
        int i = 0;
        while (i < this.maneuverCellTable.getColumnCount()) {
            Column column = this.maneuverCellTable.getColumn(i);
            if (column instanceof AbstractSortableColumnWithMinMax) {
                ((AbstractSortableColumnWithMinMax)column).updateMinMax();
            }
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        boolean wasVisible = this.isVisible();
        super.setVisible(visible);
        if (wasVisible && !visible) {
            this.competitorDataProvider.removeAllEntries();
        } else if (!wasVisible && visible) {
            this.rerender();
            this.competitorDataProvider.ensureEntries(this.competitorSelectionModel.getSelectedCompetitors());
        }
    }

    public void addedToSelection(CompetitorDTO competitor) {
        if (this.isVisible()) {
            this.competitorDataProvider.ensureEntry((Object)competitor);
            this.rerender();
        }
    }

    public void removedFromSelection(CompetitorDTO competitor) {
        if (this.isVisible()) {
            this.competitorDataProvider.removeEntry((Object)competitor);
            this.rerender();
        }
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean hasSettings() {
        return true;
    }

    public String getLocalizedShortName() {
        return this.stringMessages.maneuverTable();
    }

    public String getDependentCssClassName() {
        return "table";
    }

    public void filterChanged(FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> oldFilterSet, FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> newFilterSet) {
    }

    public void competitorsListChanged(Iterable<CompetitorDTO> competitors) {
    }

    public void filteredCompetitorsListChanged(Iterable<CompetitorDTO> filteredCompetitors) {
    }

    public ManeuverTableSettings getSettings() {
        return this.settings;
    }

    public String getId() {
        return "mt";
    }

    public SettingsDialogComponent<ManeuverTableSettings> getSettingsDialogComponent(ManeuverTableSettings useTheseSettings) {
        return new ManeuverTableSettingsDialogComponent(useTheseSettings, this.stringMessages);
    }

    public void updateSettings(ManeuverTableSettings newSettings) {
        this.settings = newSettings;
        this.rerender();
    }

    public void timeChanged(Date newTime, Date oldTime) {
        if (this.isVisible()) {
            this.competitorDataProvider.updateEntryData();
        }
    }

    static /* synthetic */ Supplier access$3() {
        return LOADING_OFFSET_TO_NEXT_MANEUVER_PROVIDER;
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$4(ManeuverTablePanel maneuverTablePanel) {
        return maneuverTablePanel.raceIdentifier;
    }

    static /* synthetic */ void access$5(ManeuverTablePanel maneuverTablePanel) {
        maneuverTablePanel.rerender();
    }

    static /* synthetic */ void access$6(ManeuverTablePanel maneuverTablePanel, boolean bl) {
        maneuverTablePanel.hasCanReplayDuringLiveRacesPermission = bl;
    }

    static /* synthetic */ boolean access$7(ManeuverTablePanel maneuverTablePanel) {
        return maneuverTablePanel.hasCanReplayDuringLiveRacesPermission;
    }

    static /* synthetic */ StringMessages access$8(ManeuverTablePanel maneuverTablePanel) {
        return maneuverTablePanel.stringMessages;
    }
}

