/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.maneuver;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.shared.ManeuverDTO;
import java.util.Date;

class ManeuverTableData {
    private final String competitorName;
    private final String competitorColor;
    private final Date timePoint;
    private final Date timePointBefore;
    private final ManeuverType maneuverType;
    private final double speedBeforeInKnots;
    private final double speedAfterInKnots;
    private final double lowestSpeedInKnots;
    private final double maximumTurningRate;
    private final double averageTurningRate;
    private final Double maneuverLossInMeters;
    private final double directionChange;
    private final boolean markPassing;

    ManeuverTableData(CompetitorDTO competitor, String competitorColor, ManeuverDTO maneuver) {
        this.competitorName = competitor.getName();
        this.competitorColor = competitorColor;
        this.timePoint = maneuver.getTimePoint();
        this.timePointBefore = maneuver.getTimePointBefore();
        this.maneuverType = maneuver.getType();
        this.speedBeforeInKnots = maneuver.getSpeedWithBearingBefore().speedInKnots;
        this.speedAfterInKnots = maneuver.getSpeedWithBearingAfter().speedInKnots;
        this.lowestSpeedInKnots = maneuver.getLowestSpeedInKnots();
        this.maneuverLossInMeters = maneuver.getManeuverLoss() == null ? 0.0 : maneuver.getManeuverLoss().getDistanceLost().getMeters();
        this.directionChange = maneuver.getDirectionChangeInDegrees();
        this.maximumTurningRate = maneuver.getMaxTurningRateInDegreesPerSecond();
        this.averageTurningRate = maneuver.getAvgTurningRateInDegreesPerSecond();
        this.markPassing = maneuver.getMarkPassingTimePoint() != null && maneuver.getMarkPassingSide() != null;
    }

    public String getCompetitorName() {
        return this.competitorName;
    }

    public String getCompetitorColor() {
        return this.competitorColor;
    }

    public Date getTimePoint() {
        return this.timePoint;
    }

    public Date getTimePointBefore() {
        return this.timePointBefore;
    }

    public ManeuverType getManeuverType() {
        return this.maneuverType;
    }

    public boolean isMarkPassing() {
        return this.markPassing;
    }

    public double getSpeedBeforeInKnots() {
        return this.speedBeforeInKnots;
    }

    public double getSpeedAfterInKnots() {
        return this.speedAfterInKnots;
    }

    public double getSpeedChangeInKnots() {
        return this.getSpeedAfterInKnots() - this.getSpeedBeforeInKnots();
    }

    public double getLowestSpeedInKnots() {
        return this.lowestSpeedInKnots;
    }

    public double getMaximumTurningRate() {
        return this.maximumTurningRate;
    }

    public double getAverageTurningRate() {
        return this.averageTurningRate;
    }

    public Double getManeuverLossInMeters() {
        return this.maneuverLossInMeters;
    }

    public double getDirectionChange() {
        return this.directionChange;
    }
}

