/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.base.LatLng;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class RotateAndTranslateCoordinateSystem
implements CoordinateSystem {
    private final Position zeroZero;
    private final Bearing equator;
    private final Bearing rotationAngle;
    private static final Position ZERO_ZERO = new DegreePosition(0.0, 0.0);
    private static final Bearing EQUATOR_BEARING = new DegreeBearingImpl(90.0);
    private final double rotationAngleInDegrees;

    public RotateAndTranslateCoordinateSystem(Position zeroZero, Bearing equator) {
        this.zeroZero = zeroZero;
        this.equator = equator;
        this.rotationAngle = equator.getDifferenceTo((Bearing)new DegreeBearingImpl(90.0));
        this.rotationAngleInDegrees = this.rotationAngle.getDegrees();
    }

    public Position getPosition(LatLng p) {
        DegreePosition mapped = new DegreePosition(p.getLatitude(), p.getLongitude());
        return mapped.getTargetCoordinates(ZERO_ZERO, EQUATOR_BEARING, this.zeroZero, this.equator);
    }

    public Bearing map(Bearing bearing) {
        return bearing.add(this.rotationAngle);
    }

    public double mapDegreeBearing(double trueBearingInDegrees) {
        return (trueBearingInDegrees + this.rotationAngleInDegrees) % 360.0;
    }

    public LatLng toLatLng(Position position) {
        Position mapped = position.getLocalCoordinates(this.zeroZero, this.equator);
        return LatLng.newInstance((double)mapped.getLatDeg(), (double)mapped.getLngDeg());
    }
}

