/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LongBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.common.client.premium.SailingPremiumCheckBox;
import com.sap.sailing.gwt.ui.client.ManeuverTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapHelpLinesSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettingsTypeFormatter;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.security.ui.client.premium.PremiumCheckBox;
import com.sap.sse.security.ui.client.premium.settings.AbstractSecuredValueSetting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RaceMapSettingsDialogComponent
implements SettingsDialogComponent<RaceMapSettings> {
    private static final Distance MAX_BUOY_ZONE_RADIUS = new MeterDistance(100.0);
    private static final int MAX_STROKE_WEIGHT = 33;
    private List<Util.Pair<CheckBox, ManeuverType>> checkboxAndManeuverType = new ArrayList();
    private List<Util.Pair<CheckBox, RaceMapZoomSettings.ZoomTypes>> checkboxAndZoomType = new ArrayList();
    private List<Util.Pair<CheckBox, RaceMapHelpLinesSettings.HelpLineTypes>> checkboxAndHelpLineType = new ArrayList();
    private CheckBox zoomOnlyToSelectedCompetitorsCheckBox;
    private CheckBox showDouglasPeuckerPointsCheckBox;
    private CheckBox showOnlySelectedCompetitorsCheckBox;
    private PremiumCheckBox showWindStreamletOverlayCheckbox;
    private PremiumCheckBox showWindStreamletColorsCheckbox;
    private CheckBox showSatelliteLayerCheckbox;
    private CheckBox windUpCheckbox;
    private PremiumCheckBox showSimulationOverlayCheckbox;
    private CheckBox showSelectedCompetitorsInfoCheckBox;
    private LongBox tailLengthBox;
    private DoubleBox buoyZoneRadiusInMetersBox;
    private CheckBox transparentHoverlines;
    private IntegerBox hoverlineStrokeWeight;
    private DoubleBox startCountDownFontSizeScalingBox;
    private CheckBox maneuverLossVisualizationCheckBox;
    private CheckBox windLadderCheckBox;
    private boolean hasPolar;
    private final StringMessages stringMessages;
    private final RaceMapSettings initialSettings;
    private ArrayList<CheckBox> disableOnlySelectedWhenAreFalse;
    private CheckBox showEstimatedDuration;

    public RaceMapSettingsDialogComponent(RaceMapSettings settings, StringMessages stringMessages, boolean hasPolar) {
        this.stringMessages = stringMessages;
        this.initialSettings = settings;
        this.hasPolar = hasPolar;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Label generalLabel = dialog.createHeadlineLabel(this.stringMessages.general());
        vp.add((Widget)generalLabel);
        this.showSatelliteLayerCheckbox = dialog.createCheckbox(this.stringMessages.showSatelliteLayer());
        this.showSatelliteLayerCheckbox.setValue(Boolean.valueOf(this.initialSettings.isShowSatelliteLayer()));
        this.showSatelliteLayerCheckbox.getElement().setAttribute("selenium_checkbox", String.valueOf(this.initialSettings.isShowSatelliteLayer()));
        this.showSatelliteLayerCheckbox.ensureDebugId("showSatelliteLayerCheckBox");
        this.showSatelliteLayerCheckbox.setEnabled(!this.initialSettings.isWindUp());
        vp.add((Widget)this.showSatelliteLayerCheckbox);
        this.windUpCheckbox = dialog.createCheckbox(this.stringMessages.windUp());
        this.windUpCheckbox.setValue(Boolean.valueOf(this.initialSettings.isWindUp()));
        this.windUpCheckbox.getElement().setAttribute("selenium_checkbox", String.valueOf(this.initialSettings.isWindUp()));
        this.windUpCheckbox.ensureDebugId("windUpCheckBox");
        vp.add((Widget)this.windUpCheckbox);
        this.showWindStreamletOverlayCheckbox = (PremiumCheckBox)dialog.create(() -> new SailingPremiumCheckBox(this.stringMessages.showWindStreamletOverlay(), (AbstractSecuredValueSetting)this.initialSettings.getShowWindStreamletOverlaySetting()));
        this.showWindStreamletOverlayCheckbox.ensureDebugId("showWindStreamletOverlayCheckBox");
        vp.add((Widget)this.showWindStreamletOverlayCheckbox);
        this.showWindStreamletColorsCheckbox = (PremiumCheckBox)dialog.create(() -> new SailingPremiumCheckBox(this.stringMessages.showWindStreamletColors(), (AbstractSecuredValueSetting)this.initialSettings.getShowWindStreamletColorsSetting()));
        this.showWindStreamletColorsCheckbox.setEnabled(this.initialSettings.isShowWindStreamletOverlay());
        this.showWindStreamletColorsCheckbox.addStyleName("RaceMapSettingsDialogCheckBoxIntended");
        vp.add((Widget)this.showWindStreamletColorsCheckbox);
        this.showWindStreamletOverlayCheckbox.addValueChangeHandler(event -> this.showWindStreamletColorsCheckbox.setEnabled(this.showWindStreamletOverlayCheckbox.getValue().booleanValue()));
        if (this.hasPolar) {
            this.showEstimatedDuration = dialog.createCheckbox(this.stringMessages.showEstimatedDuration());
            this.showEstimatedDuration.ensureDebugId("showEstimatedDurationCheckBox");
            this.showEstimatedDuration.setValue(Boolean.valueOf(this.initialSettings.isShowEstimatedDuration()));
            vp.add((Widget)this.showEstimatedDuration);
            this.showSimulationOverlayCheckbox = (PremiumCheckBox)dialog.create(() -> new SailingPremiumCheckBox(this.stringMessages.showSimulationOverlay(), (AbstractSecuredValueSetting)this.initialSettings.getShowSimulationOverlaySetting()));
            this.showSimulationOverlayCheckbox.ensureDebugId("showSimulationOverlayCheckBox");
            vp.add((Widget)this.showSimulationOverlayCheckbox);
        }
        Label competitorsLabel = dialog.createHeadlineLabel(this.stringMessages.competitors());
        vp.add((Widget)competitorsLabel);
        this.showOnlySelectedCompetitorsCheckBox = dialog.createCheckbox(this.stringMessages.showOnlySelectedCompetitors());
        this.showOnlySelectedCompetitorsCheckBox.ensureDebugId("showOnlySelectedCompetitorsCheckBox");
        this.showOnlySelectedCompetitorsCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowOnlySelectedCompetitors()));
        vp.add((Widget)this.showOnlySelectedCompetitorsCheckBox);
        this.showSelectedCompetitorsInfoCheckBox = dialog.createCheckbox(this.stringMessages.showSelectedCompetitorsInfo());
        this.showSelectedCompetitorsInfoCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowSelectedCompetitorsInfo()));
        vp.add((Widget)this.showSelectedCompetitorsInfoCheckBox);
        Label zoomLabel = dialog.createHeadlineLabel(this.stringMessages.zoom());
        vp.add((Widget)zoomLabel);
        HorizontalPanel zoomSettingsPanel = new HorizontalPanel();
        Label zoomSettingsLabel = new Label(String.valueOf(this.stringMessages.autoZoomTo()) + ": ");
        zoomSettingsPanel.add((Widget)zoomSettingsLabel);
        VerticalPanel zoomSettingsBoxesPanel = new VerticalPanel();
        this.disableOnlySelectedWhenAreFalse = new ArrayList();
        RaceMapZoomSettings.ZoomTypes[] zoomTypesArray = RaceMapZoomSettings.ZoomTypes.values();
        int n = zoomTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            RaceMapZoomSettings.ZoomTypes zoomType = zoomTypesArray[n2];
            if (zoomType != RaceMapZoomSettings.ZoomTypes.NONE) {
                CheckBox cb = dialog.createCheckbox(RaceMapSettingsTypeFormatter.formatZoomType((RaceMapZoomSettings.ZoomTypes)zoomType, (StringMessages)this.stringMessages));
                cb.setValue(Boolean.valueOf(Util.contains((Iterable)this.initialSettings.getZoomSettings().getTypesToConsiderOnZoom(), (Object)zoomType)), false);
                this.checkboxAndZoomType.add(new Util.Pair((Object)cb, (Object)zoomType));
                zoomSettingsBoxesPanel.add((Widget)cb);
                if (zoomType == RaceMapZoomSettings.ZoomTypes.BOATS || zoomType == RaceMapZoomSettings.ZoomTypes.TAILS) {
                    this.disableOnlySelectedWhenAreFalse.add(cb);
                    cb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            ++n2;
        }
        zoomSettingsPanel.add((Widget)zoomSettingsBoxesPanel);
        vp.add((Widget)zoomSettingsPanel);
        this.zoomOnlyToSelectedCompetitorsCheckBox = dialog.createCheckbox(this.stringMessages.autoZoomSelectedCompetitors());
        this.zoomOnlyToSelectedCompetitorsCheckBox.setValue(Boolean.valueOf(this.initialSettings.getZoomSettings().isZoomToSelectedCompetitors()));
        vp.add((Widget)this.zoomOnlyToSelectedCompetitorsCheckBox);
        this.zoomSettingsChanged();
        Label maneuversLabel = dialog.createHeadlineLabel(this.stringMessages.maneuverTypesToShowWhenCompetitorIsClicked());
        vp.add((Widget)maneuversLabel);
        int checkBoxCount = ManeuverType.values().length + 1;
        int gridRowsRequired = checkBoxCount / 2 + checkBoxCount % 2;
        Grid maneuverGrid = new Grid(gridRowsRequired, 2);
        vp.add((Widget)maneuverGrid);
        int currentRowIndex = 0;
        int currentColumnIndex = 0;
        ManeuverType[] maneuverTypeArray = ManeuverType.values();
        int n3 = maneuverTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ManeuverType maneuverType = maneuverTypeArray[n4];
            CheckBox checkbox = dialog.createCheckbox(ManeuverTypeFormatter.format((ManeuverType)maneuverType, (StringMessages)this.stringMessages));
            checkbox.setValue(Boolean.valueOf(this.initialSettings.isShowManeuverType(maneuverType)));
            this.checkboxAndManeuverType.add(new Util.Pair((Object)checkbox, (Object)maneuverType));
            maneuverGrid.setWidget(currentRowIndex++, currentColumnIndex, (Widget)checkbox);
            if (currentRowIndex >= gridRowsRequired) {
                currentColumnIndex = 1;
                currentRowIndex = 0;
            }
            ++n4;
        }
        this.showDouglasPeuckerPointsCheckBox = dialog.createCheckbox(this.stringMessages.douglasPeuckerPoints());
        this.showDouglasPeuckerPointsCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowDouglasPeuckerPoints()));
        maneuverGrid.setWidget(currentRowIndex, currentColumnIndex, (Widget)this.showDouglasPeuckerPointsCheckBox);
        Label helpLinesLabel = dialog.createHeadlineLabel(this.stringMessages.helpLines());
        vp.add((Widget)helpLinesLabel);
        HorizontalPanel tailSettingsPanel = new HorizontalPanel();
        CheckBox showTailsCheckBox = this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS);
        tailSettingsPanel.add((Widget)showTailsCheckBox);
        showTailsCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Label tailLengthLabel = new Label(String.valueOf(this.stringMessages.lengthInSeconds()) + ":");
        tailLengthLabel.getElement().getStyle().setMarginLeft(25.0, Style.Unit.PX);
        tailSettingsPanel.add((Widget)tailLengthLabel);
        tailSettingsPanel.setCellVerticalAlignment((Widget)tailLengthLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.tailLengthBox = dialog.createLongBox((long)((int)(this.initialSettings.getTailLengthInMilliseconds() / 1000L)), 4);
        this.tailLengthBox.setEnabled(this.initialSettings.getHelpLinesSettings().isVisible(RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS));
        tailSettingsPanel.add((Widget)this.tailLengthBox);
        tailSettingsPanel.setCellVerticalAlignment((Widget)this.tailLengthBox, HasVerticalAlignment.ALIGN_MIDDLE);
        vp.add((Widget)tailSettingsPanel);
        HorizontalPanel buoyZoneSettingsPanel = new HorizontalPanel();
        CheckBox showBuoyZoneCheckBox = this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.BUOYZONE);
        buoyZoneSettingsPanel.add((Widget)showBuoyZoneCheckBox);
        showBuoyZoneCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Label buoyZoneRadiusLabel = new Label(String.valueOf(this.stringMessages.radiusInMeters()) + ":");
        buoyZoneRadiusLabel.getElement().getStyle().setMarginLeft(25.0, Style.Unit.PX);
        buoyZoneSettingsPanel.add((Widget)buoyZoneRadiusLabel);
        buoyZoneSettingsPanel.setCellVerticalAlignment((Widget)buoyZoneRadiusLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.buoyZoneRadiusInMetersBox = dialog.createDoubleBox(Double.valueOf(this.initialSettings.getBuoyZoneRadius().getMeters()), 4);
        this.buoyZoneRadiusInMetersBox.setEnabled(this.initialSettings.getHelpLinesSettings().isVisible(RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS));
        buoyZoneSettingsPanel.add((Widget)this.buoyZoneRadiusInMetersBox);
        buoyZoneSettingsPanel.setCellVerticalAlignment((Widget)this.buoyZoneRadiusInMetersBox, HasVerticalAlignment.ALIGN_MIDDLE);
        vp.add((Widget)buoyZoneSettingsPanel);
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.STARTLINE));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.FINISHLINE));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.ADVANTAGELINE));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.COURSEMIDDLELINE));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.STARTLINETOFIRSTMARKTRIANGLE));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.COURSEGEOMETRY));
        vp.add((Widget)this.createHelpLineCheckBox(dialog, RaceMapHelpLinesSettings.HelpLineTypes.COURSEAREACIRCLES));
        this.maneuverLossVisualizationCheckBox = dialog.createCheckbox(this.stringMessages.maneuverLoss());
        this.maneuverLossVisualizationCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowManeuverLossVisualization()));
        vp.add((Widget)this.maneuverLossVisualizationCheckBox);
        this.windLadderCheckBox = dialog.createCheckbox(this.stringMessages.showWindLadder());
        this.windLadderCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowWindLadder()));
        vp.add((Widget)this.windLadderCheckBox);
        this.transparentHoverlines = dialog.createCheckbox(this.stringMessages.transparentBufferLineOnHover());
        this.transparentHoverlines.ensureDebugId("transparentHoverlinesCheckBox");
        this.transparentHoverlines.setValue(Boolean.valueOf(this.initialSettings.getTransparentHoverlines()));
        vp.add((Widget)this.transparentHoverlines);
        HorizontalPanel hoverlineStrokeWeightPanel = new HorizontalPanel();
        Label hoverlineStrokeWeightLabel = new Label(String.valueOf(this.stringMessages.bufferLineStrokeWeight()) + ":");
        hoverlineStrokeWeightPanel.add((Widget)hoverlineStrokeWeightLabel);
        this.hoverlineStrokeWeight = dialog.createIntegerBox(Integer.valueOf(this.initialSettings.getHoverlineStrokeWeight()), 3);
        hoverlineStrokeWeightPanel.add((Widget)this.hoverlineStrokeWeight);
        vp.add((Widget)hoverlineStrokeWeightPanel);
        HorizontalPanel startCountDownFontSizeScalingPanel = new HorizontalPanel();
        Label startCountDownFontSizeScalingLabel = new Label(String.valueOf(this.stringMessages.startCountDownFontSizeScaling()) + ":");
        startCountDownFontSizeScalingPanel.add((Widget)startCountDownFontSizeScalingLabel);
        this.startCountDownFontSizeScalingBox = dialog.createDoubleBox(Double.valueOf(this.initialSettings.getStartCountDownFontSizeScaling()), 3);
        startCountDownFontSizeScalingPanel.add((Widget)this.startCountDownFontSizeScalingBox);
        vp.add((Widget)startCountDownFontSizeScalingPanel);
        return vp;
    }

    private CheckBox createHelpLineCheckBox(DataEntryDialog<?> dialog, RaceMapHelpLinesSettings.HelpLineTypes helpLineType) {
        CheckBox cb = dialog.createCheckbox(RaceMapSettingsTypeFormatter.formatHelpLineType((RaceMapHelpLinesSettings.HelpLineTypes)helpLineType, (StringMessages)this.stringMessages));
        cb.setValue(Boolean.valueOf(this.initialSettings.getHelpLinesSettings().isVisible(helpLineType)));
        this.checkboxAndHelpLineType.add(new Util.Pair((Object)cb, (Object)helpLineType));
        return cb;
    }

    private void zoomSettingsChanged() {
        boolean disableOnlySelected = true;
        for (Util.Pair pair : this.checkboxAndZoomType) {
            ((CheckBox)pair.getA()).setEnabled(true);
            if (!this.disableOnlySelectedWhenAreFalse.contains(pair.getA()) || !((CheckBox)pair.getA()).getValue().booleanValue()) continue;
            disableOnlySelected = false;
        }
        this.zoomOnlyToSelectedCompetitorsCheckBox.setEnabled(!disableOnlySelected);
        if (disableOnlySelected) {
            this.zoomOnlyToSelectedCompetitorsCheckBox.setValue(Boolean.valueOf(false));
        }
    }

    public RaceMapSettings getResult() {
        HashSet<ManeuverType> maneuverTypesToShow = new HashSet<ManeuverType>();
        for (Util.Pair p : this.checkboxAndManeuverType) {
            if (!((CheckBox)p.getA()).getValue().booleanValue()) continue;
            maneuverTypesToShow.add((ManeuverType)p.getB());
        }
        RaceMapHelpLinesSettings helpLinesSettings = this.getHelpLinesSettings();
        RaceMapZoomSettings zoomSettings = this.getZoomSettings();
        boolean estimatedDuration = this.showEstimatedDuration != null ? this.showEstimatedDuration.getValue() : false;
        boolean showSimulationOverlay = this.showSimulationOverlayCheckbox != null ? this.showSimulationOverlayCheckbox.getValue() : false;
        long tailLengthInMilliseconds = this.initialSettings.getTailLengthInMilliseconds();
        if (helpLinesSettings.isVisible(RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS)) {
            tailLengthInMilliseconds = this.tailLengthBox.getValue() == null ? -1L : (Long)this.tailLengthBox.getValue() * 1000L;
        }
        Distance buoyZoneRadius = this.initialSettings.getBuoyZoneRadius();
        if (helpLinesSettings.isVisible(RaceMapHelpLinesSettings.HelpLineTypes.BUOYZONE) && this.buoyZoneRadiusInMetersBox.getValue() != null) {
            buoyZoneRadius = new MeterDistance(((Double)this.buoyZoneRadiusInMetersBox.getValue()).doubleValue());
        }
        return new RaceMapSettings(zoomSettings, helpLinesSettings, this.transparentHoverlines.getValue(), (Integer)this.hoverlineStrokeWeight.getValue(), Long.valueOf(tailLengthInMilliseconds), this.windUpCheckbox.getValue(), buoyZoneRadius, this.showOnlySelectedCompetitorsCheckBox.getValue(), this.showSelectedCompetitorsInfoCheckBox.getValue(), this.showWindStreamletColorsCheckbox.getValue(), this.showWindStreamletOverlayCheckbox.getValue(), Boolean.valueOf(showSimulationOverlay), Boolean.valueOf(this.initialSettings.isShowMapControls()), maneuverTypesToShow, this.showDouglasPeuckerPointsCheckBox.getValue(), Boolean.valueOf(estimatedDuration), (Double)this.startCountDownFontSizeScalingBox.getValue(), this.maneuverLossVisualizationCheckBox.getValue(), this.showSatelliteLayerCheckbox.getValue(), this.windLadderCheckBox.getValue(), this.initialSettings.getPaywallResolver(), this.initialSettings.getSecuredDTO());
    }

    private RaceMapZoomSettings getZoomSettings() {
        ArrayList<RaceMapZoomSettings.ZoomTypes> zoomTypes = new ArrayList<RaceMapZoomSettings.ZoomTypes>();
        boolean noAutoZoomSelected = true;
        for (Util.Pair pair : this.checkboxAndZoomType) {
            if (!((CheckBox)pair.getA()).getValue().booleanValue()) continue;
            zoomTypes.add((RaceMapZoomSettings.ZoomTypes)pair.getB());
            noAutoZoomSelected = false;
        }
        if (noAutoZoomSelected) {
            zoomTypes.add(RaceMapZoomSettings.ZoomTypes.NONE);
        }
        return new RaceMapZoomSettings(zoomTypes, this.zoomOnlyToSelectedCompetitorsCheckBox.getValue().booleanValue());
    }

    private RaceMapHelpLinesSettings getHelpLinesSettings() {
        HashSet<RaceMapHelpLinesSettings.HelpLineTypes> helpLineTypes = new HashSet<RaceMapHelpLinesSettings.HelpLineTypes>();
        for (Util.Pair pair : this.checkboxAndHelpLineType) {
            if (!((CheckBox)pair.getA()).getValue().booleanValue()) continue;
            helpLineTypes.add((RaceMapHelpLinesSettings.HelpLineTypes)pair.getB());
        }
        return new RaceMapHelpLinesSettings(helpLineTypes);
    }

    public DataEntryDialog.Validator<RaceMapSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public FocusWidget getFocusWidget() {
        return this.showWindStreamletOverlayCheckbox.getFocusWidget();
    }

    static /* synthetic */ void access$1(RaceMapSettingsDialogComponent raceMapSettingsDialogComponent) {
        raceMapSettingsDialogComponent.zoomSettingsChanged();
    }

    static /* synthetic */ LongBox access$2(RaceMapSettingsDialogComponent raceMapSettingsDialogComponent) {
        return raceMapSettingsDialogComponent.tailLengthBox;
    }

    static /* synthetic */ DoubleBox access$3(RaceMapSettingsDialogComponent raceMapSettingsDialogComponent) {
        return raceMapSettingsDialogComponent.buoyZoneRadiusInMetersBox;
    }

    static /* synthetic */ StringMessages access$4(RaceMapSettingsDialogComponent raceMapSettingsDialogComponent) {
        return raceMapSettingsDialogComponent.stringMessages;
    }

    static /* synthetic */ Distance access$5() {
        return MAX_BUOY_ZONE_RADIUS;
    }
}

