/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.overlays.Marker;
import com.google.gwt.maps.client.overlays.MarkerOptions;
import com.google.gwt.maps.client.overlays.Polyline;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.ManeuverTypeFormatter;
import com.sap.sailing.gwt.ui.client.NauticalSideFormatter;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.LineInfoProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.ManeuverColor;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.SmallTransparentInfoOverlay;
import com.sap.sailing.gwt.ui.shared.ManeuverDTO;
import com.sap.sailing.gwt.ui.shared.SpeedWithBearingDTO;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.ErrorReporter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManeuverMarkersAndLossIndicators {
    private static final String MANEUVERLOSSLINES_PROJECTEDLINES_COLOR = "#ffff00";
    private static final String MANEUVERLOSSLINES_EXTRAPOLATEDLINES_COLOR = "#ffffff";
    private static final String MANEUVERLOSSLINES_RED = "#ff0000";
    private static final String MANEUVERLOSSLINES_GREEN = "#00ff00";
    private static final double LOWLIGHTED_LINE_OPACITY = 0.5;
    private static final int HIGHLIGHTED_LINE_STROKEWEIGHT = 2;
    private static final NumberFormat numberFormatOneDecimal = NumberFormatterFactory.getDecimalFormat((int)1);
    private final RaceMap raceMap;
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private Map<CompetitorDTO, List<ManeuverDTO>> lastManeuverResult;
    private final Map<Util.Triple<String, Date, ManeuverType>, Marker> maneuverMarkers;
    private final Map<Util.Triple<String, Date, ManeuverType>, Set<Polyline>> maneuverLossLinesMap;
    private final Map<Util.Triple<String, Date, ManeuverType>, SmallTransparentInfoOverlay> maneuverLossInfoOverlayMap;
    final LineInfoProvider middleManeuverAngleLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;
    final LineInfoProvider extrapolatedLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;
    final LineInfoProvider projectedExtrapolatedLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;
    final LineInfoProvider projectedManeuverEndLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;
    final LineInfoProvider maneuverLossLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;
    final LineInfoProvider bearingAtManeuverEndPositionLineInfoProvider = new /* Unavailable Anonymous Inner Class!! */;

    public ManeuverMarkersAndLossIndicators(RaceMap raceMap, SailingServiceAsync sailingService, ErrorReporter errorReporter, StringMessages stringMessages) {
        this.raceMap = raceMap;
        this.sailingService = sailingService;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.maneuverMarkers = new HashMap();
        this.maneuverLossLinesMap = new HashMap();
        this.maneuverLossInfoOverlayMap = new HashMap();
    }

    public void getAndShowManeuvers(RegattaAndRaceIdentifier race, Map<CompetitorDTO, TimeRange> timeRange) {
        this.sailingService.getManeuvers(race, timeRange, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    void removeAllManeuverMarkers() {
        for (Map.Entry keyAndMarker : new HashSet(this.maneuverMarkers.entrySet())) {
            this.removeManeuverMarker((Util.Triple)keyAndMarker.getKey(), (Marker)keyAndMarker.getValue());
        }
    }

    private void removeManeuverMarker(Util.Triple<String, Date, ManeuverType> key, Marker marker) {
        marker.setMap(null);
        this.removeManeuverLossLinesAndInfoOverlayForManeuver(key);
        this.maneuverMarkers.remove(key);
    }

    private void showManeuvers(Map<CompetitorDTO, List<ManeuverDTO>> maneuvers) {
        if (this.raceMap.getMap() != null && maneuvers != null) {
            for (Map.Entry<CompetitorDTO, List<ManeuverDTO>> e : maneuvers.entrySet()) {
                CompetitorDTO competitorDTO = e.getKey();
                List<ManeuverDTO> maneuversForCompetitor = e.getValue();
                for (ManeuverDTO maneuver : maneuversForCompetitor) {
                    if (!this.raceMap.getSettings().isShowManeuverType(maneuver.getType())) continue;
                    this.createAndAddMarkerOfManeuver(maneuver, competitorDTO);
                }
            }
        }
    }

    private void createAndAddMarkerOfManeuver(ManeuverDTO maneuver, CompetitorDTO competitor) {
        LatLng latLng = this.raceMap.getCoordinateSystem().toLatLng(maneuver.getPosition());
        Marker maneuverMarker = (Marker)this.raceMap.getRaceMapImageManager().getManeuverIconsForTypeAndDirectionIndicatingColor().get(new Util.Pair((Object)maneuver.getType(), (Object)ManeuverColor.getManeuverColor((ManeuverDTO)maneuver)));
        MarkerOptions options = MarkerOptions.newInstance();
        options.setIcon(maneuverMarker.getIcon_MarkerImage());
        Marker marker = Marker.newInstance((MarkerOptions)options);
        marker.setPosition(latLng);
        marker.setTitle(ManeuverTypeFormatter.format((ManeuverType)maneuver.getType(), (StringMessages)this.stringMessages));
        marker.setZindex(217);
        marker.addClickHandler(event -> {
            LatLng where = this.raceMap.getCoordinateSystem().toLatLng(maneuver.getPosition());
            Widget content = this.getInfoWindowContent(maneuver, competitor);
            this.raceMap.getManagedInfoWindow().openAtPosition(content, where);
        });
        Util.Triple key = this.createManeuverKey(maneuver, competitor);
        this.maneuverMarkers.put(key, marker);
        marker.setMap(this.raceMap.getMap());
        if (this.raceMap.getSettings().isShowManeuverLossVisualization() && maneuver.getManeuverLoss() != null) {
            this.createManeuverLossLinesAndInfoOverlays(maneuver, competitor);
        }
    }

    private Util.Triple<String, Date, ManeuverType> createManeuverKey(ManeuverDTO maneuver, CompetitorDTO competitor) {
        return new Util.Triple((Object)competitor.getIdAsString(), (Object)maneuver.getTimePoint(), (Object)maneuver.getType());
    }

    private void removeManeuverLossLinesAndInfoOverlayForManeuver(ManeuverDTO maneuver, CompetitorDTO competitor) {
        Util.Triple key = this.createManeuverKey(maneuver, competitor);
        this.removeManeuverLossLinesAndInfoOverlayForManeuver(key);
    }

    private void removeManeuverLossLinesAndInfoOverlayForManeuver(Util.Triple<String, Date, ManeuverType> key) {
        SmallTransparentInfoOverlay overlay;
        if (this.maneuverLossLinesMap.get(key) != null) {
            for (Polyline p : (Set)this.maneuverLossLinesMap.get(key)) {
                p.setMap(null);
            }
            this.maneuverLossLinesMap.remove(key);
        }
        if ((overlay = (SmallTransparentInfoOverlay)this.maneuverLossInfoOverlayMap.remove(key)) != null) {
            overlay.removeFromMap();
        }
    }

    private void createManeuverLossLinesAndInfoOverlays(ManeuverDTO maneuver, CompetitorDTO competitor) {
        String color;
        HashSet<Polyline> maneuverLossLines = new HashSet<Polyline>();
        Bearing bearingBefore = maneuver.getManeuverLoss().getSpeedWithBearingBefore().getBearing();
        DegreeBearingImpl middleManeuverAngle = new DegreeBearingImpl(maneuver.getManeuverLoss().getMiddleManeuverAngle().doubleValue());
        Distance extrapolationOfManeuverStartPoint = maneuver.getManeuverLoss().getSpeedWithBearingBefore().travel(maneuver.getManeuverLoss().getManeuverDuration());
        Position extrapolatedManeuverStartPosition = maneuver.getManeuverLoss().getManeuverStartPosition().translateRhumb(bearingBefore, extrapolationOfManeuverStartPoint);
        Position intersectionMiddleManeuverAngleWithExtrapolationOfManeuverStartPoint = maneuver.getManeuverLoss().getManeuverStartPosition().getIntersection(bearingBefore, maneuver.getPosition(), (Bearing)middleManeuverAngle);
        Position projectedExtrapolatedManeuverStartPosition = extrapolatedManeuverStartPosition.projectToLineThrough(intersectionMiddleManeuverAngleWithExtrapolationOfManeuverStartPoint, (Bearing)middleManeuverAngle);
        Position projectedManeuverEndPosition = maneuver.getManeuverLoss().getManeuverEndPosition().projectToLineThrough(intersectionMiddleManeuverAngleWithExtrapolationOfManeuverStartPoint, (Bearing)middleManeuverAngle);
        Position startOfBearingAtManeuverEndPositionLineOnMiddleManeuverAngleLine = maneuver.getManeuverLoss().getManeuverEndPosition().getIntersection((Bearing)new DegreeBearingImpl(maneuver.getSpeedWithBearingAfter().bearingInDegrees), intersectionMiddleManeuverAngleWithExtrapolationOfManeuverStartPoint, (Bearing)middleManeuverAngle);
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, startOfBearingAtManeuverEndPositionLineOnMiddleManeuverAngleLine, maneuver.getManeuverLoss().getManeuverEndPosition(), this.bearingAtManeuverEndPositionLineInfoProvider, MANEUVERLOSSLINES_EXTRAPOLATEDLINES_COLOR, 1, 0.5));
        color = maneuver.getManeuverLoss().getDistanceLost().compareTo((Object)Distance.NULL) > 0 ? (color = MANEUVERLOSSLINES_RED) : MANEUVERLOSSLINES_GREEN;
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, intersectionMiddleManeuverAngleWithExtrapolationOfManeuverStartPoint, projectedManeuverEndPosition, this.middleManeuverAngleLineInfoProvider, MANEUVERLOSSLINES_EXTRAPOLATEDLINES_COLOR, 1, 0.5));
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, maneuver.getManeuverLoss().getManeuverStartPosition(), extrapolatedManeuverStartPosition, this.extrapolatedLineInfoProvider, MANEUVERLOSSLINES_EXTRAPOLATEDLINES_COLOR, 1, 0.5));
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, extrapolatedManeuverStartPosition, projectedExtrapolatedManeuverStartPosition, this.projectedExtrapolatedLineInfoProvider, MANEUVERLOSSLINES_PROJECTEDLINES_COLOR, 1, 0.3));
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, maneuver.getManeuverLoss().getManeuverEndPosition(), projectedManeuverEndPosition, this.projectedManeuverEndLineInfoProvider, MANEUVERLOSSLINES_PROJECTEDLINES_COLOR, 1, 0.3));
        maneuverLossLines.add(this.raceMap.showOrRemoveOrUpdateLine(null, true, projectedExtrapolatedManeuverStartPosition, projectedManeuverEndPosition, this.maneuverLossLineInfoProvider, color, 2, 1.0));
        Util.Triple key = this.createManeuverKey(maneuver, competitor);
        this.maneuverLossLinesMap.put(key, maneuverLossLines);
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.stringMessages.maneuverLoss()) + ": " + numberFormatOneDecimal.format(maneuver.getManeuverLoss().getDistanceLost().getMeters()) + this.stringMessages.metersUnit() + '\n');
        if (maneuver.getType() == ManeuverType.TACK) {
            sb.append(String.valueOf(this.stringMessages.tackAngle()) + ": ");
        } else if (maneuver.getType() == ManeuverType.JIBE) {
            sb.append(String.valueOf(this.stringMessages.jibeAngle()) + ": ");
        } else {
            sb.append(String.valueOf(this.stringMessages.maneuverAngle()) + ": ");
        }
        sb.append(String.valueOf(numberFormatOneDecimal.format(Math.abs(maneuver.getDirectionChangeInDegrees()))) + this.stringMessages.degreesUnit());
        CssColor greyWithTransparency = CssColor.make((String)"rgba(255,255,255,0.5)");
        SmallTransparentInfoOverlay maneuverLossInfoOverlay = new SmallTransparentInfoOverlay(this.raceMap.getMap(), 216, sb.toString(), this.raceMap.getCoordinateSystem(), greyWithTransparency);
        maneuverLossInfoOverlay.setPosition(projectedManeuverEndPosition.translateGreatCircle((Bearing)middleManeuverAngle, maneuver.getManeuverLoss().getDistanceLost().scale(0.5)), -1L);
        maneuverLossInfoOverlay.draw();
        this.maneuverLossInfoOverlayMap.put(key, maneuverLossInfoOverlay);
    }

    Widget getInfoWindowContent(ManeuverDTO maneuver, CompetitorDTO competitor) {
        SpeedWithBearingDTO before = maneuver.getSpeedWithBearingBefore();
        SpeedWithBearingDTO after = maneuver.getSpeedWithBearingAfter();
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.maneuverType(), ManeuverTypeFormatter.format((ManeuverType)maneuver.getType(), (StringMessages)this.stringMessages)));
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.time(), DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_FULL).format(maneuver.getTimePoint())));
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.directionChange(), String.valueOf((int)Math.round(maneuver.getDirectionChangeInDegrees())) + " " + this.stringMessages.degreesShort() + " (" + (int)Math.round(before.bearingInDegrees) + " " + this.stringMessages.degreesShort() + " -> " + (int)Math.round(after.bearingInDegrees) + " " + this.stringMessages.degreesShort() + ")"));
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.speedChange(), String.valueOf(NumberFormat.getDecimalFormat().format(after.speedInKnots - before.speedInKnots)) + " " + this.stringMessages.knotsUnit() + " (" + NumberFormat.getDecimalFormat().format(before.speedInKnots) + " " + this.stringMessages.knotsUnit() + " -> " + NumberFormat.getDecimalFormat().format(after.speedInKnots) + " " + this.stringMessages.knotsUnit() + ")"));
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.maxTurningRate(), String.valueOf(NumberFormat.getDecimalFormat().format(maneuver.getMaxTurningRateInDegreesPerSecond())) + " " + this.stringMessages.degreesPerSecondUnit()));
        vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.avgTurningRate(), String.valueOf(NumberFormat.getDecimalFormat().format(maneuver.getAvgTurningRateInDegreesPerSecond())) + " " + this.stringMessages.degreesPerSecondUnit()));
        if (maneuver.getType() != ManeuverType.BEAR_AWAY && maneuver.getType() != ManeuverType.HEAD_UP) {
            vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.lowestSpeed(), String.valueOf(NumberFormat.getDecimalFormat().format(maneuver.getLowestSpeedInKnots())) + " " + this.stringMessages.knotsUnit()));
        }
        if (maneuver.getManeuverLoss() != null) {
            Widget maneuverLossWidget = this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.maneuverLoss(), String.valueOf(numberFormatOneDecimal.format(maneuver.getManeuverLoss().getDistanceLost().getMeters())) + " " + this.stringMessages.metersUnit());
            CheckBox maneuverLossLinesCheckBox = new CheckBox(this.stringMessages.show());
            Util.Triple t = this.createManeuverKey(maneuver, competitor);
            maneuverLossLinesCheckBox.setValue(Boolean.valueOf(this.maneuverLossLinesMap.containsKey(t)));
            maneuverLossLinesCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.add(maneuverLossWidget);
            hPanel.add((Widget)maneuverLossLinesCheckBox);
            vPanel.add((Widget)hPanel);
        }
        if (maneuver.getMarkPassingTimePoint() != null) {
            vPanel.add(this.raceMap.createInfoWindowLabelAndValue(this.stringMessages.markPassing(), String.valueOf(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_FULL).format(maneuver.getMarkPassingTimePoint())) + (maneuver.getMarkPassingSide() == null ? "" : " (" + NauticalSideFormatter.format((NauticalSide)maneuver.getMarkPassingSide(), (StringMessages)this.stringMessages) + ")")));
        }
        return vPanel;
    }

    public void updateManeuverMarkersAfterSettingsChanged() {
        if (this.lastManeuverResult != null) {
            this.removeAllManeuverMarkers();
            this.showManeuvers(this.lastManeuverResult);
        }
    }

    void clearAllManeuverMarkers() {
        this.removeAllManeuverMarkers();
        this.lastManeuverResult = null;
    }

    static /* synthetic */ StringMessages access$0(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators) {
        return maneuverMarkersAndLossIndicators.stringMessages;
    }

    static /* synthetic */ ErrorReporter access$1(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators) {
        return maneuverMarkersAndLossIndicators.errorReporter;
    }

    static /* synthetic */ void access$2(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators, Map map) {
        maneuverMarkersAndLossIndicators.lastManeuverResult = map;
    }

    static /* synthetic */ RaceMap access$3(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators) {
        return maneuverMarkersAndLossIndicators.raceMap;
    }

    static /* synthetic */ void access$4(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators, Map map) {
        maneuverMarkersAndLossIndicators.showManeuvers(map);
    }

    static /* synthetic */ void access$5(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators, ManeuverDTO maneuverDTO, CompetitorDTO competitorDTO) {
        maneuverMarkersAndLossIndicators.createManeuverLossLinesAndInfoOverlays(maneuverDTO, competitorDTO);
    }

    static /* synthetic */ void access$6(ManeuverMarkersAndLossIndicators maneuverMarkersAndLossIndicators, ManeuverDTO maneuverDTO, CompetitorDTO competitorDTO) {
        maneuverMarkersAndLossIndicators.removeManeuverLossLinesAndInfoOverlayForManeuver(maneuverDTO, competitorDTO);
    }
}

