/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.maps.client.base.Size;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;

public class ImageTransformer {
    private final Canvas canvas = Canvas.createIfSupported();
    private final int imageWidth;
    private final int imageHeight;
    private int canvasRadius;
    private int canvasWidth;
    private int canvasHeight;
    private double currentScale;
    private ImageElement imageElement;
    private Context2d context;

    public ImageTransformer(ImageResource imageResource) {
        this.imageWidth = imageResource.getWidth();
        this.imageHeight = imageResource.getHeight();
        this.scale(1.0);
        Image image = new Image(imageResource.getSafeUri().asString());
        this.imageElement = (ImageElement)image.getElement().cast();
        if (this.imageElement == null) {
            image.addLoadHandler((LoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void scale(double scaleFactor) {
        if (scaleFactor != this.currentScale) {
            this.canvasWidth = (int)Math.round((double)this.imageWidth * scaleFactor);
            this.canvasHeight = (int)Math.round((double)this.imageHeight * scaleFactor);
            this.canvasRadius = (int)Math.sqrt(this.canvasWidth * this.canvasWidth / 4 + this.canvasHeight * this.canvasHeight / 4);
            GWT.log((String)("canvas radius: " + this.canvasRadius + "(h:" + this.canvasHeight + "/w:" + this.canvasWidth + ")"));
            this.canvas.setSize(2 * this.canvasRadius + "px", 2 * this.canvasRadius + "px");
            this.canvas.setCoordinateSpaceWidth(2 * this.canvasRadius);
            this.canvas.setCoordinateSpaceHeight(2 * this.canvasRadius);
            this.context = this.canvas.getContext2d();
            this.currentScale = scaleFactor;
        }
    }

    public int getRadius() {
        return this.canvasRadius;
    }

    public Size getImageSize() {
        return Size.newInstance((double)this.imageWidth, (double)this.imageHeight);
    }

    public ImageData getTransformedImageData(double angleInDegrees, double scaleFactor) {
        ImageData result = null;
        if (this.canvas != null && this.imageElement != null) {
            this.drawTransformedImage(angleInDegrees, scaleFactor);
            result = this.context.getImageData(0.0, 0.0, (double)(2 * this.canvasRadius), (double)(2 * this.canvasRadius));
        }
        return result;
    }

    public void drawTransformedImage(double angleInDegrees, double scaleFactor) {
        if (this.canvas != null && this.imageElement != null) {
            if (scaleFactor != 1.0) {
                this.scale(scaleFactor);
            }
            double angleInRadians = angleInDegrees / 180.0 * Math.PI;
            this.context.clearRect(0.0, 0.0, (double)(2 * this.canvasRadius), (double)(2 * this.canvasRadius));
            this.context.save();
            this.context.translate((double)this.canvasRadius, (double)this.canvasRadius);
            this.context.rotate(angleInRadians);
            this.context.scale(scaleFactor, scaleFactor);
            this.context.drawImage(this.imageElement, (double)(-this.imageWidth / 2), (double)(-this.imageHeight / 2));
            this.context.restore();
        }
    }

    public void drawToCanvas(Canvas canvas, double angleInDegrees, double scaleFactor) {
        this.drawToCanvas(canvas, angleInDegrees, scaleFactor, null);
    }

    public void drawToCanvas(Canvas canvas, double angleInDegrees, double scaleFactor, Double globalAlpha) {
        if (this.imageElement != null) {
            int canvasWidth = (int)Math.round((double)this.imageWidth * scaleFactor);
            int canvasHeight = (int)Math.round((double)this.imageHeight * scaleFactor);
            int canvasRadius = (int)Math.sqrt(canvasWidth * canvasWidth / 4 + canvasHeight * canvasHeight / 4);
            canvas.setSize(2 * canvasRadius + "px", 2 * canvasRadius + "px");
            canvas.setCoordinateSpaceWidth(2 * canvasRadius);
            canvas.setCoordinateSpaceHeight(2 * canvasRadius);
            Context2d context = canvas.getContext2d();
            double angleInRadians = angleInDegrees / 180.0 * Math.PI;
            context.clearRect(0.0, 0.0, (double)(2 * canvasRadius), (double)(2 * canvasRadius));
            context.save();
            context.translate((double)canvasRadius, (double)canvasRadius);
            context.rotate(angleInRadians);
            context.scale(scaleFactor, scaleFactor);
            if (globalAlpha != null) {
                context.setGlobalAlpha(globalAlpha.doubleValue());
            }
            context.drawImage(this.imageElement, (double)(-this.imageWidth / 2), (double)(-this.imageHeight / 2));
            context.restore();
        }
    }

    static /* synthetic */ void access$0(ImageTransformer imageTransformer, ImageElement imageElement) {
        imageTransformer.imageElement = imageElement;
    }
}

