/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.maps.client.base.Size;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;

public class ImageCanvas {
    private final Canvas canvas = Canvas.createIfSupported();
    private final int imageWidth;
    private final int imageHeight;
    private int canvasRadius;
    private int canvasWidth;
    private int canvasHeight;
    private double currentScale;
    private ImageElement imageElement;
    private Context2d context;

    public ImageCanvas(ImageResource imageResource) {
        this.imageWidth = imageResource.getWidth();
        this.imageHeight = imageResource.getHeight();
        this.scale(1.0);
        Image image = new Image(imageResource.getSafeUri().asString());
        this.imageElement = (ImageElement)image.getElement().cast();
        if (this.imageElement == null) {
            image.addLoadHandler((LoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean isImageLoaded() {
        return this.imageElement != null;
    }

    private boolean isValid() {
        return this.imageElement != null && this.canvas != null;
    }

    private void scale(double scaleFactor) {
        if (scaleFactor != this.currentScale) {
            this.canvasWidth = (int)Math.round((double)this.imageWidth * scaleFactor);
            this.canvasHeight = (int)Math.round((double)this.imageHeight * scaleFactor);
            this.canvasRadius = (int)Math.sqrt(this.canvasWidth * this.canvasWidth / 4 + this.canvasHeight * this.canvasHeight / 4);
            this.canvas.setSize(2 * this.canvasRadius + "px", 2 * this.canvasRadius + "px");
            this.canvas.setCoordinateSpaceWidth(2 * this.canvasRadius);
            this.canvas.setCoordinateSpaceHeight(2 * this.canvasRadius);
            this.context = this.canvas.getContext2d();
            this.currentScale = scaleFactor;
        }
    }

    public int getRadius() {
        return this.canvasRadius;
    }

    public Size getImageSize() {
        return Size.newInstance((double)this.imageWidth, (double)this.imageHeight);
    }

    public ImageData getImageData() {
        ImageData result = null;
        if (this.isValid()) {
            result = this.context.getImageData(0.0, 0.0, (double)(2 * this.canvasRadius), (double)(2 * this.canvasRadius));
        }
        return result;
    }

    public void drawImage() {
        if (this.isValid()) {
            this.context.clearRect(0.0, 0.0, (double)(2 * this.canvasRadius), (double)(2 * this.canvasRadius));
            this.context.drawImage(this.imageElement, 0.0, 0.0);
        }
    }

    public void rotateAndScaleImage(double angleInDegrees, double scaleFactor) {
        if (this.isValid()) {
            if (scaleFactor != 1.0) {
                this.scale(scaleFactor);
            }
            double angleInRadians = angleInDegrees / 180.0 * Math.PI;
            this.context.clearRect(0.0, 0.0, (double)(2 * this.canvasRadius), (double)(2 * this.canvasRadius));
            this.context.save();
            this.context.translate((double)this.canvasRadius, (double)this.canvasRadius);
            this.context.rotate(angleInRadians);
            this.context.scale(scaleFactor, scaleFactor);
            this.context.drawImage(this.imageElement, (double)(-this.imageWidth / 2), (double)(-this.imageHeight / 2));
            this.context.restore();
        }
    }

    static /* synthetic */ void access$0(ImageCanvas imageCanvas, ImageElement imageElement) {
        imageCanvas.imageElement = imageElement;
    }
}

