/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sailing.gwt.ui.shared.racemap.MarkVectorGraphics;
import com.sap.sailing.gwt.ui.shared.racemap.MarkVectorGraphicsFactory;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public class CourseMarkOverlay
extends CanvasOverlayV3 {
    private final MarkDTO mark;
    private CoursePositionsDTO coursePositionsDTO;
    private Position position;
    private Distance buoyZoneRadius;
    private boolean showBuoyZone;
    private final int MIN_BUOYZONE_RADIUS_IN_PX = 25;
    private final MarkVectorGraphics markVectorGraphics;
    private Map<Double, Util.Pair<Double, Size>> markScaleAndSizePerZoomCache;
    private Double lastWidth;
    private Double lastHeight;
    private Double lastScaleFactor;
    private Boolean lastShowBuoyZone;
    private Boolean lastIsSelected;
    private Distance lastBuoyZoneRadius;
    private MarkVectorGraphicsFactory markVectorGraphicsFactory;

    public CourseMarkOverlay(MapWidget map, int zIndex, MarkDTO markDTO, CoordinateSystem coordinateSystem, CoursePositionsDTO coursePositionsDTO) {
        super(map, zIndex, coordinateSystem);
        this.mark = markDTO;
        this.coursePositionsDTO = coursePositionsDTO;
        this.position = markDTO.position;
        this.buoyZoneRadius = new MeterDistance(0.0);
        this.showBuoyZone = false;
        this.markScaleAndSizePerZoomCache = new HashMap();
        this.markVectorGraphicsFactory = new MarkVectorGraphicsFactory();
        this.markVectorGraphics = this.markVectorGraphicsFactory.getMarkVectorGraphics(markDTO);
        this.setCanvasSize(50, 50);
    }

    protected void draw() {
        if (this.getMapProjection() != null && this.mark != null && this.position != null) {
            Bearing rotation;
            double zoom = this.map.getZoom();
            Util.Pair markScaleAndSize = (Util.Pair)this.markScaleAndSizePerZoomCache.get(zoom);
            if (markScaleAndSize == null) {
                markScaleAndSize = this.getMarkScaleAndSize(this.position);
                this.markScaleAndSizePerZoomCache.put(zoom, markScaleAndSize);
            }
            double markSizeScaleFactor = (Double)markScaleAndSize.getA();
            this.getCanvas().setTitle(this.getTitle());
            double canvasWidth = ((Size)markScaleAndSize.getB()).getWidth();
            double canvasHeight = ((Size)markScaleAndSize.getB()).getHeight();
            double buoyZoneRadiusInPixel = -1.0;
            if (this.showBuoyZone && this.isMarkWithBuoyZone(this.mark) && (buoyZoneRadiusInPixel = this.calculateRadiusOfBoundingBoxInPixels(this.getMapProjection(), this.position, this.buoyZoneRadius)) > 25.0) {
                canvasWidth = (buoyZoneRadiusInPixel + 1.0) * 2.0;
                canvasHeight = (buoyZoneRadiusInPixel + 1.0) * 2.0;
            }
            if (this.needToDraw(this.showBuoyZone, this.isSelected, this.buoyZoneRadius, canvasWidth, canvasHeight, markSizeScaleFactor)) {
                this.setCanvasSize((int)canvasWidth, (int)canvasHeight);
                Context2d context2d = this.getCanvas().getContext2d();
                this.markVectorGraphics.drawMarkToCanvas(context2d, this.isSelected, canvasWidth, canvasHeight, markSizeScaleFactor);
                if (this.showBuoyZone && this.isMarkWithBuoyZone(this.mark) && buoyZoneRadiusInPixel > 25.0) {
                    CssColor grayTransparentColor = CssColor.make((String)"rgba(37,158,255,0.75)");
                    context2d.setStrokeStyle((FillStrokeStyle)grayTransparentColor);
                    context2d.setLineWidth(1.0);
                    context2d.beginPath();
                    context2d.arc(buoyZoneRadiusInPixel + 1.0, buoyZoneRadiusInPixel + 1.0, buoyZoneRadiusInPixel, 0.0, Math.PI * 2, true);
                    context2d.closePath();
                    context2d.stroke();
                }
                this.lastBuoyZoneRadius = this.buoyZoneRadius;
                this.lastScaleFactor = markSizeScaleFactor;
                this.lastShowBuoyZone = this.showBuoyZone;
                this.lastIsSelected = this.isSelected;
                this.lastWidth = canvasWidth;
                this.lastHeight = canvasHeight;
            }
            if ((rotation = this.markVectorGraphics.getRotationInDegrees(this.coursePositionsDTO)) != null) {
                this.updateDrawingAngleAndSetCanvasRotation(this.coordinateSystem.mapDegreeBearing(rotation.getDegrees()));
            }
            Point buoyPositionInPx = this.getMapProjection().fromLatLngToDivPixel(this.coordinateSystem.toLatLng(this.position));
            if (this.showBuoyZone && this.isMarkWithBuoyZone(this.mark) && buoyZoneRadiusInPixel > 25.0) {
                this.setCanvasPosition(buoyPositionInPx.getX() - buoyZoneRadiusInPixel, buoyPositionInPx.getY() - buoyZoneRadiusInPixel);
            } else {
                this.setCanvasPosition(buoyPositionInPx.getX() - canvasWidth / 2.0, buoyPositionInPx.getY() - canvasHeight / 2.0);
            }
        }
    }

    private boolean isMarkWithBuoyZone(MarkDTO mark) {
        return mark.type == null || mark.type == MarkType.BUOY || mark.type == MarkType.STARTBOAT || mark.type == MarkType.FINISHBOAT || mark.type == MarkType.LANDMARK;
    }

    private boolean needToDraw(boolean showBuoyZone, boolean isSelected, Distance buoyZoneRadius, double width, double height, double scaleFactor) {
        return this.lastShowBuoyZone == null || this.lastShowBuoyZone != showBuoyZone || this.lastIsSelected == null || this.lastIsSelected != isSelected || this.lastBuoyZoneRadius == null || !this.lastBuoyZoneRadius.equals(buoyZoneRadius) || this.lastScaleFactor == null || this.lastScaleFactor != scaleFactor || this.lastWidth == null || this.lastWidth != width || this.lastHeight == null || this.lastHeight != height;
    }

    public Util.Pair<Double, Size> getMarkScaleAndSize(Position markPosition) {
        double minMarkHeight = 20.0;
        double buoyScaleFactor = 2.0;
        Size markSizeInPixel = this.calculateBoundingBox(this.getMapProjection(), markPosition, this.markVectorGraphics.getMarkWidth().scale(buoyScaleFactor), this.markVectorGraphics.getMarkHeight().scale(buoyScaleFactor));
        double markHeightInPixel = markSizeInPixel.getHeight();
        if (markHeightInPixel < minMarkHeight) {
            markHeightInPixel = minMarkHeight;
        }
        double markSizeScaleFactor = markHeightInPixel / this.markVectorGraphics.getMarkHeight().scale(100.0).getMeters();
        return new Util.Pair((Object)markSizeScaleFactor, (Object)Size.newInstance((double)(markHeightInPixel * 2.0), (double)(markHeightInPixel * 2.0)));
    }

    private String getTitle() {
        return this.mark.getName();
    }

    public boolean isShowBuoyZone() {
        return this.showBuoyZone;
    }

    public void setShowBuoyZone(boolean showBuoyZone) {
        this.showBuoyZone = showBuoyZone;
    }

    public void setCourse(CoursePositionsDTO coursePositionsDTO) {
        this.coursePositionsDTO = coursePositionsDTO;
    }

    public MarkDTO getMark() {
        return this.mark;
    }

    public void setMarkPosition(Position position, long transitionTimeInMillis) {
        this.updateTransition(transitionTimeInMillis);
        this.position = position;
    }

    public void setMarkPosition(LatLng positionLatLng) {
        this.position = this.coordinateSystem.getPosition(positionLatLng);
        this.draw();
    }

    public Position getPosition() {
        return this.position;
    }

    public LatLng getMarkLatLngPosition() {
        return this.coordinateSystem.toLatLng(this.position);
    }

    public Distance getBuoyZoneRadius() {
        return this.buoyZoneRadius;
    }

    public void setBuoyZoneRadius(Distance buoyZoneRadius) {
        this.buoyZoneRadius = buoyZoneRadius;
    }
}

