/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnAddHandler;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;

public class CourseAreaCircleOverlay
extends CanvasOverlayV3 {
    private static final double DEFAULT_COURSE_AREA_CIRCLE_LINE_WIDTH = 3.0;
    private static final CssColor DEFAULT_COURSE_AREA_CIRCLE_COLOR = CssColor.make((String)"rgba(37,158,255,0.75)");
    private static final int CENTER_CROSS_SIZE_IN_PIXELS = 10;
    private final CourseAreaDTO courseArea;
    private final StringMessages stringMessages;

    public CourseAreaCircleOverlay(MapWidget map, int zIndex, CourseAreaDTO courseArea, CoordinateSystem coordinateSystem, StringMessages stringMessages) {
        super(map, zIndex, coordinateSystem);
        this.courseArea = courseArea;
        this.stringMessages = stringMessages;
        this.setCanvasSize(50, 50);
    }

    protected void draw() {
        if (this.getMapProjection() != null && this.courseArea != null && this.getPosition() != null && this.courseArea.getRadius() != null) {
            this.getCanvas().setTitle(this.getTitle());
            double courseAreaRadiusInPixel = this.calculateRadiusOfBoundingBoxInPixels(this.getMapProjection(), this.courseArea.getCenterPosition(), this.courseArea.getRadius());
            int canvasEdgeLength = 2 * (int)courseAreaRadiusInPixel + 3;
            if (canvasEdgeLength >= 8192 || canvasEdgeLength * canvasEdgeLength > 0x4000000) {
                GWT.log((String)("Course area circle canvas for " + this.courseArea.getName() + " would get too large (" + canvasEdgeLength + "x" + canvasEdgeLength + ", area " + canvasEdgeLength * canvasEdgeLength + ". Not drawing."));
                this.setCanvasSize(0, 0);
            } else {
                this.setCanvasSize(2 * (int)courseAreaRadiusInPixel + 3, 2 * (int)courseAreaRadiusInPixel + 3);
                Context2d context2d = this.getCanvas().getContext2d();
                context2d.setStrokeStyle((FillStrokeStyle)DEFAULT_COURSE_AREA_CIRCLE_COLOR);
                context2d.setFillStyle((FillStrokeStyle)DEFAULT_COURSE_AREA_CIRCLE_COLOR);
                context2d.setLineWidth(3.0);
                context2d.beginPath();
                context2d.arc(courseAreaRadiusInPixel + 1.0, courseAreaRadiusInPixel + 1.0, courseAreaRadiusInPixel, 0.0, Math.PI * 2, true);
                context2d.closePath();
                context2d.stroke();
                context2d.setLineWidth(1.0);
                context2d.moveTo(courseAreaRadiusInPixel + 1.0 - 5.0, courseAreaRadiusInPixel + 1.0);
                context2d.lineTo(courseAreaRadiusInPixel + 1.0 + 5.0, courseAreaRadiusInPixel + 1.0);
                context2d.moveTo(courseAreaRadiusInPixel + 1.0, courseAreaRadiusInPixel + 1.0 - 5.0);
                context2d.lineTo(courseAreaRadiusInPixel + 1.0, courseAreaRadiusInPixel + 1.0 + 5.0);
                context2d.stroke();
                context2d.setTextAlign(Context2d.TextAlign.CENTER);
                context2d.setFont("16px arial");
                context2d.fillText(this.courseArea.getName(), courseAreaRadiusInPixel + 1.0, courseAreaRadiusInPixel + 1.0 + 20.0);
                Point courseAreaPositionInPx = this.getMapProjection().fromLatLngToDivPixel(this.coordinateSystem.toLatLng(this.getPosition()));
                this.setCanvasPosition(courseAreaPositionInPx.getX() - courseAreaRadiusInPixel, courseAreaPositionInPx.getY() - courseAreaRadiusInPixel);
            }
        }
    }

    protected OverlayViewOnAddHandler getOnAddHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getTitle() {
        return String.valueOf(this.stringMessages.courseArea()) + ": " + this.courseArea.getName();
    }

    public CourseAreaDTO getCourseArea() {
        return this.courseArea;
    }

    public Position getPosition() {
        return this.getCourseArea().getCenterPosition();
    }

    public LatLng getMarkLatLngPosition() {
        return this.coordinateSystem.toLatLng(this.getPosition());
    }

    static /* synthetic */ Canvas access$0(CourseAreaCircleOverlay courseAreaCircleOverlay) {
        return courseAreaCircleOverlay.canvas;
    }

    static /* synthetic */ void access$1(CourseAreaCircleOverlay courseAreaCircleOverlay) {
        courseAreaCircleOverlay.onAttach();
    }
}

