/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.overlays.Polyline;
import com.google.gwt.maps.client.overlays.PolylineOptions;
import com.sap.sailing.gwt.ui.client.shared.racemap.ColorlineColorProvider;
import com.sap.sailing.gwt.ui.client.shared.racemap.ColorlineMode;

public class ColorlineOptions {
    private ColorlineMode colorMode = ColorlineMode.MONOCHROMATIC;
    private boolean clickable = true;
    private boolean draggable = false;
    private boolean editable = false;
    private boolean geodesic = true;
    private boolean visible = true;
    private int strokeWeight = 1;
    private double strokeOpacity = 1.0;
    private int zIndex = 0;
    private ColorlineColorProvider colorProvider;

    public ColorlineOptions() {
    }

    public ColorlineOptions(ColorlineColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public ColorlineOptions(PolylineOptions options, ColorlineColorProvider colorProvider) {
        this.clickable = options.getClickable();
        this.geodesic = options.getGeodesic();
        this.visible = options.getVisible();
        this.strokeWeight = options.getStrokeWeight();
        this.strokeOpacity = options.getStrokeOpacity();
        this.zIndex = options.getZindex();
        this.colorProvider = colorProvider;
    }

    public ColorlineOptions(ColorlineOptions options) {
        this.colorMode = options.getColorMode();
        this.colorProvider = options.getColorProvider();
        this.clickable = options.getClickable();
        this.draggable = options.getDraggable();
        this.editable = options.getEditable();
        this.geodesic = options.getGeodesic();
        this.visible = options.getVisible();
        this.strokeWeight = options.getStrokeWeight();
        this.strokeOpacity = options.getStrokeOpacity();
        this.zIndex = options.getZIndex();
    }

    public Polyline newPolylineInstance(int fixIndexInTail) {
        if (this.colorProvider == null) {
            throw new IllegalStateException("A ColorProvider must be set prior to creating new Polylines.");
        }
        return this.newPolylineInstance(this.colorProvider.getColor(fixIndexInTail));
    }

    public Polyline newPolylineInstance(String strokeColor) {
        Polyline line = Polyline.newInstance((PolylineOptions)this.newPolylineOptionsInstance(strokeColor));
        line.setEditable(this.editable);
        return line;
    }

    public PolylineOptions newPolylineOptionsInstance(String strokeColor) {
        PolylineOptions opt = PolylineOptions.newInstance();
        opt.setStrokeColor(strokeColor);
        opt.setClickable(this.clickable);
        opt.setGeodesic(this.geodesic);
        opt.setVisible(this.visible);
        opt.setStrokeWeight(this.strokeWeight);
        opt.setStrokeOpacity(this.strokeOpacity);
        opt.setZindex(this.zIndex);
        return opt;
    }

    public ColorlineMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(ColorlineMode colorMode) {
        this.colorMode = colorMode;
    }

    public ColorlineColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public void setColorProvider(ColorlineColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public boolean getClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean getDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean getGeodesic() {
        return this.geodesic;
    }

    public void setGeodesic(boolean geodesic) {
        this.geodesic = geodesic;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    public int getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setStrokeWeight(int strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    public double getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(double strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
    }
}

