/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.mvc.MVCArray;
import com.google.gwt.maps.client.overlays.Polyline;
import com.google.gwt.user.client.Timer;

public class AdvantageLineAnimator
extends Timer {
    private static final int ANIMATION_PERIOD_MILLIS = 100;
    private final Polyline advantageLine;
    private long lastTime;
    private long durationMillis = -1L;
    private MVCArray<LatLng> nextPosition;

    public AdvantageLineAnimator(Polyline advantageLine) {
        if (advantageLine == null) {
            throw new NullPointerException("Advantage line must not be null");
        }
        this.advantageLine = advantageLine;
    }

    public void setNextPositionAndTransitionMillis(MVCArray<LatLng> nextPosition, long timeForPositionTransitionMillis) {
        if (nextPosition.getLength() != this.advantageLine.getPath().getLength()) {
            throw new IllegalArgumentException("The next animation position for a polyline with " + this.advantageLine.getPath().getLength() + " elements must have the same number of positions but did have " + nextPosition.getLength());
        }
        this.nextPosition = nextPosition;
        this.lastTime = System.currentTimeMillis();
        this.durationMillis = timeForPositionTransitionMillis;
        this.scheduleRepeating(100);
    }

    public void run() {
        double moveFactor;
        long time = System.currentTimeMillis();
        if (this.durationMillis > 0L) {
            long deltaTime = time - this.lastTime;
            moveFactor = Math.min(1.0, (double)deltaTime / (double)this.durationMillis);
            this.durationMillis -= deltaTime;
        } else {
            moveFactor = 1.0;
        }
        if (this.nextPosition != null) {
            MVCArray currentPosition = this.advantageLine.getPath();
            int i = 0;
            while (i < this.nextPosition.getLength()) {
                LatLng currentLatLng = (LatLng)currentPosition.get(i);
                LatLng nextLatLng = (LatLng)this.nextPosition.get(i);
                currentPosition.setAt(i, (JavaScriptObject)LatLng.newInstance((double)(currentLatLng.getLatitude() + (nextLatLng.getLatitude() - currentLatLng.getLatitude()) * moveFactor), (double)(currentLatLng.getLongitude() + (nextLatLng.getLongitude() - currentLatLng.getLongitude()) * moveFactor)));
                ++i;
            }
        }
        if (this.durationMillis <= 0L) {
            this.cancel();
        }
        this.lastTime = time;
    }

    public void removeAnimation() {
        this.durationMillis = -1L;
    }
}

