/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.shared.filter.AbstractCompetitorNumberFilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorTotalRankFilter;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sse.common.filter.BinaryOperator;
import com.sap.sse.common.filter.FilterOperator;
import com.sap.sse.common.filter.NumberFilter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class CompetitorTotalRankFilterUIFactory
extends AbstractCompetitorNumberFilterUIFactory<Integer> {
    private IntegerBox valueIntegerBox;
    private ListBox operatorSelectionListBox;

    public CompetitorTotalRankFilterUIFactory() {
        this(new CompetitorTotalRankFilter());
    }

    public CompetitorTotalRankFilterUIFactory(CompetitorTotalRankFilter competitorTotalRankFilter) {
        super((NumberFilter)competitorTotalRankFilter, BinaryOperator.Operators.LessThanEquals);
        this.supportedOperators.add(BinaryOperator.Operators.LessThanEquals);
        this.supportedOperators.add(BinaryOperator.Operators.GreaterThanEquals);
        this.supportedOperators.add(BinaryOperator.Operators.LessThan);
        this.supportedOperators.add(BinaryOperator.Operators.GreaterThan);
        this.supportedOperators.add(BinaryOperator.Operators.NotEqualTo);
        this.supportedOperators.add(BinaryOperator.Operators.Equals);
        this.valueIntegerBox = null;
        this.operatorSelectionListBox = null;
    }

    public Widget createFilterUIWidget(DataEntryDialog<?> dataEntryDialog) {
        Grid hpGrid = new Grid(1, 2);
        hpGrid.setWidget(0, 0, this.createOperatorSelectionWidget(dataEntryDialog));
        hpGrid.setWidget(0, 1, this.createValueInputWidget(dataEntryDialog));
        hpGrid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        hpGrid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
        return hpGrid;
    }

    private Widget createValueInputWidget(DataEntryDialog<?> dataEntryDialog) {
        if (this.valueIntegerBox == null) {
            this.valueIntegerBox = dataEntryDialog.createIntegerBox((Integer)this.competitorNumberFilter.getValue(), 20);
            this.valueIntegerBox.setFocus(true);
        }
        return this.valueIntegerBox;
    }

    private Widget createOperatorSelectionWidget(DataEntryDialog<?> dataEntryDialog) {
        if (this.operatorSelectionListBox == null) {
            this.operatorSelectionListBox = this.createOperatorSelectionListBox(dataEntryDialog);
        }
        return this.operatorSelectionListBox;
    }

    public FilterWithUI<CompetitorDTO> createFilterFromUI() {
        CompetitorTotalRankFilter result = null;
        if (this.valueIntegerBox != null && this.operatorSelectionListBox != null) {
            result = new CompetitorTotalRankFilter();
            BinaryOperator.Operators op = BinaryOperator.Operators.valueOf((String)this.operatorSelectionListBox.getValue(this.operatorSelectionListBox.getSelectedIndex()));
            BinaryOperator binaryOperator = new BinaryOperator(op);
            Integer value = (Integer)this.valueIntegerBox.getValue();
            result.setOperator((FilterOperator)binaryOperator);
            result.setValue((Number)value);
        }
        return result;
    }
}

