/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.ColorMapImpl;
import com.sap.sailing.gwt.ui.actions.GetWindInfoAction;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.WindSourceTypeFormatter;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractRaceChart;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartPointRecalculator;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartUtil;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartSettings;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.BaseChart;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.ChartSubtitle;
import org.moxieapps.gwt.highcharts.client.ChartTitle;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.ToolTipFormatter;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.events.ChartClickEventHandler;
import org.moxieapps.gwt.highcharts.client.events.ChartSelectionEventHandler;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsFormatter;
import org.moxieapps.gwt.highcharts.client.labels.XAxisLabels;
import org.moxieapps.gwt.highcharts.client.labels.YAxisLabels;
import org.moxieapps.gwt.highcharts.client.plotOptions.LinePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;

public class WindChart
extends AbstractRaceChart<WindChartSettings>
implements RequiresResize {
    public static final String LOAD_WIND_CHART_DATA_CATEGORY = "loadWindChartData";
    private static final int LINE_WIDTH = 1;
    private final WindChartSettings settings;
    private final WindChartLifecycle windChartLifecycle;
    private final Map<WindSource, Series> windSourceDirectionSeries;
    private final Map<WindSource, Series> windSourceSpeedSeries;
    private final Map<WindSource, Point[]> windSourceDirectionPoints;
    private final Map<WindSource, Point[]> windSourceSpeedPoints;
    private Point firstPointOfFirstSeries;
    private Long timeOfEarliestRequestInMillis;
    private Long timeOfLatestRequestInMillis;
    private final ColorMapImpl<WindSource> colorMap;
    private WindSource preselectFilter;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;

    public WindChart(Component<?> parent, ComponentContext<?> context, WindChartLifecycle windChartLifecycle, SailingServiceAsync sailingService, RegattaAndRaceIdentifier selectedRaceIdentifier, Timer timer, TimeRangeWithZoomProvider timeRangeWithZoomProvider, WindChartSettings settings, StringMessages stringMessages, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter, boolean compactChart) {
        super(parent, context, sailingService, selectedRaceIdentifier, timer, timeRangeWithZoomProvider, stringMessages, asyncActionsExecutor, errorReporter);
        this.windChartLifecycle = windChartLifecycle;
        this.settings = settings;
        this.windSourceDirectionSeries = new HashMap();
        this.windSourceSpeedSeries = new HashMap();
        this.windSourceDirectionPoints = new HashMap();
        this.windSourceSpeedPoints = new HashMap();
        this.firstPointOfFirstSeries = null;
        this.colorMap = new ColorMapImpl(new Color[0]);
        this.chart = (Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)new Chart().setPersistent(true)).setReflow(false)).setZoomType(BaseChart.ZoomType.X)).setMarginLeft((Number)65)).setMarginRight((Number)65)).setWidth100()).setHeight100()).setBorderColor(new org.moxieapps.gwt.highcharts.client.Color("#CACACA"))).setBorderWidth((Number)0)).setBorderRadius((Number)0)).setBackgroundColor(new org.moxieapps.gwt.highcharts.client.Color("#FFFFFF"))).setPlotBackgroundColor("#f8f8f8")).setPlotBorderWidth((Number)0)).setAlignTicks(false)).setCredits(new Credits().setEnabled(false))).setChartTitle((ChartTitle)new ChartTitle().setText(stringMessages.wind()).setOption("floating", (Object)true))).setChartSubtitle(new ChartSubtitle().setText(stringMessages.clickAndDragToZoomIn()))).setLinePlotOptions((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)new LinePlotOptions().setLineWidth((Number)1)).setMarker(new Marker().setEnabled(false).setHoverState(new Marker().setEnabled(true).setRadius((Number)4)))).setShadow(false)).setHoverStateLineWidth((Number)1));
        this.chart.setStyleName(chartsCss.chartStyle());
        ChartUtil.useCheckboxesToShowAndHide((Chart)this.chart);
        NumberFormat numberFormat = NumberFormat.getFormat((String)"0");
        this.chart.setToolTip(new ToolTip().setEnabled(true).setFormatter((ToolTipFormatter)new /* Unavailable Anonymous Inner Class!! */));
        this.chart.setClickEventHandler((ChartClickEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.setSelectionEventHandler((ChartSelectionEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        ((XAxis)((XAxis)this.chart.getXAxis().setType(Axis.Type.DATE_TIME)).setMaxZoom((Number)60000)).setAxisTitleText(stringMessages.time());
        this.chart.getXAxis().setLabels(new XAxisLabels().setFormatter((AxisLabelsFormatter)new /* Unavailable Anonymous Inner Class!! */));
        this.timePlotLine = this.chart.getXAxis().createPlotLine().setColor("#656565").setWidth((Number)1.5).setDashStyle(PlotLine.DashStyle.SOLID);
        ((YAxis)((YAxis)this.chart.getYAxis(0).setAxisTitleText(stringMessages.fromDeg())).setStartOnTick(false)).setLabels(new YAxisLabels().setFormatter((AxisLabelsFormatter)new /* Unavailable Anonymous Inner Class!! */));
        ((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)this.chart.getYAxis(1).setOpposite(true)).setAxisTitleText(String.valueOf(stringMessages.speed()) + " (" + stringMessages.knotsUnit() + ")")).setMin((Number)0)).setMaxPadding((Number)0.05)).setStartOnTick(false)).setGridLineWidth((Number)0)).setMinorGridLineWidth((Number)0);
        if (compactChart) {
            ((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)this.chart.setSpacingBottom((Number)10)).setSpacingLeft((Number)10)).setSpacingRight((Number)10)).setSpacingTop((Number)20)).setOption("legend/margin", (Object)2)).setOption("title/margin", (Object)5)).setChartSubtitle(null)).getXAxis().setAxisTitle(null);
        }
        this.setSize("100%", "100%");
        if (selectedRaceIdentifier != null) {
            this.clearCacheAndReload();
            if (this.isVisible()) {
                this.updateVisibleSeries();
            }
        } else {
            this.clearChart();
        }
    }

    protected Button createSettingsButton() {
        Button settingsButton = SettingsDialog.createSettingsButton((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        return settingsButton;
    }

    public String getLocalizedShortName() {
        return this.windChartLifecycle.getLocalizedShortName();
    }

    public Widget getEntryWidget() {
        return this;
    }

    private void updateVisibleSeries() {
        HashSet<Series> visibleSeries = new HashSet<Series>(Arrays.asList(this.chart.getSeries()));
        if (this.preselectFilter != null) {
            this.forceSeriesSelection(visibleSeries, this.windSourceDirectionSeries);
            this.forceSeriesSelection(visibleSeries, this.windSourceSpeedSeries);
        } else {
            boolean showDirectionSeries = this.settings.isShowWindDirectionsSeries();
            Set directionSourceTypesToDisplay = this.settings.getWindDirectionSourcesToDisplay();
            this.updateSeries(visibleSeries, this.windSourceDirectionSeries, showDirectionSeries, directionSourceTypesToDisplay);
            boolean showSpeedSeries = this.settings.isShowWindSpeedSeries();
            Set speedSourceTypesToDisplay = this.settings.getWindSpeedSourcesToDisplay();
            this.updateSeries(visibleSeries, this.windSourceSpeedSeries, showSpeedSeries, speedSourceTypesToDisplay);
        }
        this.onResize();
    }

    private void updateSeries(Set<Series> visibleSeries, Map<WindSource, Series> windSourceToSeriesMap, boolean showSeries, Set<WindSourceType> windSourceTypesToDisplay) {
        if (showSeries) {
            for (Map.Entry<WindSource, Series> entry : windSourceToSeriesMap.entrySet()) {
                Series series = entry.getValue();
                if (windSourceTypesToDisplay.contains(entry.getKey().getType())) {
                    if (visibleSeries.contains(series)) continue;
                    this.chart.addSeries(series, false, false);
                    continue;
                }
                if (!visibleSeries.contains(series)) continue;
                this.chart.removeSeries(series, false);
            }
        } else {
            for (Map.Entry<WindSource, Series> entry : windSourceToSeriesMap.entrySet()) {
                Series series = entry.getValue();
                if (!visibleSeries.contains(series)) continue;
                this.chart.removeSeries(series, false);
            }
        }
    }

    private boolean forceSeriesSelection(Set<Series> visibleSeries, Map<WindSource, Series> toProcess) {
        boolean wasInResult = false;
        for (Map.Entry<WindSource, Series> e : toProcess.entrySet()) {
            Series series = e.getValue();
            WindSource seriesSource = e.getKey();
            if (seriesSource.getType().equals((Object)this.preselectFilter.getType())) {
                if (!visibleSeries.contains(series)) {
                    this.chart.addSeries(series, true, false);
                }
                if (this.preselectFilter.equals(e.getKey())) {
                    wasInResult = true;
                    series.select(true);
                    series.setVisible(true, true);
                    continue;
                }
                series.select(false);
                series.setVisible(false, true);
                continue;
            }
            if (!visibleSeries.contains(series)) continue;
            this.chart.removeSeries(series, false);
        }
        return wasInResult;
    }

    private Series getOrCreateSpeedSeries(WindSource windSource) {
        Series result = (Series)this.windSourceSpeedSeries.get(windSource);
        if (result == null) {
            result = this.createSpeedSeries(windSource);
            this.windSourceSpeedSeries.put(windSource, result);
        }
        return result;
    }

    private Series getOrCreateDirectionSeries(WindSource windSource) {
        Series result = (Series)this.windSourceDirectionSeries.get(windSource);
        if (result == null) {
            result = this.createDirectionSeries(windSource);
            this.windSourceDirectionSeries.put(windSource, result);
        }
        return result;
    }

    private Series createDirectionSeries(WindSource windSource) {
        Series newSeries = ((Series)this.chart.createSeries().setType(Series.Type.LINE).setName(String.valueOf(this.stringMessages.fromDeg()) + " " + WindSourceTypeFormatter.format((WindSource)windSource, (StringMessages)this.stringMessages)).setYAxis((Number)0).setOption("turboThreshold", (Object)1000000)).setPlotOptions(((LinePlotOptions)new LinePlotOptions().setColor(this.colorMap.getColorByID((Object)windSource).getAsHtml())).setSelected(true));
        return newSeries;
    }

    private Series createSpeedSeries(WindSource windSource) {
        Series newSeries = ((Series)this.chart.createSeries().setType(Series.Type.LINE).setName(String.valueOf(this.stringMessages.windSpeed()) + " " + WindSourceTypeFormatter.format((WindSource)windSource, (StringMessages)this.stringMessages)).setYAxis((Number)1).setOption("turboThreshold", (Object)1000000)).setPlotOptions(((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)new LinePlotOptions().setDashStyle(PlotLine.DashStyle.SHORT_DOT)).setLineWidth((Number)3)).setHoverStateLineWidth((Number)3)).setColor(this.colorMap.getColorByID((Object)windSource).getAsHtml())).setSelected(true));
        return newSeries;
    }

    public void updateChartSeries(WindInfoForRaceDTO result, boolean append) {
        NumberFormat numberFormat = NumberFormat.getFormat((String)"0");
        Long newMinTimepoint = this.timeOfEarliestRequestInMillis;
        Long newMaxTimepoint = this.timeOfLatestRequestInMillis;
        for (WindSource windSource : result.windTrackInfoByWindSource.keySet()) {
            Point[] newDirectionPoints;
            WindTrackInfoDTO windTrackInfo = (WindTrackInfoDTO)result.windTrackInfoByWindSource.get(windSource);
            Series directionSeries = this.getOrCreateDirectionSeries(windSource);
            Series speedSeries = null;
            if (windSource.getType().useSpeed()) {
                speedSeries = this.getOrCreateSpeedSeries(windSource);
            }
            Point previousDirectionPoint = null;
            if (append && this.windSourceDirectionPoints.get(windSource) != null && ((Point[])this.windSourceDirectionPoints.get(windSource)).length != 0) {
                previousDirectionPoint = ((Point[])this.windSourceDirectionPoints.get(windSource))[((Point[])this.windSourceDirectionPoints.get(windSource)).length - 1];
            }
            Point[] directionPoints = new Point[windTrackInfo.windFixes.size()];
            Point[] speedPoints = new Point[windTrackInfo.windFixes.size()];
            int currentPointIndex = 0;
            for (WindDTO wind : windTrackInfo.windFixes) {
                if (newMinTimepoint == null || wind.requestTimepoint < newMinTimepoint) {
                    newMinTimepoint = wind.requestTimepoint;
                }
                if (newMaxTimepoint == null || wind.requestTimepoint > newMaxTimepoint) {
                    newMaxTimepoint = wind.requestTimepoint;
                }
                if (append && this.timeOfEarliestRequestInMillis != null && wind.requestTimepoint >= this.timeOfEarliestRequestInMillis && this.timeOfLatestRequestInMillis != null && wind.requestTimepoint <= this.timeOfLatestRequestInMillis) continue;
                Point newDirectionPoint = new Point((Number)wind.requestTimepoint, (Number)wind.dampenedTrueWindFromDeg);
                if (wind.dampenedTrueWindSpeedInKnots != null) {
                    String name = String.valueOf(numberFormat.format((Number)wind.dampenedTrueWindSpeedInKnots)) + this.stringMessages.knotsUnit();
                    newDirectionPoint.setName(name);
                }
                if (previousDirectionPoint != null) {
                    newDirectionPoint = ChartPointRecalculator.stayClosestToPreviousPoint((Point)previousDirectionPoint, (Point)newDirectionPoint);
                } else if (this.firstPointOfFirstSeries != null && this.windSourceDirectionPoints.get(windSource) == null) {
                    newDirectionPoint = ChartPointRecalculator.stayClosestToPreviousPoint((Point)this.firstPointOfFirstSeries, (Point)newDirectionPoint);
                }
                directionPoints[currentPointIndex] = newDirectionPoint;
                previousDirectionPoint = newDirectionPoint;
                Point newSpeedPoint = new Point((Number)wind.requestTimepoint, (Number)wind.dampenedTrueWindSpeedInKnots);
                speedPoints[currentPointIndex++] = newSpeedPoint;
            }
            Point[] newSpeedPoints = null;
            if (append) {
                Point[] oldDirectionPoints = this.windSourceDirectionPoints.get(windSource) != null ? (Point[])this.windSourceDirectionPoints.get(windSource) : new Point[]{};
                newDirectionPoints = new Point[oldDirectionPoints.length + currentPointIndex];
                System.arraycopy(oldDirectionPoints, 0, newDirectionPoints, 0, oldDirectionPoints.length);
                System.arraycopy(directionPoints, 0, newDirectionPoints, oldDirectionPoints.length, currentPointIndex);
                if (windSource.getType().useSpeed()) {
                    Point[] oldSpeedPoints = this.windSourceSpeedPoints.get(windSource) != null ? (Point[])this.windSourceSpeedPoints.get(windSource) : new Point[]{};
                    newSpeedPoints = new Point[oldSpeedPoints.length + currentPointIndex];
                    System.arraycopy(oldSpeedPoints, 0, newSpeedPoints, 0, oldSpeedPoints.length);
                    System.arraycopy(speedPoints, 0, newSpeedPoints, oldSpeedPoints.length, currentPointIndex);
                }
            } else {
                newDirectionPoints = directionPoints;
                newSpeedPoints = speedPoints;
            }
            this.setSeriesPoints(directionSeries, newDirectionPoints, true);
            this.windSourceDirectionPoints.put(windSource, newDirectionPoints);
            if (windSource.getType().useSpeed()) {
                this.setSeriesPoints(speedSeries, newSpeedPoints, true);
                this.windSourceSpeedPoints.put(windSource, newSpeedPoints);
            }
            if (this.firstPointOfFirstSeries != null || newDirectionPoints.length == 0) continue;
            this.firstPointOfFirstSeries = newDirectionPoints[0];
        }
        this.timeOfEarliestRequestInMillis = newMinTimepoint;
        this.timeOfLatestRequestInMillis = newMaxTimepoint;
    }

    public boolean hasSettings() {
        return this.windChartLifecycle.hasSettings();
    }

    public SettingsDialogComponent<WindChartSettings> getSettingsDialogComponent(WindChartSettings settings) {
        return this.windChartLifecycle.getSettingsDialogComponent(settings);
    }

    public void updateSettings(WindChartSettings newSettings) {
        this.preselectFilter = null;
        boolean clearCacheAndReload = false;
        Set oldWindSourceTypesToRequest = this.getNamesOfWindSourceTypesOfWhichToDisplaySpeedOrDirection();
        if (newSettings.getResolutionInMilliseconds() != this.settings.getResolutionInMilliseconds()) {
            this.settings.setResolutionInMilliseconds(newSettings.getResolutionInMilliseconds());
            clearCacheAndReload = true;
        }
        this.settings.setShowWindDirectionsSeries(newSettings.isShowWindDirectionsSeries());
        this.settings.setWindDirectionSourcesToDisplay(newSettings.getWindDirectionSourcesToDisplay());
        this.settings.setShowWindSpeedSeries(newSettings.isShowWindSpeedSeries());
        this.settings.setWindSpeedSourcesToDisplay(newSettings.getWindSpeedSourcesToDisplay());
        if (!oldWindSourceTypesToRequest.equals(this.getNamesOfWindSourceTypesOfWhichToDisplaySpeedOrDirection())) {
            clearCacheAndReload = true;
        }
        if (clearCacheAndReload) {
            this.clearCacheAndReload();
        }
        this.updateVisibleSeries();
    }

    private void clearCacheAndReload() {
        this.timeOfEarliestRequestInMillis = null;
        this.timeOfLatestRequestInMillis = null;
        this.windSourceDirectionPoints.clear();
        this.windSourceSpeedPoints.clear();
        this.firstPointOfFirstSeries = null;
        this.loadData(this.timeRangeWithZoomProvider.getFromTime(), this.timeRangeWithZoomProvider.getToTime(), false);
    }

    private void loadData(Date from, Date to, boolean append) {
        if (this.isVisible()) {
            if (this.selectedRaceIdentifier == null) {
                this.clearChart();
            } else if (from != null && to != null) {
                this.setWidget((Widget)this.chart);
                if (this.shouldShowLoading(this.timeOfLatestRequestInMillis)) {
                    this.showLoading(this.stringMessages.windChartLoading());
                }
                GetWindInfoAction getWindInfoAction = new GetWindInfoAction(this.sailingService, this.selectedRaceIdentifier, from, to, this.settings.getResolutionInMilliseconds(), (Collection)this.getNamesOfWindSourceTypesOfWhichToDisplaySpeedOrDirection(), true);
                this.asyncActionsExecutor.execute((AsyncAction)getWindInfoAction, LOAD_WIND_CHART_DATA_CATEGORY, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private Set<String> getNamesOfWindSourceTypesOfWhichToDisplaySpeedOrDirection() {
        HashSet<String> result = new HashSet<String>();
        for (WindSourceType speedType : this.getSettings().getWindSpeedSourcesToDisplay()) {
            result.add(speedType.name());
        }
        for (WindSourceType speedType : this.getSettings().getWindDirectionSourcesToDisplay()) {
            result.add(speedType.name());
        }
        return result;
    }

    private void clearChart() {
        this.chart.removeAllSeries();
    }

    /*
     * Exception decompiling
     */
    public void timeChanged(Date newTime, Date oldTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onResize() {
        this.chart.setSizeToMatchContainer();
        this.chart.redraw();
    }

    private String printWindInfoForRace(Date from, Date to, WindInfoForRaceDTO result, boolean printFixDetails) {
        DateTimeFormatRenderer timeFormatter = new DateTimeFormatRenderer((com.google.gwt.i18n.shared.DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm:ss:SSS"));
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("Loaded wind data...\n");
        buffer.append("From: " + timeFormatter.render(from) + "\n");
        buffer.append("To: " + timeFormatter.render(to) + "\n");
        buffer.append("With resolution: " + this.settings.getResolutionInMilliseconds() + "\n");
        for (WindSource windSource : result.windTrackInfoByWindSource.keySet()) {
            WindTrackInfoDTO windTrackInfoDTO = (WindTrackInfoDTO)result.windTrackInfoByWindSource.get(windSource);
            int i = 1;
            buffer.append("Data of windsource: " + windSource.name() + "\n");
            if (printFixDetails) {
                for (WindDTO windDTO : windTrackInfoDTO.windFixes) {
                    String windFix = "P" + i++ + ": " + timeFormatter.render(new Date(windDTO.requestTimepoint));
                    if (windDTO.measureTimepoint != null) {
                        windFix = String.valueOf(windFix) + " ," + timeFormatter.render(new Date(windDTO.measureTimepoint));
                    }
                    buffer.append(String.valueOf(windFix) + "\n");
                }
                continue;
            }
            buffer.append(String.valueOf(Util.size((Iterable)windTrackInfoDTO.windFixes)) + " Fixes" + "\n");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private String printPoints(WindSource windSource, String whatIsIt, Point[] points, boolean printFixDetails) {
        StringBuffer buffer = new StringBuffer();
        DateTimeFormatRenderer timeFormatter = new DateTimeFormatRenderer((com.google.gwt.i18n.shared.DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm:ss:SSS"));
        buffer.append("\n");
        buffer.append("WindSource: " + windSource.name() + ": " + whatIsIt + "\n");
        buffer.append("Resolution in ms: " + this.settings.getResolutionInMilliseconds() + "\n");
        buffer.append("timeOfEarliestRequest: " + (this.timeOfEarliestRequestInMillis != null ? timeFormatter.render(new Date(this.timeOfEarliestRequestInMillis)) : "") + "\n");
        buffer.append("timeOfLatestRequest: " + (this.timeOfLatestRequestInMillis != null ? timeFormatter.render(new Date(this.timeOfLatestRequestInMillis)) : "") + "\n");
        if (points == null) {
            buffer.append("Points is null\n");
        } else {
            buffer.append("Point count: " + points.length + "\n");
            if (printFixDetails) {
                Date xAsDate = new Date();
                int i = 0;
                while (i < points.length) {
                    Point point = points[i];
                    xAsDate.setTime(point.getX().longValue());
                    buffer.append("P" + (i + 1) + ": " + timeFormatter.render(xAsDate) + ", V: " + point.getY() + "\n");
                    ++i;
                }
            }
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public String getDependentCssClassName() {
        return "windChart";
    }

    public WindChartSettings getSettings() {
        return this.settings;
    }

    public String getId() {
        return this.windChartLifecycle.getComponentId();
    }

    public void showProvider(WindSource windprovider) {
        WindSourceType type = windprovider.getType();
        HashSet<WindSourceType> windSpeedSourcesToDisplay = new HashSet<WindSourceType>();
        HashSet<WindSourceType> windDirectionSourcesToDisplay = new HashSet<WindSourceType>();
        windSpeedSourcesToDisplay.add(type);
        windDirectionSourcesToDisplay.add(type);
        WindChartSettings patched = new WindChartSettings(true, windSpeedSourcesToDisplay, true, windDirectionSourcesToDisplay, this.settings.getResolutionInMilliseconds());
        this.updateSettings(patched);
        this.preselectFilter = windprovider;
        this.updateVisibleSeries();
    }

    static /* synthetic */ void access$3(WindChart windChart) {
        windChart.updateVisibleSeries();
    }

    static /* synthetic */ void access$4(WindChart windChart) {
        windChart.clearChart();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;
        }
        int[] nArray = new int[Timer.PlayModes.values().length];
        try {
            nArray[Timer.PlayModes.Live.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayModes.Replay.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes = nArray;
        return nArray;
    }
}

