/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.user.client.ui.Button;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractCompetitorRaceChart;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartSettingsComponent;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.UUID;

public class MultiCompetitorRaceChart
extends AbstractCompetitorRaceChart<MultiCompetitorRaceChartSettings>
implements Component<MultiCompetitorRaceChartSettings> {
    private final MultiCompetitorRaceChartLifecycle lifecycle;

    public MultiCompetitorRaceChart(Component<?> parent, ComponentContext<?> context, MultiCompetitorRaceChartLifecycle lifecycle, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, RaceCompetitorSelectionProvider competitorSelectionProvider, RegattaAndRaceIdentifier selectedRaceIdentifier, Timer timer, TimeRangeWithZoomProvider timeRangeWithZoomProvider, StringMessages stringMessages, ErrorReporter errorReporter, boolean compactChart, boolean allowTimeAdjust, String leaderboardGroupName, UUID leaderboardGroupId, String leaderboardName) {
        super(parent, context, sailingService, asyncActionsExecutor, competitorSelectionProvider, selectedRaceIdentifier, timer, timeRangeWithZoomProvider, stringMessages, errorReporter, DetailType.CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD, null, compactChart, allowTimeAdjust, leaderboardGroupName, leaderboardGroupId, leaderboardName);
        this.lifecycle = lifecycle;
    }

    protected Button createSettingsButton() {
        Button settingsButton = SettingsDialog.createSettingsButton((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        return settingsButton;
    }

    public MultiCompetitorRaceChartSettings getSettings() {
        return new MultiCompetitorRaceChartSettings(this.getAbstractSettings(), this.getSelectedFirstDetailType(), this.getSelectedSecondDetailType());
    }

    public SettingsDialogComponent<MultiCompetitorRaceChartSettings> getSettingsDialogComponent(MultiCompetitorRaceChartSettings settings) {
        return new MultiCompetitorRaceChartSettingsComponent(settings, this.getStringMessages(), this.lifecycle.getAllowedDetailTypes());
    }

    public void updateSettings(MultiCompetitorRaceChartSettings newSettings) {
        boolean selectedDetailTypeChanged;
        boolean settingsChanged = this.updateSettingsOnly((ChartSettings)newSettings);
        DetailType firstType = newSettings.getFirstDetailType();
        DetailType secondType = newSettings.getSecondDetailType();
        if (!Util.contains((Iterable)this.lifecycle.getAllowedDetailTypes(), (Object)firstType)) {
            firstType = DetailType.CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD;
        }
        if (!Util.contains((Iterable)this.lifecycle.getAllowedDetailTypes(), (Object)secondType)) {
            secondType = null;
        }
        if ((selectedDetailTypeChanged = this.setSelectedDetailTypes(firstType, secondType)) || settingsChanged) {
            this.clearChart();
            this.timeChanged(this.timer.getTime(), null);
        }
    }

    protected Component<MultiCompetitorRaceChartSettings> getComponent() {
        return this;
    }

    public String getLocalizedShortName() {
        return this.lifecycle.getLocalizedShortName();
    }

    public String getDependentCssClassName() {
        return "multiCompetitorRaceChart";
    }

    public String getId() {
        return this.lifecycle.getComponentId();
    }
}

