/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPositionPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.MarksPanel;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardTableResources;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableSortedCellTableWithStylableHeaders;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.SortableColumn;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;

public class MarksPanel
extends AbstractCompositeComponent<AbstractSettings> {
    private static final LeaderboardTableResources tableResources = (LeaderboardTableResources)GWT.create(LeaderboardTableResources.class);
    private final ListDataProvider<MarkDTO> markDataProvider;
    private final FlushableSortedCellTableWithStylableHeaders<MarkDTO> markTable = new FlushableSortedCellTableWithStylableHeaders(10000, (CellTable.Resources)tableResources);

    public MarksPanel(EditMarkPositionPanel parent, ComponentContext<?> context, StringMessages stringMessages) {
        super((Component)parent, context);
        this.markDataProvider = this.markTable.getDataProvider();
        this.markTable.addStyleName("EditMarkPositionMarkTable");
        1 markNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.markTable.addColumn((SortableColumn)markNameColumn);
        2 addFixColumn = new /* Unavailable Anonymous Inner Class!! */;
        addFixColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.markTable.addColumn((SortableColumn)addFixColumn);
        RefreshableSingleSelectionModel selectionModel = new RefreshableSingleSelectionModel((EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.markDataProvider);
        this.markTable.setSelectionModel((SelectionModel)selectionModel);
        this.markTable.getSelectionModel().addSelectionChangeHandler((SelectionChangeEvent.Handler)parent);
        FlowPanel mainPanel = new FlowPanel();
        Widget clearSelection = this.createClearSelection(arg_0 -> MarksPanel.lambda$0((SingleSelectionModel)selectionModel, arg_0), stringMessages);
        this.markTable.getSelectionModel().addSelectionChangeHandler(arg_0 -> MarksPanel.lambda$1(clearSelection, (SingleSelectionModel)selectionModel, arg_0));
        mainPanel.add(clearSelection);
        mainPanel.add((Widget)this.markTable);
        this.initWidget((Widget)mainPanel);
        this.setTitle(stringMessages.marks());
    }

    private Widget createClearSelection(ClickHandler clearSelectionHandler, StringMessages stringMessages) {
        FlowPanel clearSelectionPanel = new FlowPanel();
        clearSelectionPanel.addStyleName("EditMarkPositionHintPanel");
        clearSelectionPanel.add((Widget)new Label(stringMessages.pleaseClearSelectionToSeeFullCourse()));
        clearSelectionPanel.add((Widget)new Button(stringMessages.clearSelection(), clearSelectionHandler));
        clearSelectionPanel.add((Widget)new Label());
        clearSelectionPanel.setVisible(false);
        return clearSelectionPanel;
    }

    void updateMarks(Iterable<MarkDTO> marks) {
        this.markTable.getDataProvider().getList().clear();
        for (MarkDTO mark : marks) {
            this.markTable.getDataProvider().getList().add(mark);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public String getLocalizedShortName() {
        return null;
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<AbstractSettings> getSettingsDialogComponent(AbstractSettings settings) {
        return null;
    }

    public void updateSettings(AbstractSettings newSettings) {
    }

    public String getDependentCssClassName() {
        return null;
    }

    public MarkDTO getSelectedMark() {
        for (MarkDTO mark : this.markDataProvider.getList()) {
            if (!this.markTable.getSelectionModel().isSelected((Object)mark)) continue;
            return mark;
        }
        return null;
    }

    public void deselectMark() {
        this.markTable.getSelectionModel().setSelected((Object)this.getSelectedMark(), false);
    }

    public void select(MarkDTO mark) {
        this.markTable.getSelectionModel().setSelected((Object)mark, true);
    }

    public AbstractSettings getSettings() {
        return null;
    }

    public String getId() {
        return "MarksPanel";
    }

    private static /* synthetic */ void lambda$0(SingleSelectionModel singleSelectionModel, ClickEvent event) {
        singleSelectionModel.clear();
    }

    private static /* synthetic */ void lambda$1(Widget widget, SingleSelectionModel singleSelectionModel, SelectionChangeEvent event) {
        widget.setVisible(!singleSelectionModel.getSelectedSet().isEmpty());
    }
}

