/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.controls.ControlPosition;
import com.google.gwt.maps.client.events.center.CenterChangeMapHandler;
import com.google.gwt.maps.client.mvc.MVCArray;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.FixType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPositionPanel;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.FixOverlay;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import java.util.Collection;
import java.util.List;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.Point;

public class FixPositionChooser {
    private final Callback<Position, Exception> callback;
    private final MapWidget map;
    private final boolean newFix;
    private final int polylineFixIndex;
    private final MVCArray<LatLng> polylinePath;
    private final LatLng startPos;
    private final FixOverlay overlay;
    private final CoordinateSystem coordinateSystem;
    private FixOverlay moveOverlay;
    private HandlerRegistration centerChangeHandlerRegistration;
    private MenuBar menu;
    private final EditMarkPositionPanel editMarkPositionPanel;
    private final StringMessages stringMessages;
    private final PlotLine redTimeLine;

    public FixPositionChooser(EditMarkPositionPanel editMarkPositionPanel, StringMessages stringMessages, MapWidget map, int polylineFixIndex, MVCArray<LatLng> polylinePath, FixOverlay overlay, Callback<Position, Exception> callback) {
        this(editMarkPositionPanel, stringMessages, false, map, polylineFixIndex, polylinePath, overlay, overlay.getLatLngPosition(), overlay.getCoordinateSystem(), stringMessages.confirmMove(), callback);
    }

    public FixPositionChooser(EditMarkPositionPanel editMarkPositionPanel, StringMessages stringMessages, MapWidget map, int polylineFixIndex, MVCArray<LatLng> polylinePath, LatLng startPos, CoordinateSystem coordinateSystem, Callback<Position, Exception> callback) {
        this(editMarkPositionPanel, stringMessages, true, map, polylineFixIndex, polylinePath, null, startPos, coordinateSystem, stringMessages.confirmNewFix(), callback);
    }

    private FixPositionChooser(EditMarkPositionPanel editMarkPositionPanel, StringMessages stringMessages, boolean newFix, MapWidget map, int polylineFixIndex, MVCArray<LatLng> polylinePath, FixOverlay overlay, LatLng startPos, CoordinateSystem coordinateSystem, String confirmButtonText, Callback<Position, Exception> callback) {
        this.callback = callback;
        this.stringMessages = stringMessages;
        this.map = map;
        this.newFix = newFix;
        this.polylineFixIndex = polylineFixIndex;
        this.polylinePath = polylinePath;
        this.overlay = overlay;
        this.startPos = startPos;
        this.coordinateSystem = coordinateSystem;
        this.editMarkPositionPanel = editMarkPositionPanel;
        this.editMarkPositionPanel.showNotification(stringMessages.selectAFixPositionBy());
        this.redTimeLine = editMarkPositionPanel.getXAxis().createPlotLine().setColor(new Color(255, 0, 0)).setWidth((Number)1.5).setDashStyle(PlotLine.DashStyle.SOLID);
        this.setupUIOverlay(confirmButtonText);
    }

    private void setupUIOverlay(String confirmButtonText) {
        GPSFixDTO fix;
        if (this.overlay != null) {
            GPSFixDTO oldFix = this.overlay.getGPSFixDTO();
            fix = new GPSFixDTO(oldFix.timepoint, oldFix.position);
            this.moveOverlay = new FixOverlay(this.map, this.overlay.getZIndex(), fix, this.overlay.getType(), "#f00", this.coordinateSystem, this.stringMessages.dragToChangePosition());
        } else {
            fix = new GPSFixDTOWithSpeedWindTackAndLegType(this.editMarkPositionPanel.getTimepoint(), this.coordinateSystem.getPosition(this.startPos), null, null, new WindDTO(), null, null, false);
            this.moveOverlay = new FixOverlay(this.map, 231, fix, FixType.BUOY, "#f00", this.coordinateSystem, this.stringMessages.dragToChangePosition());
        }
        this.redTimeLine.setValue((Number)fix.timepoint.getTime());
        this.editMarkPositionPanel.getXAxis().addPlotLines(new PlotLine[]{this.redTimeLine});
        this.map.panTo(this.startPos);
        if (this.polylinePath != null && this.newFix) {
            this.polylinePath.insertAt(this.polylineFixIndex, (JavaScriptObject)this.map.getCenter());
        }
        this.setRedPointInChart(fix);
        this.centerChangeHandlerRegistration = this.map.addCenterChangeHandler((CenterChangeMapHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.menu = new MenuBar(false);
        this.menu.setStyleName("EditMarkPositionConfirmCancelButtons");
        MenuItem confirm = new MenuItem(confirmButtonText, (Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        MenuItem cancel = new MenuItem(this.stringMessages.cancel(), (Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.addItem(confirm);
        this.menu.addItem(cancel);
        this.map.setControls(ControlPosition.BOTTOM_LEFT, (Widget)this.menu);
    }

    private void destroyUIOverlay() {
        this.moveOverlay.removeFromMap();
        this.centerChangeHandlerRegistration.removeHandler();
        this.menu.removeFromParent();
    }

    private void cleanupChart() {
        this.editMarkPositionPanel.getXAxis().removePlotLine(this.redTimeLine);
        this.editMarkPositionPanel.updateRedPoint(this.polylineFixIndex);
        this.editMarkPositionPanel.resetPointColor(this.polylineFixIndex);
        this.editMarkPositionPanel.redrawChart();
    }

    private void setRedPointInChart(GPSFixDTO fix) {
        List fixes = this.editMarkPositionPanel.getMarkFixes();
        if (fixes != null) {
            if (this.newFix) {
                fixes.add(this.polylineFixIndex, fix);
            } else {
                fixes.set(this.polylineFixIndex, fix);
            }
            Point[] points = this.editMarkPositionPanel.getSeriesPoints((Collection)fixes);
            this.editMarkPositionPanel.setRedPoint(points, this.polylineFixIndex);
            this.editMarkPositionPanel.setSeriesPoints(points);
            this.editMarkPositionPanel.redrawChart();
        }
    }

    public void cancel() {
        this.destroyUIOverlay();
        this.cleanupChart();
        if (this.polylinePath != null) {
            if (this.newFix) {
                this.polylinePath.removeAt(this.polylineFixIndex);
            } else {
                this.polylinePath.setAt(this.polylineFixIndex, (JavaScriptObject)this.overlay.getLatLngPosition());
            }
        }
        this.callback.onFailure(null);
    }

    static /* synthetic */ CoordinateSystem access$0(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.coordinateSystem;
    }

    static /* synthetic */ MapWidget access$1(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.map;
    }

    static /* synthetic */ FixOverlay access$2(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.moveOverlay;
    }

    static /* synthetic */ MVCArray access$3(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.polylinePath;
    }

    static /* synthetic */ int access$4(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.polylineFixIndex;
    }

    static /* synthetic */ void access$5(FixPositionChooser fixPositionChooser, GPSFixDTO gPSFixDTO) {
        fixPositionChooser.setRedPointInChart(gPSFixDTO);
    }

    static /* synthetic */ void access$6(FixPositionChooser fixPositionChooser) {
        fixPositionChooser.destroyUIOverlay();
    }

    static /* synthetic */ void access$7(FixPositionChooser fixPositionChooser) {
        fixPositionChooser.cleanupChart();
    }

    static /* synthetic */ Callback access$8(FixPositionChooser fixPositionChooser) {
        return fixPositionChooser.callback;
    }
}

