/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.gwt.ui.adminconsole.SetTimePointDialog;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.HasAvailabilityCheck;
import com.sap.sailing.gwt.ui.client.shared.charts.RaceIdentifierToLeaderboardRaceColumnAndFleetMapper;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class EditMarkPassingsPanel
extends AbstractCompositeComponent<AbstractSettings>
implements CompetitorSelectionChangeListener,
HasAvailabilityCheck {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final SailingServiceAsync sailingService;
    private RegattaAndRaceIdentifier raceIdentifier;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final CompetitorSelectionProvider competitorSelectionModel;
    private final RaceIdentifierToLeaderboardRaceColumnAndFleetMapper raceIdentifierToLeaderboardRaceColumnAndFleetMapper;
    private CompetitorDTO competitor;
    private Map<Integer, Date> currentCompetitorEdits = new HashMap();
    private Integer zeroBasedIndexOfFirstSuppressedWaypoint;
    private final CellTable<Util.Pair<Integer, Date>> wayPointSelectionTable;
    private final ListDataProvider<Util.Pair<Integer, Date>> waypointList;
    private final SingleSelectionModel<Util.Pair<Integer, Date>> waypointSelectionModel;
    private List<WaypointDTO> currentWaypoints;
    private final Button chooseTimeAsMarkPassingsButton;
    private final Button setTimeAsMarkPassingsButton;
    private final Button removeFixedMarkPassingsButton;
    private final Button suppressPassingsButton;
    private final Button removeSuppressedPassingButton;
    private Label selectCompetitorLabel = new Label();

    public EditMarkPassingsPanel(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, SailingServiceWriteAsync sailingServiceWrite, RegattaAndRaceIdentifier raceIdentifier, StringMessages stringMessages, CompetitorSelectionProvider competitorSelectionModel, ErrorReporter errorReporter, Timer timer) {
        super(parent, context);
        this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper = new RaceIdentifierToLeaderboardRaceColumnAndFleetMapper();
        this.sailingService = sailingService;
        this.sailingServiceWrite = sailingServiceWrite;
        this.raceIdentifier = raceIdentifier;
        this.errorReporter = errorReporter;
        this.competitorSelectionModel = competitorSelectionModel;
        this.stringMessages = stringMessages;
        competitorSelectionModel.addCompetitorSelectionChangeListener((CompetitorSelectionChangeListener)this);
        this.currentWaypoints = new ArrayList();
        this.waypointList = new ListDataProvider();
        this.waypointSelectionModel = new SingleSelectionModel();
        this.waypointSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.wayPointSelectionTable = new BaseCelltable(10000);
        this.wayPointSelectionTable.addColumn((Column)new /* Unavailable Anonymous Inner Class!! */, stringMessages.waypoint());
        DateTimeFormat timeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL);
        this.wayPointSelectionTable.addColumn((Column)new /* Unavailable Anonymous Inner Class!! */, stringMessages.markPassing());
        this.waypointList.addDataDisplay((HasData)this.wayPointSelectionTable);
        this.wayPointSelectionTable.setSelectionModel((SelectionModel)this.waypointSelectionModel);
        this.removeFixedMarkPassingsButton = new Button(stringMessages.removeFixedPassings());
        this.removeFixedMarkPassingsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.chooseTimeAsMarkPassingsButton = new Button(stringMessages.chooseFixedPassing());
        this.chooseTimeAsMarkPassingsButton.addClickHandler(clickEvent -> new SetTimePointDialog(stringMessages, stringMessages.chooseFixedPassing(), (Date)((Util.Pair)this.waypointSelectionModel.getSelectedObject()).getB(), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show());
        this.setTimeAsMarkPassingsButton = new Button(stringMessages.setFixedPassing());
        this.setTimeAsMarkPassingsButton.addClickHandler(clickEvent -> this.updateMarkPassingTime(timer.getTime(), true));
        this.suppressPassingsButton = new Button(stringMessages.setSuppressedPassing());
        this.suppressPassingsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeSuppressedPassingButton = new Button(stringMessages.removeSuppressedPassing());
        this.removeSuppressedPassingButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Label warningChangesHaveNoEffect = new Label(stringMessages.warningMarkPassingChangesNoEffect());
        warningChangesHaveNoEffect.setStylePrimaryName("errorLabel");
        warningChangesHaveNoEffect.setVisible(false);
        sailingServiceWrite.getTrackedRaceIsUsingMarkPassingCalculator(raceIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.selectCompetitorLabel.setText(stringMessages.selectCompetitor());
        this.refreshWaypoints();
        AbsolutePanel rootPanel = new AbsolutePanel();
        HorizontalPanel tableAndButtons = new HorizontalPanel();
        rootPanel.add((Widget)tableAndButtons, 0, 0);
        tableAndButtons.setSpacing(3);
        tableAndButtons.add((Widget)this.wayPointSelectionTable);
        VerticalPanel buttonPanel = new VerticalPanel();
        buttonPanel.setSpacing(3);
        tableAndButtons.add((Widget)buttonPanel);
        buttonPanel.add((Widget)this.chooseTimeAsMarkPassingsButton);
        buttonPanel.add((Widget)this.setTimeAsMarkPassingsButton);
        buttonPanel.add((Widget)this.removeFixedMarkPassingsButton);
        buttonPanel.add((Widget)this.suppressPassingsButton);
        buttonPanel.add((Widget)this.removeSuppressedPassingButton);
        buttonPanel.add((Widget)this.selectCompetitorLabel);
        this.enableButtons();
        tableAndButtons.add((Widget)warningChangesHaveNoEffect);
        tableAndButtons.setCellVerticalAlignment((Widget)warningChangesHaveNoEffect, HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)rootPanel);
        this.setVisible(false);
    }

    private void updateMarkPassingTime(Date time, boolean waitForCalculations) {
        RaceIdentifierToLeaderboardRaceColumnAndFleetMapper.LeaderboardNameRaceColumnNameAndFleetName leaderboardNameRaceColumnNameAndFleetName = this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.raceIdentifier);
        if (time != null && leaderboardNameRaceColumnNameAndFleetName != null) {
            Integer waypoint = (Integer)((Util.Pair)this.waypointSelectionModel.getSelectedObject()).getA();
            if (this.isSettingFixedTimePossible(time, this.stringMessages)) {
                this.sailingServiceWrite.updateFixedMarkPassing(leaderboardNameRaceColumnNameAndFleetName.getLeaderboardName(), leaderboardNameRaceColumnNameAndFleetName.getRaceColumnName(), leaderboardNameRaceColumnNameAndFleetName.getFleetName(), waypoint, time, this.competitor, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Notification.notify((String)this.stringMessages.warningSettingFixedPassing(((WaypointDTO)this.currentWaypoints.get(waypoint)).getName()), (Notification.NotificationType)Notification.NotificationType.WARNING);
            }
        }
    }

    private boolean isSettingFixedTimePossible(Date time, StringMessages stringMessages) {
        Integer selectedWaypointIndex = (Integer)((Util.Pair)this.waypointSelectionModel.getSelectedObject()).getA();
        for (Integer waypointIndex : this.currentCompetitorEdits.keySet()) {
            Date waypointDate = (Date)this.currentCompetitorEdits.get(waypointIndex);
            if ((waypointIndex >= selectedWaypointIndex || !waypointDate.after(time)) && (waypointIndex <= selectedWaypointIndex || !waypointDate.before(time))) continue;
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.processCompetitorSelectionChange(visible);
        this.refreshWaypoints();
        super.setVisible(visible);
    }

    public void addedToSelection(CompetitorDTO competitor) {
        this.processCompetitorSelectionChange(this.isVisible());
    }

    public void removedFromSelection(CompetitorDTO competitor) {
        this.processCompetitorSelectionChange(this.isVisible());
    }

    private void processCompetitorSelectionChange(boolean visible) {
        this.waypointSelectionModel.clear();
        if (visible && Util.size((Iterable)this.competitorSelectionModel.getSelectedCompetitors()) == 1) {
            this.selectCompetitorLabel.setText("");
            this.refillList();
        } else {
            this.disableEditing();
            this.selectCompetitorLabel.setText(this.stringMessages.selectCompetitor());
        }
    }

    private void disableEditing() {
        this.waypointList.getList().clear();
        this.clearInfo();
    }

    private void refillList() {
        this.refillList(null, 0);
    }

    private void refillList(Predicate<Map<Integer, Date>> resultValidator, int triesLeft) {
        boolean waitForCalculations = resultValidator != null;
        this.clearInfo();
        this.competitor = (CompetitorDTO)this.competitorSelectionModel.getSelectedCompetitors().iterator().next();
        this.sailingService.getCompetitorMarkPassings(this.raceIdentifier, this.competitor, waitForCalculations, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void clearInfo() {
        this.currentCompetitorEdits.clear();
        this.competitor = null;
        this.zeroBasedIndexOfFirstSuppressedWaypoint = null;
    }

    private void refreshWaypoints() {
        this.sailingService.getRaceCourse(this.raceIdentifier, new Date(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void enableButtons() {
        this.chooseTimeAsMarkPassingsButton.setEnabled(false);
        this.setTimeAsMarkPassingsButton.setEnabled(false);
        this.removeFixedMarkPassingsButton.setEnabled(false);
        this.suppressPassingsButton.setEnabled(false);
        this.removeSuppressedPassingButton.setEnabled(false);
        if (Util.size((Iterable)this.competitorSelectionModel.getSelectedCompetitors()) == 1) {
            Util.Pair selectedWaypoint;
            if (this.zeroBasedIndexOfFirstSuppressedWaypoint != null) {
                this.removeSuppressedPassingButton.setEnabled(true);
            }
            if ((selectedWaypoint = (Util.Pair)this.waypointSelectionModel.getSelectedObject()) != null) {
                this.chooseTimeAsMarkPassingsButton.setEnabled(true);
                this.setTimeAsMarkPassingsButton.setEnabled(true);
                this.suppressPassingsButton.setEnabled(true);
                if (this.currentCompetitorEdits.containsKey(selectedWaypoint.getA())) {
                    this.removeFixedMarkPassingsButton.setEnabled(true);
                }
            }
        }
    }

    public void checkBackendAvailability(Consumer<Boolean> callback) {
        HasAvailabilityCheck.validateBackendAvailabilityAndExecuteBusinessLogic((SailingServiceWriteAsync)this.sailingServiceWrite, callback, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
    }

    public void setLeaderboard(LeaderboardDTO leaderboard) {
        this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.setLeaderboard(leaderboard);
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<AbstractSettings> getSettingsDialogComponent(AbstractSettings settings) {
        return null;
    }

    public void updateSettings(AbstractSettings newSettings) {
    }

    public String getLocalizedShortName() {
        return this.stringMessages.editMarkPassings();
    }

    public String getDependentCssClassName() {
        return null;
    }

    public void filterChanged(FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> oldFilterSet, FilterSet<CompetitorDTO, ? extends Filter<CompetitorDTO>> newFilterSet) {
    }

    public void competitorsListChanged(Iterable<CompetitorDTO> competitors) {
    }

    public void filteredCompetitorsListChanged(Iterable<CompetitorDTO> filteredCompetitors) {
    }

    public AbstractSettings getSettings() {
        return null;
    }

    public String getId() {
        return "EditMarkPassingsPanel";
    }

    static /* synthetic */ SingleSelectionModel access$3(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.waypointSelectionModel;
    }

    static /* synthetic */ void access$4(EditMarkPassingsPanel editMarkPassingsPanel) {
        editMarkPassingsPanel.enableButtons();
    }

    static /* synthetic */ List access$5(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.currentWaypoints;
    }

    static /* synthetic */ Map access$6(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.currentCompetitorEdits;
    }

    static /* synthetic */ Integer access$7(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.zeroBasedIndexOfFirstSuppressedWaypoint;
    }

    static /* synthetic */ RaceIdentifierToLeaderboardRaceColumnAndFleetMapper access$8(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.raceIdentifierToLeaderboardRaceColumnAndFleetMapper;
    }

    static /* synthetic */ CompetitorDTO access$9(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.competitor;
    }

    static /* synthetic */ void access$10(EditMarkPassingsPanel editMarkPassingsPanel, Predicate predicate, int n) {
        editMarkPassingsPanel.refillList(predicate, n);
    }

    static /* synthetic */ void access$11(EditMarkPassingsPanel editMarkPassingsPanel, Date date, boolean bl) {
        editMarkPassingsPanel.updateMarkPassingTime(date, bl);
    }

    static /* synthetic */ void access$12(EditMarkPassingsPanel editMarkPassingsPanel) {
        editMarkPassingsPanel.refillList();
    }

    static /* synthetic */ ErrorReporter access$13(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$14(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.stringMessages;
    }

    static /* synthetic */ ListDataProvider access$15(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.waypointList;
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$16(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.raceIdentifier;
    }

    static /* synthetic */ SailingServiceAsync access$17(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.sailingService;
    }

    static /* synthetic */ void access$18(EditMarkPassingsPanel editMarkPassingsPanel, Integer n) {
        editMarkPassingsPanel.zeroBasedIndexOfFirstSuppressedWaypoint = n;
    }

    static /* synthetic */ CellTable access$19(EditMarkPassingsPanel editMarkPassingsPanel) {
        return editMarkPassingsPanel.wayPointSelectionTable;
    }

    static /* synthetic */ void access$20(EditMarkPassingsPanel editMarkPassingsPanel, List list) {
        editMarkPassingsPanel.currentWaypoints = list;
    }
}

