/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media.shared;

import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.media.shared.MediaPlayer;
import java.util.Date;

public abstract class AbstractMediaPlayer
implements MediaPlayer {
    private static final int TOLERATED_LAG_IN_MILLISECONDS = 4000;
    private final MediaTrackWithSecurityDTO mediaTrack;
    private long raceTimeInMillis;

    protected AbstractMediaPlayer(MediaTrackWithSecurityDTO mediaTrack) {
        this.mediaTrack = mediaTrack;
    }

    public MediaTrackWithSecurityDTO getMediaTrack() {
        return this.mediaTrack;
    }

    protected void onMediaTimeUpdate() {
    }

    public void forceAlign() {
        this.forceAlign(this.mediaTrack.startTime.asMillis());
    }

    public void raceTimeChanged(Date raceTime) {
        if (raceTime != null) {
            this.raceTimeInMillis = raceTime.getTime();
            this.alignTime();
        }
    }

    public long getCurrentMediaTimeMillis() {
        return Math.round(this.getCurrentMediaTime() * 1000.0);
    }

    public boolean isCoveringCurrentRaceTime() {
        double mediaTime = (double)(this.raceTimeInMillis - this.mediaTrack.startTime.asMillis()) / 1000.0;
        double duration = this.getDuration();
        return mediaTime >= 0.0 && (duration == 0.0 || mediaTime <= duration);
    }

    protected void alignTime() {
        long mediaStartTimeInMillis = this.mediaTrack.startTime.asMillis();
        long mediaTimeInMillis = mediaStartTimeInMillis + this.getCurrentMediaTimeMillis();
        long mediaTimeOffFromRaceInMillis = this.raceTimeInMillis - mediaTimeInMillis;
        if (this.isOutOfTolerance(mediaTimeOffFromRaceInMillis)) {
            this.forceAlign(mediaStartTimeInMillis);
        }
    }

    private boolean isOutOfTolerance(long mediaTimeOffFromRaceInMillis) {
        return Math.abs(mediaTimeOffFromRaceInMillis) > 4000L;
    }

    private void forceAlign(long mediaStartTimeInMillis) {
        double mediaTime = (double)(this.raceTimeInMillis - mediaStartTimeInMillis) / 1000.0;
        if (mediaTime < 0.0) {
            this.pauseMedia();
        } else {
            double duration = this.getDuration();
            double diff = mediaTime - duration;
            if (duration == 0.0 || diff <= 0.0) {
                this.setCurrentMediaTime(mediaTime);
            } else {
                this.pauseMedia();
            }
        }
    }
}

