/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SourceElement;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.media.client.Audio;
import com.google.gwt.media.client.Video;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.PauseEvent;
import com.sap.sailing.gwt.ui.client.media.PlayEvent;
import com.sap.sailing.gwt.ui.client.media.VideoJSPlayer;
import com.sap.sse.common.media.MediaSubType;
import com.sap.sse.common.media.MediaType;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;

public class VideoJSPlayer
extends Composite
implements RequiresResize {
    private static VideoJSPlayerUiBinder uiBinder = (VideoJSPlayerUiBinder)GWT.create(VideoJSPlayerUiBinder.class);
    private static final int RESIZE_CHECK = 250;
    @UiField
    VideoJSStyle style;
    @UiField
    HTMLPanel playerHolder;
    @UiField(provided=true)
    MediaMenuIcon videoPlayerMenuButton;
    private final boolean fullHeightWidth;
    private final Timer resizeChecker = new /* Unavailable Anonymous Inner Class!! */;
    private String elementId;
    private JavaScriptObject player;
    private boolean autoplay;
    private boolean panorama;
    private boolean controls = true;

    public VideoJSPlayer(boolean fullHeightWidth, boolean autoplay, TakedownNoticeService takedownNoticeService, String takedownNoticeMessageKey) {
        SharedResources.INSTANCE.mainCss().ensureInjected();
        this.autoplay = autoplay;
        this.fullHeightWidth = fullHeightWidth;
        this.videoPlayerMenuButton = new MediaMenuIcon(takedownNoticeService, takedownNoticeMessageKey);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public HandlerRegistration addPlayHandler(PlayEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, PlayEvent.getType());
    }

    public HandlerRegistration addPauseHandler(PauseEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, PauseEvent.getType());
    }

    public void setVideo(MimeType mimeType, String source, String eventName) {
        Object videoElement = mimeType.mediaType == MediaType.audio ? Audio.createIfSupported() : Video.createIfSupported();
        this.playerHolder.add((Widget)videoElement);
        this.videoPlayerMenuButton.setData(eventName, source);
        videoElement.addStyleName(this.style.player());
        videoElement.addStyleName("video-js");
        videoElement.addStyleName("vjs-default-skin");
        videoElement.addStyleName("vjs-big-play-centered");
        videoElement.getElement().setAttribute("preload", "auto");
        this.elementId = "videojs_" + Document.get().createUniqueId();
        videoElement.getElement().setId(this.elementId);
        if (this.fullHeightWidth) {
            videoElement.addStyleName("video-js-fullscreen");
        }
        videoElement.getElement().setAttribute("controls", "");
        this.panorama = mimeType.isPanorama();
        if (this.panorama) {
            videoElement.getElement().setAttribute("crossorigin", "anonymous");
        }
        if (mimeType.isFlippedPanorama()) {
            videoElement.addStyleName(this.style.invertedVideoPlayer());
        }
        if (this.isAttached()) {
            this.prepareDependencies();
        }
        String type = null;
        if (mimeType.mediaSubType == MediaSubType.youtube) {
            type = "video/youtube";
            this.controls = false;
        } else if (mimeType.mediaSubType == MediaSubType.vimeo) {
            type = "video/vimeo";
        } else if (mimeType.mediaSubType == MediaSubType.mp4) {
            type = "video/mp4";
        } else if (mimeType == MimeType.mp3) {
            type = "audio/mp3";
        }
        if (type != null) {
            SourceElement se = Document.get().createSourceElement();
            se.setSrc(source);
            se.setType(type);
            videoElement.getElement().appendChild((Node)se);
        }
    }

    protected void onLoad() {
        super.onLoad();
        if (this.elementId != null) {
            this.prepareDependencies();
        }
    }

    protected void onDetach() {
        super.onDetach();
        this.resizeChecker.cancel();
    }

    private native void setupPlayer(String var1, boolean var2, boolean var3, String var4);

    private native void disposeNative();

    private native void handleResize();

    private native void setControls(boolean var1);

    private void prepareDependencies() {
        Command setupPlayerCommand = () -> {
            this.setupPlayer(this.elementId, this.autoplay, this.panorama, StringMessages.INSTANCE.threeSixtyVideoHint());
            this.resizeChecker.scheduleRepeating(250);
        };
        if (this.panorama) {
            2 callback = new /* Unavailable Anonymous Inner Class!! */;
            ScriptInjector.fromUrl((String)"js/three.js").setWindow(ScriptInjector.TOP_WINDOW).setCallback((Callback)callback).inject();
        } else {
            setupPlayerCommand.execute();
        }
    }

    public int getDuration() {
        if (this.player == null) {
            return 0;
        }
        return this.getNativeDuration();
    }

    private native int getNativeDuration();

    public int getCurrentTime() {
        if (this.player == null) {
            return 0;
        }
        return this.getNativeCurrentTime();
    }

    private native int getNativeCurrentTime();

    public void setCurrentTime(int currentTime) {
        if (this.player == null) {
            return;
        }
        this.setNativeCurrentTime(currentTime);
    }

    private native void setNativeCurrentTime(int var1);

    public void play() {
        if (this.player == null) {
            this.autoplay = true;
        } else {
            this.nativePlay();
            this.setControls(this.controls);
        }
    }

    private native void nativePlay();

    public native boolean isFullscreen();

    public native boolean paused();

    private void onPlay() {
        this.fireEvent((GwtEvent)new PlayEvent());
    }

    private void onPause() {
        this.fireEvent((GwtEvent)new PauseEvent());
    }

    public native void pause();

    public int getVideoWidth() {
        return -1;
    }

    public int getVideoHeight() {
        return -1;
    }

    public void setMuted(boolean muted) {
        if (muted) {
            this.setVolume(0.0f);
        } else {
            this.setVolume(1.0f);
        }
    }

    public void setVolume(float volume) {
        if (this.player != null) {
            this.setVolumeNative(volume);
        }
    }

    private native void setVolumeNative(float var1);

    public void setPlaybackRate(double newPlaySpeedFactor) {
    }

    public void setControlsVisible(boolean isVisible) {
        this.setControls(isVisible);
    }

    public void onResize() {
        if (this.player != null) {
            this.handleResize();
        }
    }

    public void disposeIf2D() {
        if (!this.panorama && this.player != null) {
            this.disposeNative();
            this.player = null;
        }
    }
}

