/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.AbstractMediaSelectionControl;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManager;
import java.util.ArrayList;

public class MediaSingleSelectionControl
extends AbstractMediaSelectionControl
implements CloseHandler<PopupPanel> {
    private final DialogBox dialogControl;
    private final UIObject popupLocation;

    public MediaSingleSelectionControl(MediaPlayerManager mediaPlayerManager, UIObject popupLocation, StringMessages stringMessages) {
        super(mediaPlayerManager, stringMessages);
        this.popupLocation = popupLocation;
        this.dialogControl = new DialogBox(true, false);
        this.dialogControl.addStyleName("Media-Select-Popup");
        this.dialogControl.setText(stringMessages.selectMedia());
        this.dialogControl.addCloseHandler((CloseHandler)this);
    }

    public void show() {
        ArrayList mediaTracks = new ArrayList(this.mediaPlayerManager.getAssignedMediaTracks());
        VerticalPanel mediaPanel = new VerticalPanel();
        mediaTracks.forEach(arg_0 -> this.lambda$0((Panel)mediaPanel, arg_0));
        this.dialogControl.add((Widget)mediaPanel);
        this.dialogControl.showRelativeTo(this.popupLocation);
    }

    private Button createMediaEntry(MediaTrackWithSecurityDTO mediaTrack) {
        Button mediaSelectButton = new Button(String.valueOf(this.mediaPlayerManager.getMediaTrackStatus((MediaTrack)mediaTrack).toString()) + " " + mediaTrack.title);
        mediaSelectButton.setStyleName("Media-Select-Button");
        if (this.mediaPlayerManager.getPlayingAudioTrack().contains(mediaTrack) || this.mediaPlayerManager.getPlayingVideoTracks().contains(mediaTrack)) {
            mediaSelectButton.setTitle(this.stringMessages.mediaHideVideoTooltip());
            mediaSelectButton.addStyleName("Media-Select-Button-playing");
            mediaSelectButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            mediaSelectButton.setTitle(this.stringMessages.mediaShowVideoTooltip(mediaTrack.title));
            mediaSelectButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return mediaSelectButton;
    }

    public void onClose(CloseEvent<PopupPanel> arg0) {
        this.dialogControl.clear();
    }

    public boolean isShowing() {
        return this.dialogControl.isShowing();
    }

    public void hide() {
        this.dialogControl.hide(false);
    }

    protected void updateUi() {
    }

    private /* synthetic */ void lambda$0(Panel panel, MediaTrackWithSecurityDTO track) {
        panel.add((Widget)this.createMediaEntry(track));
    }
}

