/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class WindIndicator
extends Composite {
    private static final int CIRCLE_RADIUS_RATIO = 12;
    private static final double STROKE_LENGTH_RATIO = 2.2;
    private static final double RATIO_OF_STROKE_TO_USE_FOR_TICKS = 0.7;
    private static final double TICK_LENGTH_RATIO = 15.0;
    private static final String RGB_WHITE = "rgb(255,255,255)";
    private static final String RGB_BLACK = "rgb(0,0,0)";
    private static final int MAX_NUMBER_OF_TICKS = 6;
    private Canvas canvas;
    private SpeedWithBearing windFrom = new KnotSpeedWithBearingImpl(0.0, (Bearing)new DegreeBearingImpl(0.0));
    private double cloudCoverage = 0.0;

    public WindIndicator() {
        this.canvas = Canvas.createIfSupported();
        this.initWidget((Widget)this.canvas);
        this.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.setSize("75px", "75px");
    }

    public void setWindFrom(SpeedWithBearing windFrom) {
        this.windFrom = windFrom;
        this.updateRendering();
    }

    public double getFromDeg() {
        return this.windFrom.getBearing().getDegrees();
    }

    public void setCloudCoverage(double cloudCoverage) {
        this.cloudCoverage = cloudCoverage;
        this.updateRendering();
    }

    public double getCloudCoverage() {
        return this.cloudCoverage;
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
        this.canvas.setSize(width, height);
    }

    private void updateRendering() {
        int minSize = Math.min(this.canvas.getCoordinateSpaceWidth(), this.canvas.getCoordinateSpaceHeight());
        this.canvas.setCoordinateSpaceWidth(minSize);
        this.canvas.setCoordinateSpaceHeight(minSize);
        Context2d ctx = this.canvas.getContext2d();
        ctx.setLineWidth(2.0);
        ctx.setLineCap(Context2d.LineCap.SQUARE);
        ctx.beginPath();
        ctx.moveTo((double)(minSize / 2), (double)(minSize / 2));
        double dirRad = this.windFrom.getBearing().getRadians();
        double strokeTipX = (double)(minSize / 2) + (double)minSize / 2.2 * Math.cos(dirRad);
        double strokeTipY = (double)(minSize / 2) + (double)minSize / 2.2 * Math.sin(dirRad);
        ctx.lineTo(strokeTipX, strokeTipY);
        ctx.stroke();
        int i = 0;
        while (i < 6) {
            this.drawTick(ctx, i, dirRad);
            ++i;
        }
        ctx.moveTo((double)(minSize / 2), (double)(minSize / 2));
        ctx.setFillStyle(RGB_WHITE);
        ctx.setStrokeStyle(RGB_BLACK);
        ctx.arc((double)(minSize / 2), (double)(minSize / 2), (double)(minSize / 12), 0.0, Math.PI * 2, true);
        ctx.stroke();
        ctx.fill();
        ctx.setFillStyle(RGB_BLACK);
        ctx.beginPath();
        ctx.moveTo((double)(minSize / 2), (double)(minSize / 2));
        double cc = Math.max(0.0, Math.min(1.0, this.cloudCoverage));
        ctx.arc((double)(minSize / 2), (double)(minSize / 2), (double)(minSize / 12), -1.5707963267948966, (-0.5 + cc * 2.0) * Math.PI, false);
        ctx.fill();
        this.setTitle();
    }

    private void setTitle() {
        int speedInKnotsTimes10 = (int)(this.windFrom.getKnots() * 10.0);
        int forceTimes10 = (int)(this.windFrom.getBeaufort() * 10.0);
        int intFromDeg = (int)this.getFromDeg();
        this.setTitle(speedInKnotsTimes10 / 10 + "." + speedInKnotsTimes10 % 10 + "kts (" + forceTimes10 / 10 + "." + forceTimes10 % 10 + "bft) from " + (intFromDeg < 10 ? "00" : (intFromDeg < 100 ? "0" : "")) + intFromDeg + " deg");
    }

    private void drawTick(Context2d ctx, int i, double dirRad) {
        if (this.hasTick(i)) {
            double[] tickStart = this.getTickStart(i, dirRad);
            ctx.moveTo(tickStart[0], tickStart[1]);
            double[] tickOffset = this.getTickOffset(i, dirRad);
            ctx.lineTo(tickStart[0] + tickOffset[0], tickStart[1] + tickOffset[1]);
            ctx.stroke();
        }
    }

    private double[] getTickOffset(int i, double dirRad) {
        double dirRadPlus90Deg = dirRad + 1.5707963267948966;
        int minSize = Math.min(this.canvas.getCoordinateSpaceWidth(), this.canvas.getCoordinateSpaceHeight());
        double singleLength = (double)minSize / 15.0;
        int zeroOneOrTwo = this.getTickLength(i);
        double length = singleLength * (double)zeroOneOrTwo;
        return new double[]{length * Math.cos(dirRadPlus90Deg), length * Math.sin(dirRadPlus90Deg)};
    }

    private int getTickLength(int i) {
        int bft = (int)(this.windFrom.getBeaufort() + 0.5);
        int zeroOneOrTwo = bft == 1 ? (i == 1 ? 1 : 0) : (2 * (i + 1) <= bft ? 2 : (2 * i + 1 == bft ? 1 : 0));
        return zeroOneOrTwo;
    }

    private double[] getTickStart(int i, double dirRad) {
        double minSize = Math.min(this.canvas.getCoordinateSpaceWidth(), this.canvas.getCoordinateSpaceHeight());
        double radius = minSize / 2.2 - (double)i * minSize / 2.2 * 0.7 / 6.0;
        double tickStartX = minSize / 2.0 + radius * Math.cos(dirRad);
        double tickStartY = minSize / 2.0 + radius * Math.sin(dirRad);
        return new double[]{tickStartX, tickStartY};
    }

    private boolean hasTick(int i) {
        return this.getTickLength(i) > 0;
    }

    static /* synthetic */ void access$0(WindIndicator windIndicator) {
        windIndicator.updateRendering();
    }
}

