/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.actions.GetRaceTimesInfoAction;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RaceTimesInfoProvider {
    private final SailingServiceAsync sailingService;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final ErrorReporter errorReporter;
    private final Set<RegattaAndRaceIdentifier> raceIdentifiers;
    private long requestIntervalInMillis;
    private final HashMap<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfos;
    private final Set<RaceTimesInfoProviderListener> listeners;
    private boolean terminated = false;
    private boolean requestTags = false;
    private Map<RegattaAndRaceIdentifier, TimePoint> latestReceivedTagTimes;

    public RaceTimesInfoProvider(SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter, Collection<RegattaAndRaceIdentifier> raceIdentifiers, long requestIntervalInMillis) {
        this.sailingService = sailingService;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.errorReporter = errorReporter;
        this.raceIdentifiers = new HashSet<RegattaAndRaceIdentifier>(raceIdentifiers);
        this.requestIntervalInMillis = requestIntervalInMillis;
        this.raceTimesInfos = new HashMap();
        this.listeners = new HashSet();
        this.latestReceivedTagTimes = new HashMap();
        1 command = new /* Unavailable Anonymous Inner Class!! */;
        command.execute();
    }

    public Set<RegattaAndRaceIdentifier> getRaceIdentifiers() {
        return Collections.unmodifiableSet(this.raceIdentifiers);
    }

    public void addRaceIdentifier(RegattaAndRaceIdentifier raceIdentifier, boolean forceTimesInfoRequest) {
        this.raceIdentifiers.add(raceIdentifier);
        if (forceTimesInfoRequest) {
            long clientTimeWhenRequestWasSent = System.currentTimeMillis();
            2 callback = new /* Unavailable Anonymous Inner Class!! */;
            if (this.requestTags) {
                this.sailingService.getRaceTimesInfoIncludingTags(raceIdentifier, (TimePoint)this.latestReceivedTagTimes.get(raceIdentifier), (AsyncCallback)callback);
            } else {
                this.sailingService.getRaceTimesInfo(raceIdentifier, (AsyncCallback)callback);
            }
        }
    }

    private void readTimesInfos() {
        if (!this.raceIdentifiers.isEmpty()) {
            long clientTimeWhenRequestWasSent = System.currentTimeMillis();
            GetRaceTimesInfoAction getRaceTimesInfoAction = this.requestTags ? new GetRaceTimesInfoAction(this.sailingService, (Collection)this.raceIdentifiers, this.latestReceivedTagTimes) : new GetRaceTimesInfoAction(this.sailingService, (Collection)this.raceIdentifiers);
            this.asyncActionsExecutor.execute((AsyncAction)getRaceTimesInfoAction, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void removeRaceIdentifier(RaceIdentifier raceIdentifier) {
        this.raceIdentifiers.remove(raceIdentifier);
        this.raceTimesInfos.remove(raceIdentifier);
    }

    public boolean containsRaceIdentifier(RaceIdentifier raceIdentifier) {
        return this.raceIdentifiers.contains(raceIdentifier);
    }

    public void clearRaceIdentifiers() {
        this.raceIdentifiers.clear();
        this.raceTimesInfos.clear();
    }

    public long getRequestInterval() {
        return this.requestIntervalInMillis;
    }

    public void setRequestInterval(long requestInterval) {
        this.requestIntervalInMillis = requestInterval;
    }

    public Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> getRaceTimesInfos() {
        return Collections.unmodifiableMap(this.raceTimesInfos);
    }

    public RaceTimesInfoDTO getRaceTimesInfo(RegattaAndRaceIdentifier raceIdentifier) {
        return (RaceTimesInfoDTO)this.raceTimesInfos.get(raceIdentifier);
    }

    public void addRaceTimesInfoProviderListener(RaceTimesInfoProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeRaceTimesInfoProviderListener(RaceTimesInfoProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void forceTimesInfosUpdate() {
        this.readTimesInfos();
    }

    public RegattaAndRaceIdentifier getFirstStartedAndUnfinishedRace(LeaderboardDTO leaderboard) {
        RegattaAndRaceIdentifier firstStartedAndUnfinishedRace = null;
        Map raceTimesInfos = this.getRaceTimesInfos();
        block0: for (RaceColumnDTO race : leaderboard.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                RaceTimesInfoDTO raceTimes;
                RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                if (raceIdentifier == null || (raceTimes = (RaceTimesInfoDTO)raceTimesInfos.get(raceIdentifier)) == null || raceTimes.startOfTracking == null || raceTimes.endOfRace != null) continue;
                firstStartedAndUnfinishedRace = raceIdentifier;
                continue block0;
            }
        }
        return firstStartedAndUnfinishedRace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RaceTimesInfoProviderListener> getListeners() {
        Set set = this.listeners;
        synchronized (set) {
            return new HashSet<RaceTimesInfoProviderListener>(this.listeners);
        }
    }

    private void notifyListeners(long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        for (RaceTimesInfoProviderListener listener : this.getListeners()) {
            listener.raceTimesInfosReceived(this.getRaceTimesInfos(), clientTimeWhenRequestWasSent, serverTimeDuringRequest, clientTimeWhenResponseWasReceived);
        }
    }

    public void terminate() {
        this.terminated = true;
        this.listeners.clear();
        this.raceIdentifiers.clear();
        this.raceTimesInfos.clear();
    }

    public TimePoint getLatestReceivedTagTime(RegattaAndRaceIdentifier raceIdentifier) {
        return (TimePoint)this.latestReceivedTagTimes.get(raceIdentifier);
    }

    public void setLatestReceivedTagTime(RegattaAndRaceIdentifier raceIdentifier, TimePoint latestReceivedTagTime) {
        this.latestReceivedTagTimes.put(raceIdentifier, latestReceivedTagTime);
    }

    public void enableTagRequests() {
        this.requestTags = true;
    }

    public void disableTagRequests() {
        this.requestTags = false;
    }

    static /* synthetic */ boolean access$0(RaceTimesInfoProvider raceTimesInfoProvider) {
        return raceTimesInfoProvider.terminated;
    }

    static /* synthetic */ void access$1(RaceTimesInfoProvider raceTimesInfoProvider) {
        raceTimesInfoProvider.readTimesInfos();
    }

    static /* synthetic */ long access$2(RaceTimesInfoProvider raceTimesInfoProvider) {
        return raceTimesInfoProvider.requestIntervalInMillis;
    }

    static /* synthetic */ ErrorReporter access$3(RaceTimesInfoProvider raceTimesInfoProvider) {
        return raceTimesInfoProvider.errorReporter;
    }

    static /* synthetic */ HashMap access$4(RaceTimesInfoProvider raceTimesInfoProvider) {
        return raceTimesInfoProvider.raceTimesInfos;
    }

    static /* synthetic */ void access$5(RaceTimesInfoProvider raceTimesInfoProvider, long l, Date date, long l2) {
        raceTimesInfoProvider.notifyListeners(l, date, l2);
    }
}

