/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.SwissTimingReplayConnectorPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.swisstiming.SwissTimingArchivedConnectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.swisstiming.SwissTimingArchivedConnectionTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingArchiveConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingReplayRaceDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class SwissTimingReplayConnectorPanel
extends AbstractEventManagementPanel
implements FilterablePanelProvider<SwissTimingArchiveConfigurationWithSecurityDTO> {
    private final ErrorReporter errorReporter;
    private final LabeledAbstractFilterablePanel<SwissTimingReplayRaceDTO> filterablePanelEvents;
    private final ListDataProvider<SwissTimingReplayRaceDTO> raceList;
    private final CellTable<SwissTimingReplayRaceDTO> raceTable;
    private final List<SwissTimingReplayRaceDTO> availableSwissTimingRaces;
    private final SwissTimingArchivedConnectionTableWrapper connectionsTable;

    public SwissTimingReplayConnectorPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages, CellTableWithCheckboxResources tableResources) {
        super(presenter, true, stringMessages);
        this.errorReporter = presenter.getErrorReporter();
        this.availableSwissTimingRaces = new ArrayList();
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        CaptionPanel captionPanelConnections = new CaptionPanel(stringMessages.connections());
        mainPanel.add((Widget)captionPanelConnections);
        VerticalPanel verticalPanel = new VerticalPanel();
        captionPanelConnections.setContentWidget((Widget)verticalPanel);
        captionPanelConnections.setStyleName("bold");
        this.connectionsTable = new SwissTimingArchivedConnectionTableWrapper(presenter.getUserService(), this.sailingServiceWrite, stringMessages, this.errorReporter, true, tableResources, () -> {});
        this.connectionsTable.refreshConnectionList();
        AccessControlledButtonPanel buttonPanel = this.createButtonPanel(this.sailingServiceWrite, presenter.getUserService(), this.errorReporter, stringMessages);
        verticalPanel.add((Widget)buttonPanel);
        verticalPanel.add((IsWidget)this.connectionsTable);
        2 regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        3 raceNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        4 raceStartTrackingColumn = new /* Unavailable Anonymous Inner Class!! */;
        5 boatClassNamesColumn = new /* Unavailable Anonymous Inner Class!! */;
        HorizontalPanel racesSplitPanel = new HorizontalPanel();
        mainPanel.add((Widget)racesSplitPanel);
        CaptionPanel racesCaptionPanel = new CaptionPanel(stringMessages.trackableRaces());
        racesSplitPanel.add((Widget)racesCaptionPanel);
        racesCaptionPanel.setWidth("50%");
        CaptionPanel trackedRacesCaptionPanel = new CaptionPanel(stringMessages.trackedRaces());
        racesSplitPanel.add((Widget)trackedRacesCaptionPanel);
        trackedRacesCaptionPanel.setWidth("50%");
        VerticalPanel racesPanel = new VerticalPanel();
        racesCaptionPanel.setContentWidget((Widget)racesPanel);
        racesCaptionPanel.setStyleName("bold");
        VerticalPanel trackedRacesPanel = new VerticalPanel();
        trackedRacesPanel.setWidth("100%");
        trackedRacesCaptionPanel.setContentWidget((Widget)trackedRacesPanel);
        trackedRacesCaptionPanel.setStyleName("bold");
        HorizontalPanel regattaPanel = new HorizontalPanel();
        racesPanel.add((Widget)regattaPanel);
        Label lblRegattas = new Label(stringMessages.regattaUsedForTheTrackedRace());
        lblRegattas.setWordWrap(false);
        regattaPanel.setCellVerticalAlignment((Widget)lblRegattas, HasVerticalAlignment.ALIGN_MIDDLE);
        regattaPanel.setSpacing(5);
        regattaPanel.add((Widget)lblRegattas);
        regattaPanel.add((Widget)this.getAvailableRegattasListBox());
        regattaPanel.setCellVerticalAlignment((Widget)this.getAvailableRegattasListBox(), HasVerticalAlignment.ALIGN_MIDDLE);
        HorizontalPanel filterPanel = new HorizontalPanel();
        filterPanel.setSpacing(5);
        racesPanel.add((Widget)filterPanel);
        Label lblFilterEvents = new Label(String.valueOf(stringMessages.filterRaces()) + ":");
        filterPanel.add((Widget)lblFilterEvents);
        filterPanel.setCellVerticalAlignment((Widget)lblFilterEvents, HasVerticalAlignment.ALIGN_MIDDLE);
        HorizontalPanel racesHorizontalPanel = new HorizontalPanel();
        racesPanel.add((Widget)racesHorizontalPanel);
        VerticalPanel trackPanel = new VerticalPanel();
        trackPanel.setStyleName("paddedPanel");
        raceNameColumn.setSortable(true);
        raceStartTrackingColumn.setSortable(true);
        boatClassNamesColumn.setSortable(true);
        AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.raceTable = new BaseCelltable(10000, (CellTable.Resources)tableRes);
        this.raceTable.addColumn((Column)raceNameColumn, stringMessages.race());
        this.raceTable.addColumn((Column)regattaNameColumn, "RSC");
        this.raceTable.addColumn((Column)boatClassNamesColumn, stringMessages.boatClass());
        this.raceTable.addColumn((Column)raceStartTrackingColumn, stringMessages.startTime());
        this.raceTable.setWidth("300px");
        this.raceList = new ListDataProvider();
        this.filterablePanelEvents = new /* Unavailable Anonymous Inner Class!! */;
        this.raceTable.setSelectionModel((SelectionModel)new /* Unavailable Anonymous Inner Class!! */);
        racesHorizontalPanel.add((Widget)this.raceTable);
        racesHorizontalPanel.add((Widget)trackPanel);
        this.raceList.addDataDisplay((HasData)this.raceTable);
        ColumnSortEvent.ListHandler columnSortHandler = this.getRaceTableColumnSortHandler(this.raceList.getList(), (Column)raceNameColumn, (Column)boatClassNamesColumn, (Column)raceStartTrackingColumn);
        this.raceTable.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        filterPanel.add((Widget)this.filterablePanelEvents);
        Label lblTrackSettings = new Label(stringMessages.trackNewEvent());
        trackPanel.add((Widget)lblTrackSettings);
        CheckBox trackWindCheckbox = new CheckBox(stringMessages.trackWind());
        trackWindCheckbox.setWordWrap(false);
        trackWindCheckbox.setValue(Boolean.valueOf(true));
        trackPanel.add((Widget)trackWindCheckbox);
        CheckBox declinationCheckbox = new CheckBox(stringMessages.declinationCheckbox());
        declinationCheckbox.setWordWrap(false);
        declinationCheckbox.setValue(Boolean.valueOf(true));
        trackPanel.add((Widget)declinationCheckbox);
        CheckBox useInternalMarkPassingAlgorithmCheckbox = new CheckBox(stringMessages.useInternalAlgorithm());
        useInternalMarkPassingAlgorithmCheckbox.setWordWrap(false);
        useInternalMarkPassingAlgorithmCheckbox.setValue(Boolean.FALSE);
        trackPanel.add((Widget)useInternalMarkPassingAlgorithmCheckbox);
        trackedRacesPanel.add((Widget)this.trackedRacesListComposite);
        HorizontalPanel racesButtonPanel = new HorizontalPanel();
        racesPanel.add((Widget)racesButtonPanel);
        Button btnTrack = new Button(stringMessages.startTracking());
        racesButtonPanel.add((Widget)btnTrack);
        racesButtonPanel.setSpacing(10);
        btnTrack.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnTrack.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> btnTrack.setEnabled(((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1));
    }

    private AccessControlledButtonPanel createButtonPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, ErrorReporter errorReporter, StringMessages stringMessages) {
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.SWISS_TIMING_ARCHIVE_ACCOUNT);
        buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.connectionsTable.refreshConnectionList());
        buttonPanel.addCreateAction(stringMessages.addSwissTimingAchivedConnection(), () -> new SwissTimingArchivedConnectionDialog((DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, userService, errorReporter).show());
        buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.connectionsTable.getSelectionModel(), false, () -> sailingServiceWrite.deleteSwissTimingArchiveConfigurations((Collection)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        Button listRacesButton = buttonPanel.addUnsecuredAction(stringMessages.listRaces(), () -> this.fillRaces((SailingServiceAsync)sailingServiceWrite));
        listRacesButton.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> {
            boolean objectSelected = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1;
            listRacesButton.setEnabled(objectSelected);
        });
        return buttonPanel;
    }

    private String getBoatClassNamesAsString(SwissTimingReplayRaceDTO object) {
        return object.boat_class;
    }

    private ColumnSortEvent.ListHandler<SwissTimingReplayRaceDTO> getRaceTableColumnSortHandler(List<SwissTimingReplayRaceDTO> raceRecords, Column<SwissTimingReplayRaceDTO, ?> nameColumn, Column<SwissTimingReplayRaceDTO, ?> boatClassColumn, Column<SwissTimingReplayRaceDTO, ?> startTimeColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(raceRecords);
        result.setComparator(nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(startTimeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void fillRaces(SailingServiceAsync sailingService) {
        Set selectedObjects = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet();
        if (selectedObjects.size() == 1) {
            SwissTimingArchiveConfigurationWithSecurityDTO selectedObject = (SwissTimingArchiveConfigurationWithSecurityDTO)selectedObjects.iterator().next();
            sailingService.listSwissTiminigReplayRaces(selectedObject.getJsonUrl(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void trackSelectedRaces(boolean trackWind, boolean correctWindByDeclination, boolean useInternalMarkPassingAlgorithm) {
        RegattaDTO selectedRegatta = this.getSelectedRegatta();
        RegattaName regattaIdentifier = null;
        if (selectedRegatta != null) {
            regattaIdentifier = new RegattaName(selectedRegatta.getName());
        }
        ArrayList<SwissTimingReplayRaceDTO> selectedRaces = new ArrayList<SwissTimingReplayRaceDTO>();
        for (SwissTimingReplayRaceDTO replayRace : this.raceList.getList()) {
            if (!this.raceTable.getSelectionModel().isSelected((Object)replayRace)) continue;
            selectedRaces.add(replayRace);
        }
        if (this.checkBoatClassOK(selectedRegatta, selectedRaces)) {
            this.sailingServiceWrite.replaySwissTimingRace((RegattaIdentifier)regattaIdentifier, selectedRaces, trackWind, correctWindByDeclination, useInternalMarkPassingAlgorithm, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public AbstractFilterablePanel<SwissTimingArchiveConfigurationWithSecurityDTO> getFilterablePanel() {
        return this.connectionsTable.getFilterField();
    }

    static /* synthetic */ SwissTimingArchivedConnectionTableWrapper access$0(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.connectionsTable;
    }

    static /* synthetic */ DateTimeFormatRenderer access$1(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.dateFormatter;
    }

    static /* synthetic */ DateTimeFormatRenderer access$2(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.timeFormatter;
    }

    static /* synthetic */ CellTable access$3(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.raceTable;
    }

    static /* synthetic */ void access$4(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel, boolean bl, boolean bl2, boolean bl3) {
        swissTimingReplayConnectorPanel.trackSelectedRaces(bl, bl2, bl3);
    }

    static /* synthetic */ String access$5(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel, SwissTimingReplayRaceDTO swissTimingReplayRaceDTO) {
        return swissTimingReplayConnectorPanel.getBoatClassNamesAsString(swissTimingReplayRaceDTO);
    }

    static /* synthetic */ ErrorReporter access$6(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.errorReporter;
    }

    static /* synthetic */ List access$7(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.availableSwissTimingRaces;
    }

    static /* synthetic */ ListDataProvider access$8(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.raceList;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$9(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.filterablePanelEvents;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$10(SwissTimingReplayConnectorPanel swissTimingReplayConnectorPanel) {
        return swissTimingReplayConnectorPanel.presenter;
    }
}

