/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.SailingServerCreateOrEditDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class SailingServerCreateOrEditDialog
extends DataEntryDialog<RemoteSailingServerReferenceDTO> {
    private StringMessages stringConstants;
    private TextBox nameTextBox;
    private TextBox urlTextBox;

    public SailingServerCreateOrEditDialog(Iterable<RemoteSailingServerReferenceDTO> existingSailingServers, StringMessages stringConstants, DataEntryDialog.DialogCallback<RemoteSailingServerReferenceDTO> callback) {
        this(existingSailingServers, null, false, stringConstants, callback);
    }

    public SailingServerCreateOrEditDialog(Iterable<RemoteSailingServerReferenceDTO> existingSailingServers, RemoteSailingServerReferenceDTO serverToEdit, StringMessages stringConstants, DataEntryDialog.DialogCallback<RemoteSailingServerReferenceDTO> callback) {
        this(existingSailingServers, serverToEdit, true, stringConstants, callback);
    }

    private SailingServerCreateOrEditDialog(Iterable<RemoteSailingServerReferenceDTO> existingSailingServers, RemoteSailingServerReferenceDTO serverToEdit, boolean isEditMode, StringMessages stringConstants, DataEntryDialog.DialogCallback<RemoteSailingServerReferenceDTO> callback) {
        super("Sailing Server", null, stringConstants.ok(), stringConstants.cancel(), (DataEntryDialog.Validator)new SailingServerValidator(stringConstants, existingSailingServers), callback);
        this.stringConstants = stringConstants;
        this.nameTextBox = this.createTextBox(isEditMode ? serverToEdit.getName() : null);
        this.nameTextBox.setVisibleLength(50);
        this.urlTextBox = this.createTextBox(isEditMode ? serverToEdit.getUrl() : null);
        this.urlTextBox.setVisibleLength(100);
        this.nameTextBox.setEnabled(!isEditMode);
    }

    protected RemoteSailingServerReferenceDTO getResult() {
        return new RemoteSailingServerReferenceDTO(this.nameTextBox.getText(), this.urlTextBox.getText());
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        Grid formGrid = new Grid(2, 2);
        panel.add((Widget)formGrid);
        formGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringConstants.name()) + ":"));
        formGrid.setWidget(0, 1, (Widget)this.nameTextBox);
        formGrid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringConstants.url()) + ":"));
        formGrid.setWidget(1, 1, (Widget)this.urlTextBox);
        return panel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameTextBox;
    }
}

