/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.sap.sailing.gwt.ui.adminconsole.DeviceMappingTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogTrackingDeviceMappingsImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogImportFixesAndAddMappingsDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogImportSensorDataAndAddMappingsDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.AxisTitle;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Global;
import org.moxieapps.gwt.highcharts.client.Highcharts;
import org.moxieapps.gwt.highcharts.client.Legend;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.ToolTipFormatter;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.events.PointMouseOverEventHandler;
import org.moxieapps.gwt.highcharts.client.plotOptions.SeriesPlotOptions;

public class RegattaLogTrackingDeviceMappingsDialog
extends DataEntryDialog<Void> {
    private static final int HOURS_TO_EXPAND_FOR_OPEN_END = 2;
    protected final String leaderboardName;
    public static final double PERCENTAGE_OF_TIMESPAN_TO_EXTEND_OPEN_ENDS = 0.1;
    public static final String FIELD_INDEX = "index";
    public static final int CHART_WIDTH = 500;
    public static final String SERIES_COLOR = "#fcb913";
    private final ErrorReporter errorReporter;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final StringMessages stringMessages;
    private List<DeviceMappingDTO> mappings = new ArrayList();
    private DeviceMappingTableWrapper deviceMappingTable;
    private LabeledAbstractFilterablePanel<DeviceMappingDTO> filterField;
    private CheckBox showPingMappingsCb;
    private BusyIndicator busyIndicator;
    private Point[] data;
    private Date latest;
    private Date earliest;
    private Chart chart;
    private String regattaRegistrationSecret;

    public RegattaLogTrackingDeviceMappingsDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, String leaderboardName, String regattaRegistrationSecret, DataEntryDialog.DialogCallback<Void> callback) {
        super(stringMessages.mapDevices(), null, stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.ensureDebugId("regattaLogTrackingDeviceMappingsDialog");
        this.stringMessages = stringMessages;
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.errorReporter = errorReporter;
        this.regattaRegistrationSecret = regattaRegistrationSecret;
        this.leaderboardName = leaderboardName;
        this.busyIndicator = new SimpleBusyIndicator();
        this.refresh();
    }

    protected Widget getAdditionalWidget() {
        FlowPanel mainPanel = new FlowPanel();
        HorizontalPanel buttonPanel = new HorizontalPanel();
        Button addMappingButton = new Button(this.stringMessages.add());
        addMappingButton.ensureDebugId("addMappingButton");
        addMappingButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)addMappingButton);
        Button importBtn = new Button(this.stringMessages.importFixes());
        importBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)importBtn);
        buttonPanel.add((Widget)new Button(this.stringMessages.importAdditionalSensorData(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        buttonPanel.add((Widget)this.busyIndicator);
        mainPanel.add((Widget)buttonPanel);
        this.deviceMappingTable = new DeviceMappingTableWrapper(this.sailingServiceWrite, this.stringMessages, this.errorReporter);
        this.deviceMappingTable.getTable().addCellPreviewHandler((CellPreviewEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        ImagesBarColumn actionCol = new ImagesBarColumn((ImagesBarCell)new RaceLogTrackingDeviceMappingsImagesBarCell(this.stringMessages));
        actionCol.setFieldUpdater(this.getActionColFieldUpdater());
        this.deviceMappingTable.getTable().addColumn((Column)actionCol, this.stringMessages.actions());
        HorizontalPanel deviceMappingPanel = new HorizontalPanel();
        mainPanel.add((Widget)deviceMappingPanel);
        this.chart = (Chart)((Chart)((Chart)((Chart)new Chart().setType(Series.Type.COLUMN_RANGE)).setChartTitleText(this.stringMessages.deviceMappings())).setLegend(new Legend().setEnabled(false))).setInverted(true);
        this.chart.setSeriesPlotOptions((SeriesPlotOptions)new SeriesPlotOptions().setPointMouseOverEventHandler((PointMouseOverEventHandler)new /* Unavailable Anonymous Inner Class!! */).setColor(SERIES_COLOR));
        Highcharts.setOptions((Highcharts.Options)new Highcharts.Options().setGlobal(new Global().setUseUTC(false)));
        ((XAxis)((XAxis)this.chart.getXAxis().setOption("labels/enabled", (Object)false)).setGridLineWidth((Number)0)).setMinorGridLineWidth((Number)0);
        ((YAxis)((YAxis)((YAxis)this.chart.getYAxis().setAxisTitle(new AxisTitle().setText(this.stringMessages.time()))).setType(Axis.Type.DATE_TIME)).setGridLineWidth((Number)0)).setMinorGridLineWidth((Number)0);
        this.chart.setWidth("500px");
        this.chart.setHeight("400px");
        this.chart.setToolTip(new ToolTip().setFormatter((ToolTipFormatter)new /* Unavailable Anonymous Inner Class!! */));
        deviceMappingPanel.add((Widget)this.chart);
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.filterField.addFilter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        this.deviceMappingTable.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        VerticalPanel vp = new VerticalPanel();
        deviceMappingPanel.add((Widget)vp);
        vp.add((Widget)this.filterField);
        this.showPingMappingsCb = new CheckBox(this.stringMessages.showPingMarkMappings());
        this.showPingMappingsCb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        vp.insert((Widget)this.showPingMappingsCb, 0);
        vp.add((IsWidget)this.deviceMappingTable);
        return mainPanel;
    }

    void updateChart() {
        this.earliest = null;
        this.latest = null;
        for (DeviceMappingDTO mapping : this.mappings) {
            this.updateExtremes(mapping);
        }
        this.data = new Point[this.mappings.size()];
        this.handleOpenEndedIntervalls();
        long earliestMillis = this.earliest.getTime();
        long latestMillis = this.latest.getTime();
        long range = latestMillis - earliestMillis;
        long extension = (long)((double)range * 0.1);
        long yMin = earliestMillis - extension;
        long yMax = latestMillis + extension;
        int i = 0;
        for (DeviceMappingDTO mapping : this.mappings) {
            JSONObject userData = new JSONObject();
            userData.put(FIELD_INDEX, (JSONValue)userData);
            long from = mapping.from == null ? yMin - range : mapping.from.getTime();
            long to = mapping.to == null ? yMax + range : mapping.to.getTime();
            this.data[i] = new Point((Number)i, (Number)from, (Number)to);
            ++i;
        }
        this.chart.removeAllSeries(false);
        this.chart.addSeries(this.chart.createSeries().setName(this.stringMessages.deviceMappings()).setPoints(this.data));
        this.chart.getYAxis().setExtremes((Number)yMin, (Number)yMax);
    }

    private void handleOpenEndedIntervalls() {
        if (this.earliest == null && this.latest == null) {
            this.earliest = new Date(0L);
            this.latest = new Date();
        } else if (this.earliest == null && this.latest != null) {
            this.earliest = new Date(this.latest.getTime() - 0x6DDD00L);
        } else if (this.latest == null && this.earliest != null) {
            this.latest = new Date(this.earliest.getTime() + 0x6DDD00L);
        }
    }

    private void updateExtremes(DeviceMappingDTO mapping) {
        if (mapping.from != null && (this.earliest == null || this.earliest.after(mapping.from))) {
            this.earliest = mapping.from;
        }
        if (mapping.to != null && (this.latest == null || this.latest.before(mapping.to))) {
            this.latest = mapping.to;
        }
    }

    private void addMapping() {
        this.showAddMappingDialog(null);
    }

    private void refresh() {
        this.busyIndicator.setBusy(true);
        this.sailingServiceWrite.getDeviceMappings(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showAddMappingDialog(DeviceMappingDTO mapping) {
        this.sailingServiceWrite.getMailType((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void importFixes() {
        new RegattaLogImportFixesAndAddMappingsDialog(this.sailingServiceWrite, this.userService, this.errorReporter, this.stringMessages, this.leaderboardName, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void importFoiling() {
        new RegattaLogImportSensorDataAndAddMappingsDialog(this.sailingServiceWrite, this.userService, this.errorReporter, this.stringMessages, this.leaderboardName, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private FieldUpdater<DeviceMappingDTO, String> getActionColFieldUpdater() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Void getResult() {
        return null;
    }

    static /* synthetic */ void access$1(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        regattaLogTrackingDeviceMappingsDialog.addMapping();
    }

    static /* synthetic */ void access$2(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        regattaLogTrackingDeviceMappingsDialog.importFixes();
    }

    static /* synthetic */ void access$3(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        regattaLogTrackingDeviceMappingsDialog.importFoiling();
    }

    static /* synthetic */ List access$4(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.mappings;
    }

    static /* synthetic */ Chart access$5(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.chart;
    }

    static /* synthetic */ DeviceMappingTableWrapper access$6(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.deviceMappingTable;
    }

    static /* synthetic */ StringMessages access$7(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.stringMessages;
    }

    static /* synthetic */ CheckBox access$8(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.showPingMappingsCb;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$9(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.filterField;
    }

    static /* synthetic */ BusyIndicator access$10(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.busyIndicator;
    }

    static /* synthetic */ void access$11(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog, List list) {
        regattaLogTrackingDeviceMappingsDialog.mappings = list;
    }

    static /* synthetic */ ErrorReporter access$12(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.errorReporter;
    }

    static /* synthetic */ SailingServiceWriteAsync access$13(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.sailingServiceWrite;
    }

    static /* synthetic */ UserService access$14(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.userService;
    }

    static /* synthetic */ String access$15(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        return regattaLogTrackingDeviceMappingsDialog.regattaRegistrationSecret;
    }

    static /* synthetic */ void access$16(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog) {
        regattaLogTrackingDeviceMappingsDialog.refresh();
    }

    static /* synthetic */ void access$17(RegattaLogTrackingDeviceMappingsDialog regattaLogTrackingDeviceMappingsDialog, DeviceMappingDTO deviceMappingDTO) {
        regattaLogTrackingDeviceMappingsDialog.showAddMappingDialog(deviceMappingDTO);
    }
}

