/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.gwt.ui.adminconsole.DeviceMappingQRCodeWidget;
import com.sap.sailing.gwt.ui.adminconsole.ItemToMapToDeviceSelectionPanel;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.GenericListBox;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.Date;

public class RegattaLogAddDeviceMappingDialog
extends DataEntryDialogWithDateTimeBox<DeviceMappingDTO> {
    private final String leaderboardName;
    private final GenericListBox<EventDTO> events;
    protected final DateAndTimeInput from;
    protected final DateAndTimeInput to;
    protected final ListBox deviceType;
    protected final TextBox deviceId;
    protected final DeviceMappingQRCodeWidget qrWidget;
    protected final StringMessages stringMessages;
    protected MappableToDevice selectedItem;
    protected final ItemToMapToDeviceSelectionPanel itemSelectionPanel;
    protected final SailingServiceAsync sailingService;
    protected Grid entryGrid;
    private String regattaRegisterSecret;

    public RegattaLogAddDeviceMappingDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, ErrorReporter errorReporter, StringMessages stringMessages, String leaderboardName, String regattaRegisterSecret, MailInvitationType mailInvitationType, DataEntryDialog.DialogCallback<DeviceMappingDTO> callback, DeviceMappingDTO mapping) {
        super(stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.ensureDebugId("RegattaLogAddDeviceMappingDialog");
        this.stringMessages = stringMessages;
        this.sailingService = sailingServiceWrite;
        this.regattaRegisterSecret = regattaRegisterSecret;
        this.from = this.createDateTimeBox(new Date(), DateTimeInput.Accuracy.SECONDS);
        this.from.setValue(null);
        this.to = this.createDateTimeBox(new Date(), DateTimeInput.Accuracy.SECONDS);
        this.to.setValue(null);
        this.deviceType = this.createListBox(false);
        sailingServiceWrite.getDeserializableDeviceIdentifierTypes((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.deviceId = this.createTextBox("");
        this.itemSelectionPanel = new ItemToMapToDeviceSelectionPanel(sailingServiceWrite, userService, stringMessages, errorReporter, (ItemToMapToDeviceSelectionPanel.SelectionChangedHandler)new /* Unavailable Anonymous Inner Class!! */, mapping != null ? mapping.mappedTo : null);
        if (mapping != null) {
            this.deviceId.setValue((Object)mapping.deviceIdentifier.deviceId);
            this.from.setValue(mapping.from);
            this.to.setValue(mapping.to);
        }
        this.qrWidget = this.setupQRCodeWidget(mailInvitationType);
        this.qrWidget.generateQRCode();
        this.leaderboardName = leaderboardName;
        this.loadCompetitorsBoatsAndMarks();
        this.events = new GenericListBox((GenericListBox.ValueBuilder)new /* Unavailable Anonymous Inner Class!! */);
        this.events.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        sailingServiceWrite.getEventsForLeaderboard(leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Widget getAdditionalWidget() {
        HorizontalPanel panel = new HorizontalPanel();
        VerticalPanel leftSidePanel = new VerticalPanel();
        this.entryGrid = new Grid(4, 2);
        CaptionPanel entryPanel = new CaptionPanel(this.stringMessages.mappingDetails());
        CaptionPanel qrPanel = new CaptionPanel(this.stringMessages.qrCode());
        this.entryGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.deviceType()));
        this.entryGrid.setWidget(0, 1, (Widget)this.deviceType);
        this.entryGrid.setWidget(1, 0, (Widget)new Label(this.stringMessages.deviceId()));
        this.entryGrid.setWidget(1, 1, (Widget)this.deviceId);
        this.entryGrid.setWidget(2, 0, (Widget)new Label(this.stringMessages.from()));
        this.entryGrid.setWidget(2, 1, (Widget)this.from);
        this.entryGrid.setWidget(3, 0, (Widget)new Label(this.stringMessages.to()));
        this.entryGrid.setWidget(3, 1, (Widget)this.to);
        VerticalPanel qrContentPanel = new VerticalPanel();
        Label explanation = new Label(this.stringMessages.deviceMappingQrCodeExplanation());
        explanation.setWidth("400px");
        qrContentPanel.add((Widget)explanation);
        qrContentPanel.add((IsWidget)this.qrWidget);
        panel.add((Widget)leftSidePanel);
        panel.add((IsWidget)this.itemSelectionPanel);
        leftSidePanel.add((Widget)entryPanel);
        leftSidePanel.add((Widget)qrPanel);
        entryPanel.setContentWidget((Widget)this.entryGrid);
        qrPanel.setContentWidget((Widget)qrContentPanel);
        this.entryGrid.insertRow(0);
        this.entryGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.event()));
        this.entryGrid.setWidget(0, 1, (Widget)this.events);
        return panel;
    }

    private DeviceMappingQRCodeWidget setupQRCodeWidget(MailInvitationType mailInvitationType) {
        return new DeviceMappingQRCodeWidget(this.stringMessages, (DeviceMappingQRCodeWidget.URLFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected DeviceMappingDTO getResult() {
        String deviceTypeS = this.deviceType.getSelectedIndex() < 0 ? null : this.deviceType.getValue(this.deviceType.getSelectedIndex());
        DeviceIdentifierDTO deviceIdentifier = new DeviceIdentifierDTO(deviceTypeS, this.deviceId.getValue());
        return new DeviceMappingDTO(deviceIdentifier, this.from.getValue(), this.to.getValue(), this.selectedItem, null);
    }

    private void loadCompetitorsBoatsAndMarks() {
        this.sailingService.getCompetitorRegistrationsForLeaderboard(this.leaderboardName, this.itemSelectionPanel.getSetCompetitorsCallback());
        this.sailingService.getBoatRegistrationsForLeaderboard(this.leaderboardName, this.itemSelectionPanel.getSetBoatsCallback());
        this.sailingService.getMarksInRegattaLog(this.leaderboardName, this.itemSelectionPanel.getSetMarksCallback());
    }

    static /* synthetic */ void access$1(RegattaLogAddDeviceMappingDialog regattaLogAddDeviceMappingDialog) {
        regattaLogAddDeviceMappingDialog.validateAndUpdate();
    }

    static /* synthetic */ GenericListBox access$2(RegattaLogAddDeviceMappingDialog regattaLogAddDeviceMappingDialog) {
        return regattaLogAddDeviceMappingDialog.events;
    }

    static /* synthetic */ String access$3(RegattaLogAddDeviceMappingDialog regattaLogAddDeviceMappingDialog) {
        return regattaLogAddDeviceMappingDialog.leaderboardName;
    }

    static /* synthetic */ String access$4(RegattaLogAddDeviceMappingDialog regattaLogAddDeviceMappingDialog) {
        return regattaLogAddDeviceMappingDialog.regattaRegisterSecret;
    }
}

