/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.adminconsole.BoatCertificateAssignmentDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.adminconsole.RegattaConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.RegattaListComposite;
import com.sap.sailing.gwt.ui.adminconsole.RegattaWithSeriesAndFleetsEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class RegattaListComposite
extends Composite {
    protected final ListDataProvider<RegattaDTO> regattaListDataProvider;
    protected final StringMessages stringMessages;
    private final CellTable<RegattaDTO> regattaTable;
    private final Label noRegattasLabel;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final RefreshableMultiSelectionModel<RegattaDTO> refreshableRegattaMultiSelectionModel;
    private final ErrorReporter errorReporter;
    private final AdminConsoleView.Presenter presenter;
    protected final LabeledAbstractFilterablePanel<RegattaDTO> filterablePanelRegattas;
    private final UserService userService;
    private List<RegattaDTO> allRegattas;
    protected static AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final Displayer<RegattaDTO> regattasDisplayer = new /* Unavailable Anonymous Inner Class!! */;

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public RegattaListComposite(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        RefreshableMultiSelectionModel selectionModel;
        this.sailingServiceWrite = presenter.getSailingService();
        this.presenter = presenter;
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.userService = presenter.getUserService();
        this.allRegattas = new ArrayList();
        VerticalPanel panel = new VerticalPanel();
        Label filterRegattasLabel = new Label(String.valueOf(stringMessages.filterRegattasByName()) + ":");
        filterRegattasLabel.setWordWrap(false);
        this.noRegattasLabel = new Label(stringMessages.noRegattasYet());
        this.noRegattasLabel.ensureDebugId("NoRegattasLabel");
        this.noRegattasLabel.setWordWrap(false);
        panel.add((Widget)this.noRegattasLabel);
        this.regattaListDataProvider = new ListDataProvider();
        this.filterablePanelRegattas = new /* Unavailable Anonymous Inner Class!! */;
        this.filterablePanelRegattas.getTextBox().ensureDebugId("RegattasFilterTextBox");
        this.regattaTable = this.createRegattaTable(this.userService);
        this.regattaTable.ensureDebugId("RegattasCellTable");
        this.refreshableRegattaMultiSelectionModel = selectionModel = (RefreshableMultiSelectionModel)this.regattaTable.getSelectionModel();
        this.regattaTable.setVisible(false);
        this.setUpdatePermissionFilter(this.userService);
        panel.add((Widget)this.filterablePanelRegattas);
        panel.add((Widget)this.regattaTable);
        this.initWidget((Widget)panel);
    }

    protected void setUpdatePermissionFilter(UserService userService) {
        this.filterablePanelRegattas.setUpdatePermissionFilterForCheckbox(regatta -> userService.hasPermission((SecuredDTO)regatta, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    public HandlerRegistration addSelectionChangeHandler(SelectionChangeEvent.Handler handler) {
        return this.refreshableRegattaMultiSelectionModel.addSelectionChangeHandler(handler);
    }

    protected CellTable<RegattaDTO> createRegattaTable(UserService userService) {
        FlushableCellTable table = new FlushableCellTable(10000, (CellTable.Resources)tableRes);
        this.regattaListDataProvider.addDataDisplay((HasData)table);
        table.setWidth("100%");
        SelectionCheckboxColumn regattaSelectionCheckboxColumn = new SelectionCheckboxColumn(tableRes.cellTableStyle().cellTableCheckboxSelected(), tableRes.cellTableStyle().cellTableCheckboxDeselected(), tableRes.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterablePanelRegattas.getAllListDataProvider(), (Flushable)table);
        ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(this.regattaListDataProvider.getList());
        table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        columnSortHandler.setComparator((Column)regattaSelectionCheckboxColumn, (Comparator)regattaSelectionCheckboxColumn.getComparator());
        4 regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        regattaNameColumn.setSortable(true);
        columnSortHandler.setComparator((Column)regattaNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        6 regattaCanBoatsOfCompetitorsChangePerRaceColumn = new /* Unavailable Anonymous Inner Class!! */;
        regattaCanBoatsOfCompetitorsChangePerRaceColumn.setSortable(true);
        columnSortHandler.setComparator((Column)regattaCanBoatsOfCompetitorsChangePerRaceColumn, (r1, r2) -> Boolean.valueOf(r1.canBoatsOfCompetitorsChangePerRace).compareTo(r2.canBoatsOfCompetitorsChangePerRace));
        7 competitorRegistrationTypeColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorRegistrationTypeColumn.setSortable(true);
        columnSortHandler.setComparator((Column)competitorRegistrationTypeColumn, (r1, r2) -> r1.competitorRegistrationType.ordinal() - r2.competitorRegistrationType.ordinal());
        8 startEndDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        startEndDateColumn.setSortable(true);
        columnSortHandler.setComparator((Column)startEndDateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        10 regattaBoatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        regattaBoatClassColumn.setSortable(true);
        columnSortHandler.setComparator((Column)regattaBoatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        12 rankingMetricColumn = new /* Unavailable Anonymous Inner Class!! */;
        rankingMetricColumn.setSortable(true);
        columnSortHandler.setComparator((Column)rankingMetricColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        14 courseAreasColumn = new /* Unavailable Anonymous Inner Class!! */;
        courseAreasColumn.setSortable(true);
        columnSortHandler.setComparator((Column)courseAreasColumn, (r1, r2) -> new NaturalComparator().compare(Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)r1.courseAreas, NamedDTO::getName)), Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)r2.courseAreas, NamedDTO::getName))));
        HasPermissions type = SecuredDomainType.REGATTA;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new RegattaConfigImagesBarCell(this.stringMessages), (UserService)userService);
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.editRegatta(arg_0));
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, regatta -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveRegatta(regatta.getName()))) {
                this.removeRegatta(regatta);
            }
        });
        actionsColumn.addAction("ACTION_CERTIFICATES_UPDATE", (HasPermissions.Action)HasPermissions.DefaultActions.READ, arg_0 -> this.handleBoatCertificateAssignment(arg_0));
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, regatta -> {
            this.presenter.getRegattasRefresher().reloadAndCallFillAll();
            this.presenter.getLeaderboardsRefresher().reloadAndCallFillAll();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, regattaDTO -> config.openOwnershipDialog((SecuredDTO)regattaDTO));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, regatta -> this.presenter.getRegattasRefresher().reloadAndCallFillAll(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, regattaDTO -> configACL.openDialog((SecuredDTO)regattaDTO));
        table.addColumn((Column)regattaSelectionCheckboxColumn, regattaSelectionCheckboxColumn.getHeader());
        table.addColumn((Column)regattaNameColumn, this.stringMessages.regattaName());
        table.addColumn((Column)regattaCanBoatsOfCompetitorsChangePerRaceColumn, this.stringMessages.canBoatsChange());
        table.addColumn((Column)competitorRegistrationTypeColumn, this.stringMessages.competitorRegistrationTypeShort());
        table.addColumn((Column)startEndDateColumn, String.valueOf(this.stringMessages.from()) + "/" + this.stringMessages.to());
        table.addColumn((Column)regattaBoatClassColumn, this.stringMessages.boatClass());
        table.addColumn((Column)courseAreasColumn, this.stringMessages.courseAreas());
        table.addColumn((Column)rankingMetricColumn, this.stringMessages.rankingMetric());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)table, (ColumnSortEvent.ListHandler)columnSortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        table.addColumn((Column)actionsColumn, this.stringMessages.actions());
        table.setSelectionModel((SelectionModel)regattaSelectionCheckboxColumn.getSelectionModel(), regattaSelectionCheckboxColumn.getSelectionManager());
        return table;
    }

    private void removeRegatta(RegattaDTO regatta) {
        RegattaName regattaIdentifier = new RegattaName(regatta.getName());
        this.sailingServiceWrite.removeRegatta((RegattaIdentifier)regattaIdentifier, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void editRegatta(RegattaDTO toBeEdited) {
        Displayer[] eventDisplayer;
        List existingRegattas = this.getAllRegattas();
        eventDisplayer = new Displayer[]{new /* Unavailable Anonymous Inner Class!! */};
        this.presenter.getEventsRefresher().addDisplayerAndCallFillOnInit(eventDisplayer[0]);
    }

    private void openEditRegattaDialog(RegattaDTO regatta, Collection<RegattaDTO> existingRegattas, Iterable<EventDTO> existingEvents) {
        RegattaWithSeriesAndFleetsEditDialog dialog = new RegattaWithSeriesAndFleetsEditDialog(regatta, existingRegattas, existingEvents, null, (SailingServiceAsync)this.sailingServiceWrite, this.userService, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void commitEditedRegatta(RegattaDTO editedRegatta) {
        RegattaName regattaName = new RegattaName(editedRegatta.getName());
        this.sailingServiceWrite.updateRegatta((RegattaIdentifier)regattaName, editedRegatta.startDate, editedRegatta.endDate, (List)Util.mapToArrayList((Iterable)editedRegatta.courseAreas, CourseAreaDTO::getId), editedRegatta.configuration, editedRegatta.buoyZoneRadiusInHullLengths, editedRegatta.useStartTimeInference, editedRegatta.controlTrackingFromStartAndFinishTimes, editedRegatta.autoRestartTrackingUponCompetitorSetChange, editedRegatta.registrationLinkSecret, editedRegatta.competitorRegistrationType, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        Iterator seriesIter = editedRegatta.series.iterator();
        19 r = new /* Unavailable Anonymous Inner Class!! */;
        r.run();
    }

    protected List<RegattaDTO> getSelectedRegattas() {
        return new ArrayList<RegattaDTO>(this.refreshableRegattaMultiSelectionModel.getSelectedSet());
    }

    public void fillRegattas(Iterable<RegattaDTO> regattas) {
        if (Util.isEmpty(regattas)) {
            this.regattaTable.setVisible(false);
            this.noRegattasLabel.setVisible(true);
        } else {
            this.regattaTable.setVisible(true);
            this.noRegattasLabel.setVisible(false);
        }
        ArrayList newAllRegattas = new ArrayList();
        Util.addAll(regattas, newAllRegattas);
        this.allRegattas = newAllRegattas;
        this.filterablePanelRegattas.updateAll((Iterable)this.allRegattas);
    }

    private void handleBoatCertificateAssignment(RegattaDTO regatta) {
        BoatCertificateAssignmentDialog dialog = new BoatCertificateAssignmentDialog((SailingServiceAsync)this.sailingServiceWrite, this.userService, this.stringMessages, this.errorReporter, (AbstractBoatCertificatesPanel)new RegattaBoatCertificatesPanel(this.sailingServiceWrite, this.userService, regatta, this.stringMessages, this.errorReporter));
        dialog.show();
    }

    public List<RegattaDTO> getAllRegattas() {
        return this.allRegattas;
    }

    public RefreshableMultiSelectionModel<RegattaDTO> getRefreshableMultiSelectionModel() {
        return this.refreshableRegattaMultiSelectionModel;
    }

    public CellTable<RegattaDTO> getRegattaTable() {
        return this.regattaTable;
    }

    static /* synthetic */ CellTable access$0(RegattaListComposite regattaListComposite) {
        return regattaListComposite.regattaTable;
    }

    static /* synthetic */ ErrorReporter access$1(RegattaListComposite regattaListComposite) {
        return regattaListComposite.errorReporter;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$2(RegattaListComposite regattaListComposite) {
        return regattaListComposite.presenter;
    }

    static /* synthetic */ void access$3(RegattaListComposite regattaListComposite, RegattaDTO regattaDTO, Collection collection, Iterable iterable) {
        regattaListComposite.openEditRegattaDialog(regattaDTO, collection, iterable);
    }

    static /* synthetic */ void access$4(RegattaListComposite regattaListComposite, RegattaDTO regattaDTO) {
        regattaListComposite.commitEditedRegatta(regattaDTO);
    }

    static /* synthetic */ SailingServiceWriteAsync access$5(RegattaListComposite regattaListComposite) {
        return regattaListComposite.sailingServiceWrite;
    }
}

