/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.ListBoxUtils;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public class RegattaConfigurationDialog
extends DataEntryDialog<DeviceConfigurationDTO.RegattaConfigurationDTO> {
    private final AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private final StringMessages stringMessages;
    private final DeviceConfigurationDTO.RegattaConfigurationDTO originalConfiguration;
    private VerticalPanel contentPanel;
    private ListBox racingProcedureListBox;
    private ListBox designerModeEntryListBox;
    private IntegerBox protestTimeInMinutesTextBox;
    private DisclosurePanel rrs26DisclosurePanel;
    private CheckBox rrs26EnabledBox;
    private ListBox rrs26ClassFlagListBox;
    private CheckBox rrs26RecallBox;
    private CheckBox rrs26ResultEntryBox;
    private ListBox rrs26StartModeFlagsBox;
    private DisclosurePanel swcStartDisclosurePanel;
    private CheckBox swcStartEnabledBox;
    private ListBox swcStartClassFlagListBox;
    private CheckBox swcStartRecallBox;
    private CheckBox swcStartResultEntryBox;
    private ListBox swcStartModeFlagsBox;
    private DisclosurePanel gateStartDisclosurePanel;
    private CheckBox gateStartEnabledBox;
    private ListBox gateStartClassFlagListBox;
    private CheckBox gateStartRecallBox;
    private CheckBox gateStartResultEntryBox;
    private CheckBox gateStartPathfinderBox;
    private CheckBox gateStartGolfDownBox;
    private DisclosurePanel essDisclosurePanel;
    private CheckBox essEnabledBox;
    private ListBox essClassFlagListBox;
    private CheckBox essRecallBox;
    private CheckBox essResultEntryBox;
    private DisclosurePanel basicDisclosurePanel;
    private CheckBox basicEnabledBox;
    private ListBox basicClassFlagListBox;
    private CheckBox basicRecallBox;
    private CheckBox basicResultEntryBox;
    private DisclosurePanel leagueDisclosurePanel;
    private CheckBox leagueEnabledBox;
    private ListBox leagueClassFlagListBox;
    private CheckBox leagueRecallBox;
    private CheckBox leagueResultEntryBox;

    public RegattaConfigurationDialog(DeviceConfigurationDTO.RegattaConfigurationDTO regattaConfiguration, StringMessages messages, DataEntryDialog.DialogCallback<DeviceConfigurationDTO.RegattaConfigurationDTO> callback) {
        super(messages.racingProcedureConfiguration(), "", messages.save(), messages.cancel(), null, callback);
        this.stringMessages = messages;
        this.originalConfiguration = regattaConfiguration;
    }

    protected Widget getAdditionalWidget() {
        this.contentPanel = new VerticalPanel();
        this.setupGeneral();
        this.setupRRS26();
        this.setupSWCStart();
        this.setupGateStart();
        this.setupESS();
        this.setupBasic();
        this.setupLeague();
        if (this.rrs26EnabledBox.getValue().booleanValue()) {
            this.rrs26DisclosurePanel.setOpen(true);
        }
        if (this.swcStartEnabledBox.getValue().booleanValue()) {
            this.swcStartDisclosurePanel.setOpen(true);
        }
        if (this.gateStartEnabledBox.getValue().booleanValue()) {
            this.gateStartDisclosurePanel.setOpen(true);
        }
        if (this.essEnabledBox.getValue().booleanValue()) {
            this.essDisclosurePanel.setOpen(true);
        }
        if (this.basicEnabledBox.getValue().booleanValue()) {
            this.basicDisclosurePanel.setOpen(true);
        }
        if (this.leagueEnabledBox.getValue().booleanValue()) {
            this.leagueDisclosurePanel.setOpen(true);
        }
        return this.contentPanel;
    }

    private void setupGeneral() {
        Grid grid = new Grid(3, 2);
        this.setupCourseDesignerListBox(grid, 0);
        this.setupRacingProcedureListBox(grid, 1);
        this.setupProtestTimeTextBox(grid, 2);
        this.contentPanel.add((Widget)grid);
    }

    private void setupRacingProcedureListBox(Grid grid, int gridRow) {
        this.racingProcedureListBox = new ListBox();
        this.racingProcedureListBox.setMultipleSelect(false);
        this.racingProcedureListBox.setWidth("100%");
        ListBoxUtils.setupRacingProcedureTypeListBox((ListBox)this.racingProcedureListBox, (RacingProcedureType)this.originalConfiguration.defaultRacingProcedureType, (String)this.stringMessages.dontoverwrite());
        this.racingProcedureListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.racingProcedure()));
        grid.setWidget(gridRow, 1, (Widget)this.racingProcedureListBox);
    }

    private void setupCourseDesignerListBox(Grid grid, int gridRow) {
        this.designerModeEntryListBox = new ListBox();
        this.designerModeEntryListBox.setMultipleSelect(false);
        this.designerModeEntryListBox.setWidth("100%");
        ListBoxUtils.setupCourseDesignerModeListBox((ListBox)this.designerModeEntryListBox, (CourseDesignerMode)this.originalConfiguration.defaultCourseDesignerMode, (String)this.stringMessages.dontoverwrite());
        this.designerModeEntryListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.courseDesignerMode()));
        grid.setWidget(gridRow, 1, (Widget)this.designerModeEntryListBox);
    }

    private void setupProtestTimeTextBox(Grid grid, int gridRow) {
        Integer protestTimeDurationInMinutes = this.originalConfiguration.defaultProtestTimeDuration == null ? null : Integer.valueOf((int)this.originalConfiguration.defaultProtestTimeDuration.asMinutes());
        this.protestTimeInMinutesTextBox = this.createIntegerBox(protestTimeDurationInMinutes, 3);
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.protestTimeInMinutes()));
        grid.setWidget(gridRow, 1, (Widget)this.protestTimeInMinutesTextBox);
    }

    private ListBox setupClassFlagListBox(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO config) {
        ListBox box = this.createListBox(false);
        Flags selectedFlag = null;
        if (config != null) {
            selectedFlag = config.classFlag;
        }
        ListBoxUtils.setupFlagsListBox((ListBox)box, (Flags)selectedFlag, (String)this.stringMessages.dontoverwrite());
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private CheckBox setupRecallBox(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO config) {
        CheckBox box = new CheckBox(this.stringMessages.activateIndividualRecall());
        if (config != null) {
            box.setValue(config.hasIndividualRecall);
        }
        box.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private CheckBox setupResultEntryBox(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO config) {
        CheckBox box = new CheckBox(this.stringMessages.activateResultEntry());
        if (config != null) {
            box.setValue(config.isResultEntryEnabled);
        }
        box.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private void setupRRS26() {
        this.rrs26DisclosurePanel = new DisclosurePanel(this.stringMessages.rrs26Start());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(4, 3);
        this.rrs26EnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.rrs26EnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.rrs26ClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.rrs26Configuration);
        this.rrs26ClassFlagListBox.setWidth("100%");
        this.rrs26RecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.rrs26Configuration);
        this.rrs26ResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.rrs26Configuration);
        this.setupRRS26StartModeFlags();
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.rrs26ClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("RRS26")));
        grid.setWidget(1, 0, (Widget)this.rrs26RecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.rrs26ResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        grid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.startmodeFlags()) + ":"));
        grid.setWidget(3, 1, (Widget)this.rrs26StartModeFlagsBox);
        grid.setWidget(3, 2, this.createHelpImage(this.stringMessages.startmodeFlagsHelpText()));
        this.rrs26EnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.rrs26Configuration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.rrs26EnabledBox, (Object)this.rrs26EnabledBox.getValue());
        panel.add((Widget)this.rrs26EnabledBox);
        panel.add((Widget)grid);
        this.rrs26DisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.rrs26DisclosurePanel);
    }

    private void setupRRS26StartModeFlags() {
        this.rrs26StartModeFlagsBox = new ListBox();
        this.rrs26StartModeFlagsBox.setMultipleSelect(true);
        this.rrs26StartModeFlagsBox.setWidth("100%");
        List selectedFlags = new ArrayList();
        if (this.originalConfiguration != null && this.originalConfiguration.rrs26Configuration != null && this.originalConfiguration.rrs26Configuration.startModeFlags != null) {
            selectedFlags = this.originalConfiguration.rrs26Configuration.startModeFlags;
        }
        ListBoxUtils.setupRRS26StartmodeFlagsListBox((ListBox)this.rrs26StartModeFlagsBox, selectedFlags);
        this.rrs26StartModeFlagsBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setupSWCStart() {
        this.swcStartDisclosurePanel = new DisclosurePanel(this.stringMessages.sailingWorldCupStart());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(4, 3);
        this.swcStartEnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.swcStartEnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.swcStartClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.swcStartConfiguration);
        this.swcStartClassFlagListBox.setWidth("100%");
        this.swcStartRecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.swcStartConfiguration);
        this.swcStartResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.swcStartConfiguration);
        this.setupSWCStartModeFlags();
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.swcStartClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("SWC Start")));
        grid.setWidget(1, 0, (Widget)this.swcStartRecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.swcStartResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        grid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.startmodeFlags()) + ":"));
        grid.setWidget(3, 1, (Widget)this.swcStartModeFlagsBox);
        grid.setWidget(3, 2, this.createHelpImage(this.stringMessages.startmodeFlagsHelpText()));
        this.swcStartEnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.swcStartConfiguration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.swcStartEnabledBox, (Object)this.swcStartEnabledBox.getValue());
        panel.add((Widget)this.swcStartEnabledBox);
        panel.add((Widget)grid);
        this.swcStartDisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.swcStartDisclosurePanel);
    }

    private void setupSWCStartModeFlags() {
        this.swcStartModeFlagsBox = new ListBox();
        this.swcStartModeFlagsBox.setMultipleSelect(true);
        this.swcStartModeFlagsBox.setWidth("100%");
        List selectedFlags = new ArrayList();
        if (this.originalConfiguration != null && this.originalConfiguration.swcStartConfiguration != null && this.originalConfiguration.swcStartConfiguration.startModeFlags != null) {
            selectedFlags = this.originalConfiguration.swcStartConfiguration.startModeFlags;
        }
        ListBoxUtils.setupSWCStartmodeFlagsListBox((ListBox)this.swcStartModeFlagsBox, selectedFlags);
        this.swcStartModeFlagsBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setupGateStart() {
        this.gateStartDisclosurePanel = new DisclosurePanel(this.stringMessages.gateStart());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(5, 3);
        this.gateStartEnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.gateStartEnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.gateStartClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.gateStartConfiguration);
        this.gateStartClassFlagListBox.setWidth("100%");
        this.gateStartRecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.gateStartConfiguration);
        this.gateStartResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.gateStartConfiguration);
        this.gateStartPathfinderBox = this.createCheckbox(this.stringMessages.activatePathfinder());
        if (this.originalConfiguration.gateStartConfiguration != null) {
            this.gateStartPathfinderBox.setValue(this.originalConfiguration.gateStartConfiguration.hasPathfinder);
        }
        this.gateStartGolfDownBox = this.createCheckbox(this.stringMessages.hasAdditionalGolfDownTime());
        if (this.originalConfiguration.gateStartConfiguration != null) {
            this.gateStartGolfDownBox.setValue(this.originalConfiguration.gateStartConfiguration.hasAdditionalGolfDownTime);
        }
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.gateStartClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("Gate Start")));
        grid.setWidget(1, 0, (Widget)this.gateStartRecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.gateStartResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        grid.setWidget(3, 0, (Widget)this.gateStartPathfinderBox);
        grid.setWidget(3, 2, this.createHelpImage(this.stringMessages.pathfinderHelpText()));
        grid.setWidget(4, 0, (Widget)this.gateStartGolfDownBox);
        grid.setWidget(4, 2, this.createHelpImage(this.stringMessages.additionalGolfDownTimeHelpText()));
        this.gateStartEnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.gateStartConfiguration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.gateStartEnabledBox, (Object)this.gateStartEnabledBox.getValue());
        panel.add((Widget)this.gateStartEnabledBox);
        panel.add((Widget)grid);
        this.gateStartDisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.gateStartDisclosurePanel);
    }

    private void setupESS() {
        this.essDisclosurePanel = new DisclosurePanel(this.stringMessages.essStart());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(3, 3);
        this.essEnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.essEnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.essClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.essConfiguration);
        this.essClassFlagListBox.setWidth("100%");
        this.essRecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.essConfiguration);
        this.essResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.essConfiguration);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.essClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("ESS")));
        grid.setWidget(1, 0, (Widget)this.essRecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.essResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        this.essEnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.essConfiguration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.essEnabledBox, (Object)this.essEnabledBox.getValue());
        panel.add((Widget)this.essEnabledBox);
        panel.add((Widget)grid);
        this.essDisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.essDisclosurePanel);
    }

    private void setupBasic() {
        this.basicDisclosurePanel = new DisclosurePanel(this.stringMessages.basicStart());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(3, 3);
        this.basicEnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.basicEnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.basicClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.basicConfiguration);
        this.basicClassFlagListBox.setWidth("100%");
        this.basicRecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.basicConfiguration);
        this.basicResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.basicConfiguration);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.basicClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("basic start")));
        grid.setWidget(1, 0, (Widget)this.basicRecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.basicResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        this.basicEnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.basicConfiguration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.basicEnabledBox, (Object)this.basicEnabledBox.getValue());
        panel.add((Widget)this.basicEnabledBox);
        panel.add((Widget)grid);
        this.basicDisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.basicDisclosurePanel);
    }

    private void setupLeague() {
        this.leagueDisclosurePanel = new DisclosurePanel(this.stringMessages.leagueStart());
        VerticalPanel panel = new VerticalPanel();
        Grid grid = new Grid(3, 3);
        this.leagueEnabledBox = new CheckBox(this.stringMessages.setConfiguration());
        this.leagueEnabledBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.leagueClassFlagListBox = this.setupClassFlagListBox(this.originalConfiguration == null ? null : this.originalConfiguration.leagueConfiguration);
        this.leagueClassFlagListBox.setWidth("100%");
        this.leagueRecallBox = this.setupRecallBox(this.originalConfiguration == null ? null : this.originalConfiguration.leagueConfiguration);
        this.leagueResultEntryBox = this.setupResultEntryBox(this.originalConfiguration == null ? null : this.originalConfiguration.leagueConfiguration);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.classFlag()) + ":"));
        grid.setWidget(0, 1, (Widget)this.leagueClassFlagListBox);
        grid.setWidget(0, 2, this.createHelpImage(this.stringMessages.classFlagHelpText("league start")));
        grid.setWidget(1, 0, (Widget)this.leagueRecallBox);
        grid.setWidget(1, 2, this.createHelpImage(this.stringMessages.individualRecallHelpText()));
        grid.setWidget(2, 0, (Widget)this.leagueResultEntryBox);
        grid.setWidget(2, 2, this.createHelpImage(this.stringMessages.resultEntryHelpText()));
        this.leagueEnabledBox.setValue(Boolean.valueOf(this.originalConfiguration != null && this.originalConfiguration.leagueConfiguration != null));
        ValueChangeEvent.fire((HasValueChangeHandlers)this.leagueEnabledBox, (Object)this.leagueEnabledBox.getValue());
        panel.add((Widget)this.leagueEnabledBox);
        panel.add((Widget)grid);
        this.leagueDisclosurePanel.add((Widget)panel);
        this.contentPanel.add((Widget)this.leagueDisclosurePanel);
    }

    private Widget createHelpImage(String tooltip) {
        Image help = new Image();
        help.setResource(this.resources.help());
        help.setTitle(tooltip);
        help.setAltText(tooltip);
        return help;
    }

    protected DeviceConfigurationDTO.RegattaConfigurationDTO getResult() {
        int i;
        ArrayList<Flags> flags;
        DeviceConfigurationDTO.RegattaConfigurationDTO result = new DeviceConfigurationDTO.RegattaConfigurationDTO();
        int index = this.racingProcedureListBox.getSelectedIndex();
        if (index >= 0) {
            RacingProcedureType type = RacingProcedureType.valueOf((String)this.racingProcedureListBox.getValue(index));
            result.defaultRacingProcedureType = type == RacingProcedureType.UNKNOWN ? null : type;
        }
        result.defaultRacingProcedureType = this.getSelectedRacingProcedure();
        index = this.designerModeEntryListBox.getSelectedIndex();
        if (index >= 0) {
            CourseDesignerMode mode = CourseDesignerMode.valueOf((String)this.designerModeEntryListBox.getValue(index));
            result.defaultCourseDesignerMode = mode == CourseDesignerMode.UNKNOWN ? null : mode;
        }
        Duration duration = result.defaultProtestTimeDuration = this.protestTimeInMinutesTextBox.getValue() == null ? null : Duration.ONE_MINUTE.times((long)((Integer)this.protestTimeInMinutesTextBox.getValue()).intValue());
        if (this.rrs26EnabledBox.getValue().booleanValue()) {
            result.rrs26Configuration = new DeviceConfigurationDTO.RegattaConfigurationDTO.RRS26ConfigurationDTO();
            this.getRacingProcedureConfigurationResults((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)result.rrs26Configuration, this.rrs26ClassFlagListBox, this.rrs26RecallBox, this.rrs26ResultEntryBox);
            flags = new ArrayList<Flags>();
            i = 0;
            while (i < this.rrs26StartModeFlagsBox.getItemCount()) {
                if (this.rrs26StartModeFlagsBox.isItemSelected(i)) {
                    flags.add(Flags.valueOf((String)this.rrs26StartModeFlagsBox.getValue(i)));
                }
                ++i;
            }
            ArrayList<Flags> arrayList = result.rrs26Configuration.startModeFlags = flags.isEmpty() ? null : flags;
        }
        if (this.swcStartEnabledBox.getValue().booleanValue()) {
            result.swcStartConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.SWCStartConfigurationDTO();
            this.getRacingProcedureConfigurationResults((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)result.swcStartConfiguration, this.swcStartClassFlagListBox, this.swcStartRecallBox, this.swcStartResultEntryBox);
            flags = new ArrayList();
            i = 0;
            while (i < this.swcStartModeFlagsBox.getItemCount()) {
                if (this.swcStartModeFlagsBox.isItemSelected(i)) {
                    flags.add(Flags.valueOf((String)this.swcStartModeFlagsBox.getValue(i)));
                }
                ++i;
            }
            ArrayList<Flags> arrayList = result.swcStartConfiguration.startModeFlags = flags.isEmpty() ? null : flags;
        }
        if (this.gateStartEnabledBox.getValue().booleanValue()) {
            result.gateStartConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.GateStartConfigurationDTO();
            this.getRacingProcedureConfigurationResults((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)result.gateStartConfiguration, this.gateStartClassFlagListBox, this.gateStartRecallBox, this.gateStartResultEntryBox);
            result.gateStartConfiguration.hasPathfinder = this.gateStartPathfinderBox.getValue();
            result.gateStartConfiguration.hasAdditionalGolfDownTime = this.gateStartGolfDownBox.getValue();
        }
        if (this.essEnabledBox.getValue().booleanValue()) {
            result.essConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.ESSConfigurationDTO();
            this.getRacingProcedureConfigurationResults((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)result.essConfiguration, this.essClassFlagListBox, this.essRecallBox, this.essResultEntryBox);
        }
        if (this.basicEnabledBox.getValue().booleanValue()) {
            result.basicConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO();
            this.getRacingProcedureConfigurationResults(result.basicConfiguration, this.basicClassFlagListBox, this.basicRecallBox, this.basicResultEntryBox);
        }
        if (this.leagueEnabledBox.getValue().booleanValue()) {
            result.leagueConfiguration = new DeviceConfigurationDTO.RegattaConfigurationDTO.LeagueConfigurationDTO();
            this.getRacingProcedureConfigurationResults((DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO)result.leagueConfiguration, this.leagueClassFlagListBox, this.leagueRecallBox, this.leagueResultEntryBox);
        }
        return result;
    }

    private RacingProcedureType getSelectedRacingProcedure() {
        int index = this.racingProcedureListBox.getSelectedIndex();
        if (index >= 0) {
            RacingProcedureType type = RacingProcedureType.valueOf((String)this.racingProcedureListBox.getValue(index));
            return type == RacingProcedureType.UNKNOWN ? null : type;
        }
        return null;
    }

    private void getRacingProcedureConfigurationResults(DeviceConfigurationDTO.RegattaConfigurationDTO.RacingProcedureConfigurationDTO target, ListBox classListBox, CheckBox recallBox, CheckBox resultEntryBox) {
        int index = classListBox.getSelectedIndex();
        if (index >= 0) {
            Flags flag = Flags.valueOf((String)classListBox.getValue(index));
            target.classFlag = flag == Flags.NONE ? null : flag;
        }
        target.hasIndividualRecall = recallBox.getValue();
        target.isResultEntryEnabled = resultEntryBox.getValue();
    }

    static /* synthetic */ ListBox access$1(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.rrs26ClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$2(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.rrs26RecallBox;
    }

    static /* synthetic */ CheckBox access$3(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.rrs26ResultEntryBox;
    }

    static /* synthetic */ ListBox access$4(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.rrs26StartModeFlagsBox;
    }

    static /* synthetic */ ListBox access$5(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.swcStartClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$6(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.swcStartRecallBox;
    }

    static /* synthetic */ CheckBox access$7(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.swcStartResultEntryBox;
    }

    static /* synthetic */ ListBox access$8(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.swcStartModeFlagsBox;
    }

    static /* synthetic */ ListBox access$9(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.gateStartClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$10(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.gateStartRecallBox;
    }

    static /* synthetic */ CheckBox access$11(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.gateStartResultEntryBox;
    }

    static /* synthetic */ CheckBox access$12(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.gateStartPathfinderBox;
    }

    static /* synthetic */ CheckBox access$13(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.gateStartGolfDownBox;
    }

    static /* synthetic */ ListBox access$14(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.essClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$15(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.essRecallBox;
    }

    static /* synthetic */ CheckBox access$16(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.essResultEntryBox;
    }

    static /* synthetic */ ListBox access$17(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.basicClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$18(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.basicRecallBox;
    }

    static /* synthetic */ CheckBox access$19(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.basicResultEntryBox;
    }

    static /* synthetic */ ListBox access$20(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.leagueClassFlagListBox;
    }

    static /* synthetic */ CheckBox access$21(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.leagueRecallBox;
    }

    static /* synthetic */ CheckBox access$22(RegattaConfigurationDialog regattaConfigurationDialog) {
        return regattaConfigurationDialog.leagueResultEntryBox;
    }
}

