/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorAndBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithToolTipDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractCompetitorRegistrationDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorRegistrationsPanel;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogCompetitorRegistrationDialog;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaceLogCompetitorRegistrationDialog
extends AbstractCompetitorRegistrationDialog {
    private String fleetName;
    private String raceColumnName;
    private CheckBox competitorRegistrationInRaceLogCheckBox;
    private final Map<String, Set<CompetitorDTO>> fleetNameWithCompetitors;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;

    public RaceLogCompetitorRegistrationDialog(String boatClass, SailingServiceWriteAsync sailingService, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean editable, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, String raceColumnName, String fleetName, List<FleetDTO> fleets, DataEntryDialog.DialogCallback<Set<CompetitorDTO>> callback) {
        this(sailingService, userService, competitorsRefresher, boatsRefresher, stringMessages, errorReporter, editable, callback, leaderboardName, canBoatsOfCompetitorsChangePerRace, boatClass, raceColumnName, fleetName, fleets, new Validator(stringMessages));
    }

    public RaceLogCompetitorRegistrationDialog(SailingServiceWriteAsync sailingService, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean editable, DataEntryDialog.DialogCallback<Set<CompetitorDTO>> callback, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, String boatClass, String raceColumnName, String fleetName, List<FleetDTO> fleets, Validator validator) {
        super(sailingService, userService, competitorsRefresher, boatsRefresher, stringMessages, errorReporter, editable, callback, leaderboardName, canBoatsOfCompetitorsChangePerRace, boatClass, canBoatsOfCompetitorsChangePerRace ? stringMessages.actionContinueToBoatAssignment() : stringMessages.save(), (DataEntryDialog.Validator)validator, cb -> RaceLogCompetitorRegistrationDialog.getRegisteredCompetitors((SailingServiceWriteAsync)sailingService, (String)leaderboardName, (String)raceColumnName, (String)fleetName, (Util.Pair)cb));
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.raceColumnName = raceColumnName;
        this.fleetName = fleetName;
        this.fleetNameWithCompetitors = this.findCompetitorsFromTheSameRaceColumn(fleets);
        validator.setCompetitorRegistrationInRaceLogCheckBox(this.getOrCreateCompetitorRegistrationInRaceLogCheckBox(stringMessages));
        validator.setFleetWithCompetitors(this.fleetNameWithCompetitors);
        this.setupCompetitorRegistationsOnRaceCheckbox();
    }

    protected Widget[] getAdditionalWidgetsToInsertAboveCompetitorTables(StringMessages stringMessages) {
        return new Widget[]{this.getOrCreateCompetitorRegistrationInRaceLogCheckBox(stringMessages)};
    }

    private CheckBox getOrCreateCompetitorRegistrationInRaceLogCheckBox(StringMessages stringMessages) {
        if (this.competitorRegistrationInRaceLogCheckBox == null) {
            this.competitorRegistrationInRaceLogCheckBox = this.createCheckbox(stringMessages.registerCompetitorsOnRace());
        }
        return this.competitorRegistrationInRaceLogCheckBox;
    }

    private Map<String, Set<CompetitorDTO>> findCompetitorsFromTheSameRaceColumn(List<FleetDTO> fleets) {
        HashMap<String, Set<CompetitorDTO>> result = new HashMap<String, Set<CompetitorDTO>>();
        HashMap<String, 1> callbacksForFleetNames = new HashMap<String, 1>();
        for (FleetDTO fleetDTO : fleets) {
            String curFleetName = fleetDTO.getName();
            if (curFleetName.equals(this.fleetName)) continue;
            callbacksForFleetNames.put(curFleetName, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!callbacksForFleetNames.isEmpty()) {
            new /* Unavailable Anonymous Inner Class!! */;
            for (Map.Entry entry : callbacksForFleetNames.entrySet()) {
                this.sailingService.getCompetitorRegistrationsForRace(this.leaderboardName, this.raceColumnName, (String)entry.getKey(), (AsyncCallback)entry.getValue());
            }
        }
        return result;
    }

    private void grayOutRows() {
        ArrayList<CompetitorWithToolTipDTO> competitors = new ArrayList<CompetitorWithToolTipDTO>();
        for (Map.Entry entry : this.fleetNameWithCompetitors.entrySet()) {
            if (((String)entry.getKey()).equals(this.fleetName)) continue;
            for (CompetitorDTO competitor : (Set)entry.getValue()) {
                competitors.add(new CompetitorWithToolTipDTO(competitor, this.stringMessages.competitorToolTipMessage(competitor.getName(), this.fleetName, (String)entry.getKey(), this.raceColumnName)));
            }
        }
        this.competitorRegistrationsPanel.grayOutCompetitorsFromPool(competitors);
        this.competitorRegistrationsPanel.grayOutCompetitorsFromRegistered(competitors);
    }

    private static void getRegisteredCompetitors(SailingServiceWriteAsync sailingService, String leaderboardName, String raceColumnName, String fleetName, Util.Pair<CompetitorRegistrationsPanel, AsyncCallback<Collection<CompetitorDTO>>> callback) {
        if (((CompetitorRegistrationsPanel)callback.getA()).showOnlyCompetitorsOfLog()) {
            sailingService.getCompetitorRegistrationsInRaceLog(leaderboardName, raceColumnName, fleetName, RaceLogCompetitorRegistrationDialog.extractCompetitorDTOFromCompetitorAndBoatDTO((AsyncCallback)((AsyncCallback)callback.getB())));
        } else {
            sailingService.getCompetitorRegistrationsForRace(leaderboardName, raceColumnName, fleetName, RaceLogCompetitorRegistrationDialog.extractCompetitorDTOFromCompetitorAndBoatDTO((AsyncCallback)((AsyncCallback)callback.getB())));
        }
    }

    private static AsyncCallback<Collection<CompetitorAndBoatDTO>> extractCompetitorDTOFromCompetitorAndBoatDTO(AsyncCallback<Collection<CompetitorDTO>> callback) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void setupCompetitorRegistationsOnRaceCheckbox() {
        this.sailingService.areCompetitorRegistrationsEnabledForRace(this.leaderboardName, this.raceColumnName, this.fleetName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.getOrCreateCompetitorRegistrationInRaceLogCheckBox(this.stringMessages).addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Set<CompetitorDTO> getResult() {
        if (this.getOrCreateCompetitorRegistrationInRaceLogCheckBox(this.stringMessages).getValue().booleanValue()) {
            return super.getResult();
        }
        return Collections.emptySet();
    }

    static /* synthetic */ void access$0(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog) {
        raceLogCompetitorRegistrationDialog.grayOutRows();
    }

    static /* synthetic */ ErrorReporter access$1(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog) {
        return raceLogCompetitorRegistrationDialog.errorReporter;
    }

    static /* synthetic */ StringMessages access$2(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog) {
        return raceLogCompetitorRegistrationDialog.stringMessages;
    }

    static /* synthetic */ CheckBox access$3(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog, StringMessages stringMessages) {
        return raceLogCompetitorRegistrationDialog.getOrCreateCompetitorRegistrationInRaceLogCheckBox(stringMessages);
    }

    static /* synthetic */ String access$4(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog) {
        return raceLogCompetitorRegistrationDialog.raceColumnName;
    }

    static /* synthetic */ String access$5(RaceLogCompetitorRegistrationDialog raceLogCompetitorRegistrationDialog) {
        return raceLogCompetitorRegistrationDialog.fleetName;
    }
}

