/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.DataEntryDialogWithDateTimeBox;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import java.util.Date;

public class PositionEntryDialog
extends DataEntryDialogWithDateTimeBox<Util.Pair<Position, TimePoint>> {
    private final DoubleBox lat;
    private final DoubleBox lng;
    private final DateAndTimeInput timePointBox;
    private final StringMessages stringMessages;
    private static final double ERROR_VAL = Double.MIN_VALUE;

    public PositionEntryDialog(String title, StringMessages stringMessages, DataEntryDialog.DialogCallback<Util.Pair<Position, TimePoint>> callback) {
        super(title, title, stringMessages.save(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.stringMessages = stringMessages;
        this.lat = this.createDoubleBox(10);
        this.lng = this.createDoubleBox(10);
        this.timePointBox = this.createDateTimeBox(new Date(), DateTimeInput.Accuracy.SECONDS);
    }

    protected Util.Pair<Position, TimePoint> getResult() {
        Double latDeg = (Double)this.lat.getValue();
        Double lngDeg = (Double)this.lng.getValue();
        return new Util.Pair((Object)new DegreePosition(latDeg == null ? Double.MIN_VALUE : latDeg, lngDeg == null ? Double.MIN_VALUE : lngDeg), (Object)(this.timePointBox.getValue() == null ? null : new MillisecondsTimePoint(this.timePointBox.getValue())));
    }

    protected Widget getAdditionalWidget() {
        Grid grid = new Grid(3, 2);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.latitude()) + " (" + this.stringMessages.degreesShort() + ")"));
        grid.setWidget(0, 1, (Widget)this.lat);
        grid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.longitude()) + " (" + this.stringMessages.degreesShort() + ")"));
        grid.setWidget(1, 1, (Widget)this.lng);
        grid.setWidget(2, 0, (Widget)new Label(this.stringMessages.time()));
        grid.setWidget(2, 1, (Widget)this.timePointBox);
        return grid;
    }
}

