/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorDescriptorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorImportMatcher;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.MatchImportedCompetitorsDialog;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatchImportedCompetitorsDialog
extends DataEntryDialog<Util.Pair<Map<CompetitorDescriptor, CompetitorDTO>, String>> {
    private CompetitorDescriptorTableWrapper<RefreshableMultiSelectionModel<CompetitorDescriptor>> importedCompetitorsTable;
    private CompetitorTableWrapper<RefreshableSingleSelectionModel<CompetitorDTO>> existingCompetitorsTable;
    private TextBox searchTagField;
    private final StringMessages stringMessages;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final Iterable<CompetitorDescriptor> competitorDescriptors;
    private final CompetitorImportMatcher competitorImportMatcher;
    private final Map<CompetitorDescriptor, CompetitorDTO> existingCompetitorsByImported = new HashMap();
    private final Refresher<CompetitorDTO> competitorsRefresher;
    private final Refresher<BoatDTO> boatsRefresher;

    public MatchImportedCompetitorsDialog(Iterable<CompetitorDescriptor> competitorDescriptors, Iterable<CompetitorDTO> existingCompetitor, String localizedHint, StringMessages stringMessages, SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, ErrorReporter errorReporter, DataEntryDialog.DialogCallback<Util.Pair<Map<CompetitorDescriptor, CompetitorDTO>, String>> callback) {
        super(stringMessages.importCompetitors(), String.join((CharSequence)"\n", stringMessages.chooseWhichCompetitorsShouldBeImported(), localizedHint), stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.stringMessages = stringMessages;
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.errorReporter = errorReporter;
        this.competitorDescriptors = competitorDescriptors;
        this.competitorsRefresher = competitorsRefresher;
        this.boatsRefresher = boatsRefresher;
        this.competitorImportMatcher = new CompetitorImportMatcher(existingCompetitor);
    }

    protected void refreshInImportTable(CompetitorDescriptor competitor) {
        List importedCompetitors = this.importedCompetitorsTable.getDataProvider().getList();
        importedCompetitors.set(importedCompetitors.indexOf(competitor), competitor);
    }

    protected Widget getAdditionalWidget() {
        this.existingCompetitorsTable = new CompetitorTableWrapper(this.sailingServiceWrite, this.userService, this.competitorsRefresher, this.boatsRefresher, this.stringMessages, this.errorReporter, false, true, false, false);
        1 linker = new /* Unavailable Anonymous Inner Class!! */;
        this.importedCompetitorsTable = new CompetitorDescriptorTableWrapper(this.competitorImportMatcher, this.sailingServiceWrite, this.stringMessages, this.errorReporter, true, false, (CompetitorDescriptorTableWrapper.CompetitorsToImportToExistingLinking)linker);
        this.importedCompetitorsTable.refreshCompetitorDescriptorList(this.competitorDescriptors);
        RefreshableMultiSelectionModel importedCompetitorSelectionModel = (RefreshableMultiSelectionModel)this.importedCompetitorsTable.getSelectionModel();
        importedCompetitorSelectionModel.addSelectionChangeHandler(this.getHandlerForImportedCompetitorsModel(importedCompetitorSelectionModel));
        RefreshableSingleSelectionModel existingCompetitorSelectionModel = (RefreshableSingleSelectionModel)this.existingCompetitorsTable.getSelectionModel();
        existingCompetitorSelectionModel.addSelectionChangeHandler(this.getHandlerForExistingCompetitorsModel(importedCompetitorSelectionModel, existingCompetitorSelectionModel));
        FlowPanel mainPanel = new FlowPanel();
        HorizontalPanel competitorImportPanel = new HorizontalPanel();
        CaptionPanel existingCompetitorsPanel = new CaptionPanel(this.stringMessages.existingCompetitors());
        CaptionPanel importedCompetitorsPanel = new CaptionPanel(this.stringMessages.importedCompetitors());
        existingCompetitorsPanel.add((IsWidget)this.existingCompetitorsTable);
        importedCompetitorsPanel.add((IsWidget)this.importedCompetitorsTable);
        ScrollPanel scrollCompetitorRegistrationPanel = new ScrollPanel((Widget)importedCompetitorsPanel);
        scrollCompetitorRegistrationPanel.setSize("100%", "500px");
        ScrollPanel scrollExistingCompetitorRegistrationPanel = new ScrollPanel((Widget)existingCompetitorsPanel);
        scrollCompetitorRegistrationPanel.setSize("100%", "500px");
        competitorImportPanel.add((Widget)scrollCompetitorRegistrationPanel);
        competitorImportPanel.add((Widget)scrollExistingCompetitorRegistrationPanel);
        this.searchTagField = this.createTextBox("", 40);
        this.searchTagField.getElement().setPropertyString("placeholder", this.stringMessages.searchTagForImportedCompetitorPlaceholder());
        Label searchTagLabel = new Label(this.stringMessages.searchTag());
        HorizontalPanel searchTagPanel = new HorizontalPanel();
        searchTagPanel.add((Widget)searchTagLabel);
        searchTagPanel.add((Widget)this.searchTagField);
        mainPanel.add((Widget)searchTagPanel);
        mainPanel.add((Widget)competitorImportPanel);
        return mainPanel;
    }

    private SelectionChangeEvent.Handler getHandlerForExistingCompetitorsModel(RefreshableMultiSelectionModel<CompetitorDescriptor> importedCompetitorSelectionModel, RefreshableSingleSelectionModel<CompetitorDTO> existingCompetitorSelectionModel) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SelectionChangeEvent.Handler getHandlerForImportedCompetitorsModel(RefreshableMultiSelectionModel<CompetitorDescriptor> importedCompetitorSelectionModel) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Util.Pair<Map<CompetitorDescriptor, CompetitorDTO>, String> getResult() {
        HashMap<CompetitorDescriptor, CompetitorDTO> result = new HashMap<CompetitorDescriptor, CompetitorDTO>();
        for (CompetitorDescriptor competitorDescriptor : ((RefreshableMultiSelectionModel)this.importedCompetitorsTable.getSelectionModel()).getSelectedSet()) {
            result.put(competitorDescriptor, (CompetitorDTO)this.existingCompetitorsByImported.get(competitorDescriptor));
        }
        return new Util.Pair(result, (Object)this.searchTagField.getText());
    }

    static /* synthetic */ Map access$1(MatchImportedCompetitorsDialog matchImportedCompetitorsDialog) {
        return matchImportedCompetitorsDialog.existingCompetitorsByImported;
    }

    static /* synthetic */ CompetitorTableWrapper access$2(MatchImportedCompetitorsDialog matchImportedCompetitorsDialog) {
        return matchImportedCompetitorsDialog.existingCompetitorsTable;
    }

    static /* synthetic */ CompetitorImportMatcher access$3(MatchImportedCompetitorsDialog matchImportedCompetitorsDialog) {
        return matchImportedCompetitorsDialog.competitorImportMatcher;
    }
}

